/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Path;
import net.thevpc.nuts.NutsIOCompressAction;
import net.thevpc.nuts.NutsIOCopyAction;
import net.thevpc.nuts.NutsIODeleteAction;
import net.thevpc.nuts.NutsIOHashAction;
import net.thevpc.nuts.NutsIOManager;
import net.thevpc.nuts.NutsIOProcessAction;
import net.thevpc.nuts.NutsIOUncompressAction;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInputAction;
import net.thevpc.nuts.NutsMemoryPrintStream;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsMonitorAction;
import net.thevpc.nuts.NutsOutputAction;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathFactory;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsTempAction;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.runtime.core.io.FilePath;
import net.thevpc.nuts.runtime.core.io.URLPath;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsIOModel;
import net.thevpc.nuts.runtime.standalone.io.NutsByteArrayPrintStream;
import net.thevpc.nuts.runtime.standalone.io.NutsPrintStreamBase;
import net.thevpc.nuts.runtime.standalone.io.NutsPrintStreamRaw;
import net.thevpc.nuts.runtime.standalone.io.NutsPrintStreamRendered;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsIOManager
implements NutsIOManager {
    private DefaultNutsIOModel model;
    private NutsSession session;

    public DefaultNutsIOManager(DefaultNutsIOModel model) {
        this.model = model;
    }

    public DefaultNutsIOModel getModel() {
        return this.model;
    }

    public int getSupportLevel(NutsSupportLevelContext<Object> criteria) {
        return 10;
    }

    public NutsPath path(String path) {
        this.checkSession();
        return this.path(path, null);
    }

    public NutsPath path(File path) {
        this.checkSession();
        if (path == null) {
            return null;
        }
        return new FilePath(path.toPath(), this.getSession());
    }

    public NutsPath path(Path path) {
        this.checkSession();
        if (path == null) {
            return null;
        }
        return new FilePath(path, this.getSession());
    }

    public NutsPath path(URL path) {
        this.checkSession();
        if (path == null) {
            return null;
        }
        return new URLPath(path, this.getSession());
    }

    public NutsPath path(String path, ClassLoader classLoader) {
        this.checkSession();
        if (path == null || path.trim().isEmpty()) {
            return null;
        }
        NutsPath p = this.model.resolve(path, this.getSession(), classLoader);
        if (p == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve path from %s", (Object[])new Object[]{path}));
        }
        return p;
    }

    public String expandPath(String path) {
        this.checkSession();
        return this.model.expandPath(path);
    }

    public String expandPath(String path, String baseFolder) {
        this.checkSession();
        return this.model.expandPath(path, baseFolder);
    }

    public InputStream nullInputStream() {
        this.checkSession();
        return this.model.nullInputStream();
    }

    public NutsPrintStream nullPrintStream() {
        this.checkSession();
        return this.model.nullPrintStream();
    }

    public NutsPrintStream createPrintStream(OutputStream out, NutsTerminalMode expectedMode) {
        this.checkSession();
        return this.model.createPrintStream(out, expectedMode, this.session);
    }

    public NutsPrintStream createPrintStream(OutputStream out) {
        this.checkSession();
        return new NutsPrintStreamRaw(out, null, null, this.session, new NutsPrintStreamBase.Bindings());
    }

    public NutsPrintStream createPrintStream(Writer out) {
        this.checkSession();
        return this.model.createPrintStream(out, NutsTerminalMode.INHERITED, this.session);
    }

    public NutsMemoryPrintStream createMemoryPrintStream() {
        this.checkSession();
        return new NutsByteArrayPrintStream(this.getSession());
    }

    public NutsTempAction tmp() {
        this.checkSession();
        return this.model.tmp().setSession(this.session);
    }

    public NutsIOCopyAction copy() {
        return this.model.copy().setSession(this.session);
    }

    public NutsIOProcessAction ps() {
        return this.model.ps().setSession(this.session);
    }

    public NutsIOCompressAction compress() {
        return this.model.compress().setSession(this.session);
    }

    public NutsIOUncompressAction uncompress() {
        return this.model.uncompress().setSession(this.session);
    }

    public NutsIODeleteAction delete() {
        return this.model.delete().setSession(this.session);
    }

    public NutsMonitorAction monitor() {
        return this.model.monitor().setSession(this.session);
    }

    public NutsIOHashAction hash() {
        return this.model.hash().setSession(this.session);
    }

    public NutsInputAction input() {
        return this.model.input().setSession(this.session);
    }

    public NutsOutputAction output() {
        return this.model.output().setSession(this.session);
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsIOManager setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public NutsPrintStream stdout() {
        return this.model.stdout();
    }

    public NutsPrintStream stderr() {
        return this.model.stderr();
    }

    public InputStream stdin() {
        return this.model.stdin();
    }

    public boolean isStandardOutputStream(NutsPrintStream out) {
        if (out == null) {
            return false;
        }
        if (out == this.model.stdout()) {
            return true;
        }
        if (out == this.model.bootModel.stdout()) {
            return true;
        }
        if (out instanceof NutsPrintStreamRendered) {
            return this.isStandardOutputStream(((NutsPrintStreamRendered)out).getBase());
        }
        return false;
    }

    public boolean isStandardErrorStream(NutsPrintStream out) {
        if (out == null) {
            return false;
        }
        if (out == this.model.stderr()) {
            return true;
        }
        if (out == this.model.bootModel.stderr()) {
            return true;
        }
        if (out instanceof NutsPrintStreamRendered) {
            return this.isStandardOutputStream(((NutsPrintStreamRendered)out).getBase());
        }
        return false;
    }

    public boolean isStandardInputStream(InputStream in) {
        return in == this.model.stdin();
    }

    public NutsIOManager addPathFactory(NutsPathFactory pathFactory) {
        this.model.addPathFactory(pathFactory);
        return this;
    }

    public NutsIOManager removePathFactory(NutsPathFactory pathFactory) {
        this.model.removePathFactory(pathFactory);
        return this;
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.getSession());
    }
}

