/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.logging.Level;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsIODeleteAction;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.AbstractNutsIODeleteAction;

public class DefaultNutsIODeleteAction
extends AbstractNutsIODeleteAction {
    private Exception error;

    public DefaultNutsIODeleteAction(NutsWorkspace ws) {
        super(ws);
    }

    private void grabException(IOException e) {
        this.error = e;
        if (this.isFailFast()) {
            throw new UncheckedIOException(e);
        }
    }

    public NutsIODeleteAction run() {
        block8: {
            this.checkSession();
            Path t = CoreIOUtils.toPath(this.getTarget());
            if (t == null) {
                if (this.getTarget() == null) {
                    throw new NutsException(this.getSession(), NutsMessage.formatted((String)"missing target to delete"));
                }
                throw new NutsException(this.getSession(), NutsMessage.cstyle((String)"unsupported target to delete: %s", (Object[])new Object[]{this.getTarget()}));
            }
            if (!Files.exists(t, new LinkOption[0])) {
                this.grabException(new FileNotFoundException(t.toString()));
                return this;
            }
            if (Files.isRegularFile(t, new LinkOption[0])) {
                try {
                    Files.delete(t);
                }
                catch (IOException e) {
                    this.grabException(e);
                    return this;
                }
                return this;
            }
            final int[] deleted = new int[]{0, 0, 0};
            final NutsLogger LOG = this.getSession().getWorkspace().log().of(CoreIOUtils.class);
            try {
                Files.walkFileTree(t, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        try {
                            Files.delete(file);
                            if (LOG != null) {
                                LOG.with().session(DefaultNutsIODeleteAction.this.getSession()).level(Level.FINEST).verb(NutsLogVerb.WARNING).log("delete file " + file, new Object[0]);
                            }
                            deleted[0] = deleted[0] + 1;
                        }
                        catch (IOException e) {
                            if (LOG != null) {
                                LOG.with().session(DefaultNutsIODeleteAction.this.getSession()).level(Level.FINEST).verb(NutsLogVerb.WARNING).log("failed deleting file : " + file, new Object[0]);
                            }
                            deleted[2] = deleted[2] + 1;
                            DefaultNutsIODeleteAction.this.grabException(e);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        try {
                            Files.delete(dir);
                            if (LOG != null) {
                                LOG.with().session(DefaultNutsIODeleteAction.this.getSession()).level(Level.FINEST).verb(NutsLogVerb.WARNING).log("delete folder " + dir, new Object[0]);
                            }
                            deleted[1] = deleted[1] + 1;
                        }
                        catch (IOException e) {
                            if (LOG != null) {
                                LOG.with().session(DefaultNutsIODeleteAction.this.getSession()).level(Level.FINEST).verb(NutsLogVerb.WARNING).log("failed deleting folder : " + dir, new Object[0]);
                            }
                            deleted[2] = deleted[2] + 1;
                            DefaultNutsIODeleteAction.this.grabException(e);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                if (this.error == null) break block8;
                this.grabException(e);
            }
        }
        return this;
    }
}

