/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsExecutionContext;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsExecutorComponent;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSingleton;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.io.IProcessExecHelper;
import net.thevpc.nuts.runtime.core.util.CoreBooleanUtils;
import net.thevpc.nuts.runtime.core.util.ProcessExecHelper;

@NutsSingleton
public class ProcessExecutorComponent
implements NutsExecutorComponent {
    public static NutsId ID;
    NutsWorkspace ws;

    public NutsId getId() {
        return ID;
    }

    public int getSupportLevel(NutsSupportLevelContext<NutsDefinition> nutsDefinition) {
        this.ws = nutsDefinition.getWorkspace();
        if (ID == null) {
            ID = this.ws.id().parser().parse("net.thevpc.nuts.exec:exec-native");
        }
        return 10;
    }

    public void exec(NutsExecutionContext executionContext) {
        this.execHelper(executionContext).exec();
    }

    public void dryExec(NutsExecutionContext executionContext) throws NutsExecutionException {
        this.execHelper(executionContext).dryExec();
    }

    public IProcessExecHelper execHelper(NutsExecutionContext executionContext) {
        NutsDefinition nutMainFile = executionContext.getDefinition();
        String storeFolder = nutMainFile.getInstallInformation().getInstallFolder();
        String[] execArgs = executionContext.getExecutorArguments();
        String[] appArgs = executionContext.getArguments();
        ArrayList<String> app = new ArrayList<String>(Arrays.asList(appArgs));
        if (app.isEmpty()) {
            if (storeFolder == null) {
                app.add("${nuts.file}");
            } else {
                app.add("${nuts.store}/run");
            }
        }
        HashMap<String, String> osEnv = new HashMap<String, String>();
        String bootArgumentsString = executionContext.getWorkspace().env().getBootOptions().formatter().setExported(true).setCompact(true).getBootCommandLine().toString();
        osEnv.put("nuts_boot_args", bootArgumentsString);
        String dir = null;
        boolean showCommand = CoreBooleanUtils.getSysBoolNutsProperty("show-command", false);
        for (int i = 0; i < execArgs.length; ++i) {
            String arg = execArgs[i];
            if (arg.equals("--show-command") || arg.equals("-show-command")) {
                showCommand = true;
                continue;
            }
            if (arg.equals("--dir") || arg.equals("-dir")) {
                dir = execArgs[++i];
                continue;
            }
            if (!arg.startsWith("--dir=") && !arg.startsWith("-dir=")) continue;
            dir = execArgs[i].substring(arg.indexOf(61) + 1);
        }
        String directory = NutsUtilStrings.isBlank(dir) ? null : executionContext.getWorkspace().io().expandPath(dir);
        return ProcessExecHelper.ofDefinition(nutMainFile, app.toArray(new String[0]), osEnv, directory, executionContext.getExecutorProperties(), showCommand, true, executionContext.getSleepMillis(), false, false, null, null, executionContext.getRunAs(), executionContext.getTraceSession(), executionContext.getExecSession());
    }
}

