/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.config.compat.v507;

import java.nio.file.Path;
import java.nio.file.Paths;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigApi;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigBoot;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigMain;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigRuntime;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigSecurity;
import net.thevpc.nuts.runtime.standalone.config.compat.AbstractNutsVersionCompat;
import net.thevpc.nuts.runtime.standalone.config.compat.CompatUtils;

public class NutsVersionCompat507
extends AbstractNutsVersionCompat {
    public NutsVersionCompat507(NutsWorkspace ws, String apiVersion) {
        super(ws, apiVersion, 507);
    }

    @Override
    public NutsWorkspaceConfigBoot parseConfig(byte[] bytes, NutsSession session) {
        return this.parseConfig507(bytes, session);
    }

    public NutsWorkspaceConfigBoot parseConfig507(byte[] bytes, NutsSession session) {
        NutsWorkspace ws = session.getWorkspace();
        return bytes == null ? null : (NutsWorkspaceConfigBoot)((Object)ws.elem().setSession(session).setContentType(NutsContentType.JSON).parse(bytes, NutsWorkspaceConfigBoot.class));
    }

    @Override
    public NutsWorkspaceConfigApi parseApiConfig(NutsSession session) {
        NutsWorkspaceConfigApi c;
        NutsWorkspace ws = session.getWorkspace();
        Path path = Paths.get(ws.locations().getStoreLocation(ws.getApiId(), NutsStoreLocation.CONFIG), new String[0]).resolve("nuts-api-config.json");
        byte[] bytes = CompatUtils.readAllBytes(path);
        NutsWorkspaceConfigApi nutsWorkspaceConfigApi = c = bytes == null ? null : (NutsWorkspaceConfigApi)((Object)ws.elem().setSession(session).setContentType(NutsContentType.JSON).parse(bytes, NutsWorkspaceConfigApi.class));
        if (c != null) {
            c.setApiVersion(this.getApiVersion());
        }
        return c;
    }

    @Override
    public NutsWorkspaceConfigRuntime parseRuntimeConfig(NutsSession session) {
        NutsWorkspace ws = session.getWorkspace();
        Path path = Paths.get(ws.locations().getStoreLocation(ws.getRuntimeId(), NutsStoreLocation.CONFIG), new String[0]).resolve("nuts-runtime-config.json");
        byte[] bytes = CompatUtils.readAllBytes(path);
        NutsWorkspaceConfigRuntime c = bytes == null ? null : (NutsWorkspaceConfigRuntime)((Object)ws.elem().setSession(session).setContentType(NutsContentType.JSON).parse(bytes, NutsWorkspaceConfigRuntime.class));
        return c;
    }

    @Override
    public NutsWorkspaceConfigSecurity parseSecurityConfig(NutsSession session) {
        NutsWorkspace ws = session.getWorkspace();
        Path path = Paths.get(ws.locations().getStoreLocation(ws.getApiId().builder().setVersion("RELEASE").build(), NutsStoreLocation.CONFIG), new String[0]).resolve("nuts-security-config.json");
        byte[] bytes = CompatUtils.readAllBytes(path);
        NutsWorkspaceConfigSecurity c = bytes == null ? null : (NutsWorkspaceConfigSecurity)((Object)ws.elem().setSession(session).setContentType(NutsContentType.JSON).parse(bytes, NutsWorkspaceConfigSecurity.class));
        return c;
    }

    @Override
    public NutsWorkspaceConfigMain parseMainConfig(NutsSession session) {
        NutsWorkspace ws = session.getWorkspace();
        Path path = Paths.get(ws.locations().getStoreLocation(ws.getApiId().builder().setVersion("RELEASE").build(), NutsStoreLocation.CONFIG), new String[0]).resolve("nuts-main-config.json");
        byte[] bytes = CompatUtils.readAllBytes(path);
        NutsWorkspaceConfigMain c = bytes == null ? null : (NutsWorkspaceConfigMain)((Object)ws.elem().setSession(session).setContentType(NutsContentType.JSON).parse(bytes, NutsWorkspaceConfigMain.class));
        return c;
    }
}

