/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.config;

import java.io.File;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspaceBootConfig;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.NutsHomeLocationsMap;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceBootConfigExtensionImpl;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigBoot;

class DefaultNutsWorkspaceBootConfig
implements NutsWorkspaceBootConfig {
    private String bootPath;
    private String effectiveWorkspace;
    private String effectiveWorkspaceName;
    private boolean immediateLocation;
    private String uuid = null;
    private boolean global;
    private String name = null;
    private String workspace = null;
    private String bootRepositories = null;
    private Map<String, String> storeLocations = null;
    private Map<String, String> homeLocations = null;
    private NutsStoreLocationStrategy repositoryStoreLocationStrategy = null;
    private NutsStoreLocationStrategy storeLocationStrategy = null;
    private NutsOsFamily storeLocationLayout = null;
    private List<NutsWorkspaceBootConfig.Extension> extensions;

    public DefaultNutsWorkspaceBootConfig(NutsSession session, String bootPath, String effectiveWorkspace, String effectiveWorkspaceName, boolean immediateLocation, NutsWorkspaceConfigBoot bootModel) {
        this.bootPath = bootPath;
        this.effectiveWorkspace = effectiveWorkspace;
        this.immediateLocation = immediateLocation;
        this.effectiveWorkspaceName = effectiveWorkspaceName;
        this.uuid = bootModel.getUuid();
        this.global = bootModel.isGlobal();
        this.name = bootModel.getName();
        this.workspace = bootModel.getWorkspace();
        this.bootRepositories = bootModel.getBootRepositories();
        this.storeLocations = bootModel.getStoreLocations() == null ? new HashMap<String, String>() : new HashMap<String, String>(bootModel.getStoreLocations());
        this.homeLocations = bootModel.getHomeLocations() == null ? new HashMap<String, String>() : new HashMap<String, String>(bootModel.getHomeLocations());
        this.repositoryStoreLocationStrategy = bootModel.getRepositoryStoreLocationStrategy();
        this.storeLocationStrategy = bootModel.getStoreLocationStrategy();
        this.storeLocationLayout = bootModel.getStoreLocationLayout();
        String[] homes = new String[NutsStoreLocation.values().length];
        for (NutsStoreLocation type : NutsStoreLocation.values()) {
            homes[type.ordinal()] = Nuts.getPlatformHomeFolder((NutsOsFamily)this.storeLocationLayout, (NutsStoreLocation)type, this.homeLocations, (boolean)this.global, (String)this.name);
            if (!NutsUtilStrings.isBlank((CharSequence)homes[type.ordinal()])) continue;
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing Home for %s", (Object[])new Object[]{type.id()}));
        }
        if (this.storeLocationStrategy == null) {
            this.storeLocationStrategy = NutsStoreLocationStrategy.EXPLODED;
        }
        block9: for (NutsStoreLocation location : NutsStoreLocation.values()) {
            String typeId = location.id();
            String _storeLocation = this.storeLocations.get(typeId);
            if (NutsUtilStrings.isBlank((CharSequence)_storeLocation)) {
                switch (this.storeLocationStrategy) {
                    case STANDALONE: {
                        this.storeLocations.put(typeId, effectiveWorkspace + File.separator + typeId);
                        break;
                    }
                    case EXPLODED: {
                        this.storeLocations.put(typeId, homes[location.ordinal()]);
                    }
                }
                continue;
            }
            if (CoreIOUtils.isAbsolutePath(_storeLocation)) continue;
            switch (this.storeLocationStrategy) {
                case STANDALONE: {
                    this.storeLocations.put(typeId, effectiveWorkspace + File.separator + location.id());
                    continue block9;
                }
                case EXPLODED: {
                    this.storeLocations.put(typeId, homes[location.ordinal()] + CoreIOUtils.syspath("/" + _storeLocation));
                }
            }
        }
        List<NutsWorkspaceConfigBoot.ExtensionConfig> extensions = bootModel.getExtensions();
        this.extensions = extensions == null ? Collections.emptyList() : Collections.unmodifiableList(extensions.stream().map(x -> new NutsWorkspaceBootConfigExtensionImpl((NutsWorkspaceConfigBoot.ExtensionConfig)((Object)x))).collect(Collectors.toList()));
    }

    public boolean isImmediateLocation() {
        return this.immediateLocation;
    }

    public String getEffectiveWorkspaceName() {
        return this.effectiveWorkspaceName;
    }

    public String getBootPath() {
        return this.bootPath;
    }

    public String getName() {
        return this.name;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String getEffectiveWorkspace() {
        return this.effectiveWorkspace;
    }

    public List<NutsWorkspaceBootConfig.Extension> getExtensions() {
        return this.extensions;
    }

    public String getBootRepositories() {
        return this.bootRepositories;
    }

    public Map<String, String> getStoreLocations() {
        return Collections.unmodifiableMap(this.storeLocations);
    }

    public Map<String, String> getHomeLocations() {
        return Collections.unmodifiableMap(this.homeLocations);
    }

    public NutsStoreLocationStrategy getStoreLocationStrategy() {
        return this.storeLocationStrategy;
    }

    public NutsOsFamily getStoreLocationLayout() {
        return this.storeLocationLayout;
    }

    public NutsStoreLocationStrategy getRepositoryStoreLocationStrategy() {
        return this.repositoryStoreLocationStrategy;
    }

    public String getUuid() {
        return this.uuid;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public String getDefaultIdBasedir(NutsId id) {
        String groupId = id.getGroupId();
        String artifactId = id.getArtifactId();
        String plainIdPath = groupId.replace('.', '/') + "/" + artifactId;
        if (id.getVersion().isBlank()) {
            return plainIdPath;
        }
        String version = id.getVersion().getValue();
        String x = plainIdPath + "/" + version;
        return x;
    }

    public String getStoreLocation(NutsId id, NutsStoreLocation folderType) {
        String storeLocation = this.getStoreLocation(folderType);
        if (storeLocation == null) {
            return null;
        }
        return Paths.get(storeLocation, new String[0]).resolve("id").resolve(this.getDefaultIdBasedir(id)).toString();
    }

    public String getStoreLocation(NutsStoreLocation storeLocation) {
        return this.storeLocations.get(storeLocation.id());
    }

    public String getHomeLocation(NutsOsFamily osFamily, NutsStoreLocation storeLocation) {
        return new NutsHomeLocationsMap(this.homeLocations).get(osFamily, storeLocation);
    }

    public String getHomeLocation(NutsStoreLocation storeLocation) {
        return Nuts.getPlatformHomeFolder((NutsOsFamily)this.getStoreLocationLayout(), (NutsStoreLocation)storeLocation, this.getHomeLocations(), (boolean)this.isGlobal(), (String)this.getName());
    }
}

