/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.config;

import java.util.function.Predicate;
import net.thevpc.nuts.NutsSdkLocation;
import net.thevpc.nuts.NutsSdkManager;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsSdkModel;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsSdkManager
implements NutsSdkManager {
    private DefaultNutsSdkModel model;
    private NutsSession session;

    public DefaultNutsSdkManager(DefaultNutsSdkModel model) {
        this.model = model;
    }

    public DefaultNutsSdkModel getModel() {
        return this.model;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsSdkManager setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public String[] findSdkTypes() {
        return this.model.findSdkTypes();
    }

    public boolean add(NutsSdkLocation location) {
        this.checkSession();
        return this.model.add(location, this.session);
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
    }

    public boolean update(NutsSdkLocation oldLocation, NutsSdkLocation newLocation) {
        this.checkSession();
        return this.model.update(oldLocation, newLocation, this.session);
    }

    public boolean remove(NutsSdkLocation location) {
        this.checkSession();
        return this.model.remove(location, this.session);
    }

    public NutsSdkLocation findByName(String sdkType, String locationName) {
        this.checkSession();
        return this.model.findByName(sdkType, locationName, this.session);
    }

    public NutsSdkLocation findByPath(String sdkType, String path) {
        this.checkSession();
        return this.model.findByPath(sdkType, path, this.session);
    }

    public NutsSdkLocation findByVersion(String sdkType, String version) {
        this.checkSession();
        return this.model.findByVersion(sdkType, version, this.session);
    }

    public NutsSdkLocation find(NutsSdkLocation location) {
        this.checkSession();
        return this.model.find(location, this.session);
    }

    public NutsSdkLocation findByVersion(String sdkType, NutsVersionFilter requestedVersion) {
        this.checkSession();
        return this.model.findByVersion(sdkType, requestedVersion, this.session);
    }

    public NutsSdkLocation[] searchSystem(String sdkType) {
        this.checkSession();
        return this.model.searchSystem(sdkType, this.session);
    }

    public NutsSdkLocation[] searchSystem(String sdkType, String path) {
        this.checkSession();
        return this.model.searchSystem(sdkType, path, this.session);
    }

    public NutsSdkLocation resolve(String sdkType, String path, String preferredName) {
        this.checkSession();
        return this.model.resolve(sdkType, path, preferredName, this.session);
    }

    public NutsSdkLocation findOne(String type, Predicate<NutsSdkLocation> filter) {
        this.checkSession();
        return this.model.findOne(type, filter, this.session);
    }

    public NutsSdkLocation[] find(String type, Predicate<NutsSdkLocation> filter) {
        this.checkSession();
        return this.model.find(type, filter, this.session);
    }
}

