/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.thevpc.nuts.NutsCommandConfig;
import net.thevpc.nuts.NutsCommandFactoryConfig;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceCommandFactory;
import net.thevpc.nuts.NutsWorkspaceCustomCommand;
import net.thevpc.nuts.runtime.core.config.NutsWorkspaceConfigManagerExt;
import net.thevpc.nuts.runtime.standalone.DefaultNutsWorkspace;
import net.thevpc.nuts.runtime.standalone.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigMain;
import net.thevpc.nuts.runtime.standalone.wscommands.CommandNutsWorkspaceCommandFactory;
import net.thevpc.nuts.runtime.standalone.wscommands.ConfigNutsWorkspaceCommandFactory;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsWorkspaceCustomCommand;

public class DefaultCustomCommandsModel {
    private final ConfigNutsWorkspaceCommandFactory defaultCommandFactory;
    private final List<NutsWorkspaceCommandFactory> commandFactories = new ArrayList<NutsWorkspaceCommandFactory>();
    public NutsLogger LOG;
    private NutsWorkspace workspace;

    public DefaultCustomCommandsModel(NutsWorkspace ws) {
        this.workspace = ws;
        this.defaultCommandFactory = new ConfigNutsWorkspaceCommandFactory(ws);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = this.workspace.log().setSession(session).of(DefaultCustomCommandsModel.class);
        }
        return this.LOG;
    }

    public void addFactory(NutsCommandFactoryConfig commandFactoryConfig, NutsSession session) {
        if (commandFactoryConfig == null || commandFactoryConfig.getFactoryId() == null || commandFactoryConfig.getFactoryId().isEmpty() || !commandFactoryConfig.getFactoryId().trim().equals(commandFactoryConfig.getFactoryId())) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid WorkspaceCommandFactory %s", (Object[])new Object[]{commandFactoryConfig}));
        }
        for (NutsWorkspaceCommandFactory factory : this.commandFactories) {
            if (!commandFactoryConfig.getFactoryId().equals(factory.getFactoryId())) continue;
            throw new IllegalArgumentException();
        }
        CommandNutsWorkspaceCommandFactory f = null;
        if (NutsUtilStrings.isBlank((CharSequence)commandFactoryConfig.getFactoryType()) || "command".equals(commandFactoryConfig.getFactoryType().trim())) {
            f = new CommandNutsWorkspaceCommandFactory(this.workspace);
        }
        if (f != null) {
            f.configure(commandFactoryConfig);
            this.commandFactories.add(f);
        }
        Collections.sort(this.commandFactories, new Comparator<NutsWorkspaceCommandFactory>(){

            @Override
            public int compare(NutsWorkspaceCommandFactory o1, NutsWorkspaceCommandFactory o2) {
                return Integer.compare(o2.getPriority(), o1.getPriority());
            }
        });
        List<NutsCommandFactoryConfig> commandFactories = this.getStoreModelMain().getCommandFactories();
        if (commandFactories == null) {
            commandFactories = new ArrayList<NutsCommandFactoryConfig>();
            this.getStoreModelMain().setCommandFactories(commandFactories);
        }
        NutsCommandFactoryConfig oldCommandFactory = null;
        for (NutsCommandFactoryConfig commandFactory : commandFactories) {
            if (f != null && !commandFactory.getFactoryId().equals(f.getFactoryId())) continue;
            oldCommandFactory = commandFactory;
        }
        if (oldCommandFactory == null) {
            commandFactories.add(commandFactoryConfig);
        } else if (oldCommandFactory != commandFactoryConfig) {
            oldCommandFactory.setFactoryId(commandFactoryConfig.getFactoryId());
            oldCommandFactory.setFactoryType(commandFactoryConfig.getFactoryType());
            oldCommandFactory.setParameters((Map)(commandFactoryConfig.getParameters() == null ? null : new LinkedHashMap(commandFactoryConfig.getParameters())));
            oldCommandFactory.setPriority(commandFactoryConfig.getPriority());
        }
        NutsWorkspaceConfigManagerExt.of(session.getWorkspace().config()).getModel().fireConfigurationChanged("command", session, ConfigEventType.MAIN);
    }

    public boolean removeFactoryIfExists(String factoryId, NutsSession session) {
        return this.removeFactory(factoryId, session, false);
    }

    public void removeFactory(String factoryId, NutsSession session) {
        this.removeFactory(factoryId, session, true);
    }

    public boolean commandFactoryExists(String factoryId, NutsSession session) {
        if (factoryId == null || factoryId.isEmpty()) {
            return false;
        }
        Object removeMe = null;
        Object removeMeConfig = null;
        for (NutsWorkspaceCommandFactory factory : this.commandFactories) {
            if (!factoryId.equals(factory.getFactoryId())) continue;
            return true;
        }
        List<NutsCommandFactoryConfig> _commandFactories = this.getStoreModelMain().getCommandFactories();
        if (_commandFactories != null) {
            for (NutsCommandFactoryConfig commandFactory : _commandFactories) {
                if (!factoryId.equals(commandFactory.getFactoryId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean removeFactory(String factoryId, NutsSession session, boolean error) {
        List<NutsCommandFactoryConfig> _commandFactories;
        if (factoryId == null || factoryId.isEmpty()) {
            if (!error) {
                return false;
            }
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid WorkspaceCommandFactory %s", (Object[])new Object[]{factoryId}));
        }
        NutsWorkspaceCommandFactory removeMe = null;
        NutsCommandFactoryConfig removeMeConfig = null;
        Iterator<NutsWorkspaceCommandFactory> iterator = this.commandFactories.iterator();
        while (iterator.hasNext()) {
            NutsWorkspaceCommandFactory factory = iterator.next();
            if (!factoryId.equals(factory.getFactoryId())) continue;
            removeMe = factory;
            iterator.remove();
            NutsWorkspaceConfigManagerExt.of(session.getWorkspace().config()).getModel().fireConfigurationChanged("command", session, ConfigEventType.MAIN);
            break;
        }
        if ((_commandFactories = this.getStoreModelMain().getCommandFactories()) != null) {
            Iterator<NutsCommandFactoryConfig> iterator2 = _commandFactories.iterator();
            while (iterator2.hasNext()) {
                NutsCommandFactoryConfig commandFactory = iterator2.next();
                if (!factoryId.equals(commandFactory.getFactoryId())) continue;
                removeMeConfig = commandFactory;
                iterator2.remove();
                NutsWorkspaceConfigManagerExt.of(session.getWorkspace().config()).getModel().fireConfigurationChanged("command", session, ConfigEventType.MAIN);
                break;
            }
        }
        if (removeMe == null && removeMeConfig == null) {
            if (!error) {
                return false;
            }
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"command factory does not exists %s", (Object[])new Object[]{factoryId}));
        }
        return true;
    }

    public boolean add(NutsCommandConfig command, NutsSession session) {
        if (command == null || NutsUtilStrings.isBlank((CharSequence)command.getName()) || command.getName().contains(" ") || command.getName().contains(".") || command.getName().contains("/") || command.getName().contains("\\") || command.getCommand() == null || command.getCommand().length == 0) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid command %s", (Object[])new Object[]{command == null ? "<NULL>" : command.getName()}));
        }
        NutsCommandConfig oldCommand = this.defaultCommandFactory.findCommand(command.getName(), session);
        this.find(command.getName(), session);
        if (oldCommand != null) {
            if (oldCommand.equals((Object)command)) {
                return false;
            }
            if (!session.getTerminal().ask().resetLine().setDefaultValue((Object)false).forBoolean("override existing command %s ?", new Object[]{session.getWorkspace().text().forStyled(command.getName(), NutsTextStyle.primary1())}).getBooleanValue().booleanValue()) {
                this.update(command, session);
                return true;
            }
            return false;
        }
        this.defaultCommandFactory.installCommand(command, session);
        if (session.isPlainTrace()) {
            NutsPrintStream out = session.getTerminal().out();
            NutsTextManager text = session.getWorkspace().text();
            out.printf("%s command %s%n", new Object[]{text.forStyled("install", NutsTextStyle.success()), text.forStyled(command.getName(), NutsTextStyle.primary3())});
        }
        return true;
    }

    public boolean update(NutsCommandConfig command, NutsSession session) {
        if (command == null || NutsUtilStrings.isBlank((CharSequence)command.getName()) || command.getName().contains(" ") || command.getName().contains(".") || command.getName().contains("/") || command.getName().contains("\\") || command.getCommand() == null || command.getCommand().length == 0) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid command %s", (Object[])new Object[]{command == null ? "<NULL>" : command.getName()}));
        }
        NutsCommandConfig oldCommand = this.defaultCommandFactory.findCommand(command.getName(), session);
        if (oldCommand != null) {
            if (oldCommand.equals((Object)command)) {
                return false;
            }
            this.defaultCommandFactory.uninstallCommand(command.getName(), session);
            this.defaultCommandFactory.installCommand(command, session);
            if (session.isPlainTrace()) {
                NutsPrintStream out = session.getTerminal().out();
                NutsTextManager text = session.getWorkspace().text();
                out.printf("%s command %s%n", new Object[]{text.forStyled("update ", NutsTextStyles.of((NutsTextStyle[])new NutsTextStyle[]{NutsTextStyle.success(), NutsTextStyle.underlined()})), text.forStyled(command.getName(), NutsTextStyle.primary3())});
            }
            return true;
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"command not found %s", (Object[])new Object[]{command.getName()}));
    }

    public void remove(String name, NutsSession session) {
        if (NutsUtilStrings.isBlank((CharSequence)name)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)("invalid command : %s" + (name == null ? "<NULL>" : name)), (Object[])new Object[0]));
        }
        NutsCommandConfig command = this.defaultCommandFactory.findCommand(name, session);
        if (command == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"command does not exists %s", (Object[])new Object[]{name}));
        }
        this.defaultCommandFactory.uninstallCommand(name, session);
        if (session.isPlainTrace()) {
            NutsPrintStream out = session.getTerminal().out();
            out.printf("%s command %s%n", new Object[]{"uninstall", session.getWorkspace().text().forStyled(name, NutsTextStyle.primary3())});
        }
    }

    NutsWorkspaceConfigMain getStoreModelMain() {
        return ((DefaultNutsWorkspace)this.workspace).getConfigModel().getStoreModelMain();
    }

    public NutsWorkspaceCustomCommand find(String name, NutsSession session) {
        NutsCommandConfig c = this.defaultCommandFactory.findCommand(name, session);
        if (c == null) {
            NutsWorkspaceCommandFactory commandFactory;
            Iterator<NutsWorkspaceCommandFactory> iterator = this.commandFactories.iterator();
            while (iterator.hasNext() && (c = (commandFactory = iterator.next()).findCommand(name, session)) == null) {
            }
        }
        if (c == null) {
            return null;
        }
        return this.toDefaultNutsWorkspaceCommand(c, session);
    }

    public List<NutsWorkspaceCustomCommand> findAll(NutsSession session) {
        HashMap<String, NutsWorkspaceCustomCommand> all = new HashMap<String, NutsWorkspaceCustomCommand>();
        for (NutsCommandConfig command : this.defaultCommandFactory.findCommands(session)) {
            all.put(command.getName(), this.toDefaultNutsWorkspaceCommand(command, session));
        }
        for (NutsWorkspaceCommandFactory commandFactory : this.commandFactories) {
            for (NutsCommandConfig command : commandFactory.findCommands(session)) {
                if (all.containsKey(command.getName())) continue;
                all.put(command.getName(), this.toDefaultNutsWorkspaceCommand(command, session));
            }
        }
        return new ArrayList<NutsWorkspaceCustomCommand>(all.values());
    }

    public List<NutsWorkspaceCustomCommand> findByOwner(NutsId id, NutsSession session) {
        HashMap<String, NutsWorkspaceCustomCommand> all = new HashMap<String, NutsWorkspaceCustomCommand>();
        for (NutsCommandConfig command : this.defaultCommandFactory.findCommands(id, session)) {
            all.put(command.getName(), this.toDefaultNutsWorkspaceCommand(command, session));
        }
        return new ArrayList<NutsWorkspaceCustomCommand>(all.values());
    }

    private NutsWorkspaceCustomCommand toDefaultNutsWorkspaceCommand(NutsCommandConfig c, NutsSession session) {
        if (c.getCommand() == null || c.getCommand().length == 0) {
            this._LOGOP(session).level(Level.WARNING).verb(NutsLogVerb.FAIL).log("invalid command definition ''{0}''. Missing command . Ignored", new Object[]{c.getName()});
            return null;
        }
        return new DefaultNutsWorkspaceCustomCommand(this.workspace).setCommand(c.getCommand()).setFactoryId(c.getFactoryId()).setOwner(c.getOwner()).setExecutorOptions(c.getExecutorOptions()).setName(c.getName()).setHelpCommand(c.getHelpCommand()).setHelpText(c.getHelpText());
    }

    public NutsCommandFactoryConfig[] getFactories(NutsSession session) {
        if (this.getStoreModelMain().getCommandFactories() != null) {
            return this.getStoreModelMain().getCommandFactories().toArray(new NutsCommandFactoryConfig[0]);
        }
        return new NutsCommandFactoryConfig[0];
    }

    public NutsWorkspaceCustomCommand find(String name, NutsId forId, NutsId forOwner, NutsSession session) {
        NutsId i;
        NutsWorkspaceCustomCommand a = this.find(name, session);
        if (a != null && a.getCommand() != null && a.getCommand().length > 0 && (i = session.getWorkspace().id().parser().parse(a.getCommand()[0])) != null && (forId == null || i.getShortName().equals(forId.getArtifactId()) || i.getShortName().equals(forId.getShortName())) && (forOwner == null || a.getOwner() != null && a.getOwner().getShortName().equals(forOwner.getShortName()))) {
            return a;
        }
        return null;
    }

    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }
}

