/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.bridges.maven;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorBuilder;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsParseException;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.common.MapToFunction;
import net.thevpc.nuts.runtime.bundles.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.bundles.mvn.ArchetypeCatalogParser;
import net.thevpc.nuts.runtime.bundles.mvn.MavenMetadata;
import net.thevpc.nuts.runtime.bundles.mvn.MavenMetadataParser;
import net.thevpc.nuts.runtime.bundles.mvn.Pom;
import net.thevpc.nuts.runtime.bundles.mvn.PomDependency;
import net.thevpc.nuts.runtime.bundles.mvn.PomId;
import net.thevpc.nuts.runtime.bundles.mvn.PomIdFilter;
import net.thevpc.nuts.runtime.bundles.mvn.PomIdResolver;
import net.thevpc.nuts.runtime.bundles.mvn.PomLogger;
import net.thevpc.nuts.runtime.bundles.mvn.PomUrlReader;
import net.thevpc.nuts.runtime.bundles.mvn.PomXmlParser;
import net.thevpc.nuts.runtime.bundles.parsers.StringTokenizerUtils;
import net.thevpc.nuts.runtime.core.model.DefaultNutsVersion;
import net.thevpc.nuts.runtime.core.repos.NutsRepositorySelector;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.io.NamedByteArrayInputStream;
import net.thevpc.nuts.runtime.standalone.util.NutsDependencyScopes;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MavenUtils {
    private final NutsLogger LOG;
    private NutsWorkspace ws;
    private NutsSession session;

    private MavenUtils(NutsWorkspace ws, NutsSession session) {
        this.ws = ws;
        this.session = session;
        this.LOG = session.getWorkspace().log().of(MavenUtils.class);
    }

    public static MavenUtils of(NutsSession session) {
        NutsWorkspace ws = session.getWorkspace();
        MavenUtils wp = (MavenUtils)ws.env().getProperty(MavenUtils.class.getName());
        if (wp == null) {
            wp = new MavenUtils(ws, session);
            ws.env().setProperty(MavenUtils.class.getName(), (Object)wp);
        }
        return wp;
    }

    public static PomIdResolver createPomIdResolver(NutsSession session) {
        PomIdResolver wp = (PomIdResolver)session.getWorkspace().env().getProperty(PomIdResolver.class.getName());
        if (wp == null) {
            wp = new PomIdResolver(new NutsPomUrlReader(session), new NutsPomLogger(session));
            session.getWorkspace().env().setProperty(PomIdResolver.class.getName(), (Object)wp);
        }
        return wp;
    }

    public NutsId[] toNutsId(PomId[] ids) {
        NutsId[] a = new NutsId[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            a[i] = this.toNutsId(ids[i]);
        }
        return a;
    }

    public NutsDependency[] toNutsDependencies(PomDependency[] deps, NutsSession session) {
        NutsDependency[] a = new NutsDependency[deps.length];
        for (int i = 0; i < deps.length; ++i) {
            a[i] = this.toNutsDependency(deps[i], session);
        }
        return a;
    }

    public NutsId toNutsId(PomId d) {
        return this.ws.id().builder().setGroupId(d.getGroupId()).setArtifactId(d.getArtifactId()).setVersion(this.toNutsVersion(d.getVersion())).build();
    }

    public NutsDependency toNutsDependency(PomDependency d, NutsSession session) {
        String s = d.getScope();
        if (s == null) {
            s = "";
        }
        s = s.trim();
        NutsDependencyScope nds = NutsDependencyScope.API;
        switch (s) {
            case "": 
            case "compile": {
                nds = NutsDependencyScope.API;
                break;
            }
            case "test": {
                nds = NutsDependencyScope.TEST_API;
                break;
            }
            case "system": {
                nds = NutsDependencyScope.SYSTEM;
                break;
            }
            case "runtime": {
                nds = NutsDependencyScope.RUNTIME;
                break;
            }
            case "provided": {
                nds = NutsDependencyScope.PROVIDED;
                break;
            }
            case "import": {
                nds = NutsDependencyScope.IMPORT;
                break;
            }
            default: {
                nds = NutsDependencyScopes.parseScope(s, true);
                if (nds != null) break;
                this.LOG.with().session(session).level(Level.FINER).verb(NutsLogVerb.FAIL).log("unable to parse maven scope {0} for {1}", new Object[]{s, d});
                nds = NutsDependencyScope.API;
            }
        }
        return session.getWorkspace().dependency().builder().setGroupId(d.getGroupId()).setArtifactId(d.getArtifactId()).setClassifier(d.getClassifier()).setVersion(this.toNutsVersion(d.getVersion())).setOptional(d.getOptional()).setScope(nds.id()).setOs(d.getOs()).setArch(d.getArch()).setType(d.getType()).setExclusions(this.toNutsId(d.getExclusions())).build();
    }

    private boolean testNode(Node n, Predicate<Node> tst) {
        if (tst.test(n)) {
            return true;
        }
        if (n instanceof Element) {
            Element e = (Element)n;
            NodeList nl = e.getChildNodes();
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                if (!this.testNode(nl.item(i), tst)) continue;
                return true;
            }
        }
        return false;
    }

    public NutsDescriptor parsePomXml0(InputStream stream, NutsFetchMode fetchMode, String urlDesc, NutsRepository repository) {
        long startTime = System.currentTimeMillis();
        try {
            NutsId[] nutsIdArray;
            String categories;
            if (stream == null) {
                return null;
            }
            byte[] bytes = CoreIOUtils.loadByteArray(stream);
            Pom pom = new PomXmlParser(new NutsPomLogger(this.session)).parse(new NamedByteArrayInputStream(bytes, urlDesc), this.session);
            boolean executable = false;
            boolean application = false;
            if ("true".equals(pom.getProperties().get("nuts.executable"))) {
                executable = true;
            } else {
                Element ee = pom.getXml().getDocumentElement();
                if (this.testNode(ee, x -> {
                    if (x instanceof Element) {
                        Element e = (Element)x;
                        if (e.getNodeName().equals("mainClass")) {
                            return true;
                        }
                        if (e.getNodeName().equals("goal") && NutsUtilStrings.trim((String)e.getTextContent()).equals("exec-war-only")) {
                            return true;
                        }
                    }
                    return false;
                })) {
                    executable = true;
                }
            }
            if ("true".equals(pom.getProperties().get("nuts.application"))) {
                application = true;
            }
            if (application) {
                executable = true;
            }
            if (pom.getPackaging().isEmpty()) {
                pom.setPackaging("jar");
            }
            long time = System.currentTimeMillis() - startTime;
            String fetchString = "[" + CoreStringUtils.alignLeft(fetchMode.id(), 7) + "] ";
            this.LOG.with().session(this.session).level(Level.FINEST).verb(NutsLogVerb.SUCCESS).time(time).formatted().log("{0}{1} parse pom    {2}", new Object[]{fetchString, CoreStringUtils.alignLeft(repository == null ? "<no-repo>" : repository.getName(), 20), urlDesc});
            String icons = pom.getProperties().get("nuts.icons");
            if (icons == null) {
                icons = "";
            }
            if ((categories = pom.getProperties().get("nuts.categories")) == null) {
                categories = "";
            }
            NutsDescriptorBuilder nutsDescriptorBuilder = this.ws.descriptor().descriptorBuilder().setId(this.toNutsId(pom.getPomId()));
            if (pom.getParent() == null) {
                nutsIdArray = new NutsId[]{};
            } else {
                NutsId[] nutsIdArray2 = new NutsId[1];
                nutsIdArray = nutsIdArray2;
                nutsIdArray2[0] = this.toNutsId(pom.getParent());
            }
            return nutsDescriptorBuilder.setParents(nutsIdArray).setPackaging(pom.getPackaging()).setExecutable(executable).setApplication(application).setName(pom.getName()).setDescription(pom.getDescription()).setPlatform(new String[]{"java"}).setDependencies(this.toNutsDependencies(pom.getDependencies(), this.session)).setStandardDependencies(this.toNutsDependencies(pom.getDependenciesManagement(), this.session)).setCategories(Arrays.stream(categories.split("[\n\r;,]")).map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.toList())).setIcons(Arrays.stream(icons.split("[\n\r]")).map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.toList())).setGenericName(pom.getProperties().get("nuts.genericName")).setProperties(pom.getProperties()).build();
        }
        catch (Exception e) {
            long time = System.currentTimeMillis() - startTime;
            this.LOG.with().session(this.session).level(Level.FINEST).verb(NutsLogVerb.FAIL).time(time).formatted().log("caching pom file {0}", new Object[]{urlDesc});
            throw new NutsParseException(this.session, NutsMessage.cstyle((String)"error parsing %s", (Object[])new Object[]{urlDesc}), (Throwable)e);
        }
    }

    public String toNutsVersion(String version) {
        return version == null ? null : version.replace("(", "]").replace(")", "[");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NutsDescriptor parsePomXml(Path path, NutsFetchMode fetchMode, NutsRepository repository) throws IOException {
        try {
            this.session.getTerminal().printProgress("%-8s %s", new Object[]{"parse", this.session.getWorkspace().io().path(path.toString()).toCompressedForm()});
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                NutsDescriptor nutsDescriptor = this.parsePomXml(is, fetchMode, path.toString(), repository);
                if (nutsDescriptor.getId().getArtifactId() == null) {
                    if (this.LOG.isLoggable(Level.FINE)) {
                        this.LOG.with().session(this.session).level(Level.FINE).verb(NutsLogVerb.FAIL).log("Unable to fetch Valid Nuts from " + path + " : resolved id was " + nutsDescriptor.getId(), new Object[0]);
                    }
                    NutsDescriptor nutsDescriptor2 = null;
                    return nutsDescriptor2;
                }
                NutsDescriptor nutsDescriptor3 = nutsDescriptor;
                return nutsDescriptor3;
            }
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NutsDescriptor parsePomXml(InputStream stream, NutsFetchMode fetchMode, String urlDesc, NutsRepository repository) {
        NutsDescriptor nutsDescriptor = null;
        try {
            try {
                String nutsPackaging;
                NutsId thisId;
                nutsDescriptor = this.parsePomXml0(stream, fetchMode, urlDesc, repository);
                HashMap<String, String> properties = new HashMap<String, String>();
                NutsId parentId = null;
                NutsId[] nutsIdArray = nutsDescriptor.getParents();
                int n = nutsIdArray.length;
                for (int i = 0; i < n; ++i) {
                    NutsId nutsId;
                    parentId = nutsId = nutsIdArray[i];
                }
                NutsDescriptor parentDescriptor = null;
                if (parentId != null && !CoreNutsUtils.isEffectiveId(parentId)) {
                    try {
                        parentDescriptor = this.ws.fetch().setId(parentId).setEffective(true).setSession(this.session.copy().setTransitive(Boolean.valueOf(true)).setFetchStrategy(fetchMode == NutsFetchMode.REMOTE ? NutsFetchStrategy.ONLINE : NutsFetchStrategy.OFFLINE)).getResultDescriptor();
                    }
                    catch (NutsException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        throw new NutsNotFoundException(this.session, nutsDescriptor.getId(), NutsMessage.cstyle((String)"unable to resolve %s parent %s", (Object[])new Object[]{nutsDescriptor.getId(), parentId, ex}));
                    }
                    parentId = parentDescriptor.getId();
                }
                if (parentId != null) {
                    properties.put("parent.groupId", parentId.getGroupId());
                    properties.put("parent.artifactId", parentId.getArtifactId());
                    properties.put("parent.version", parentId.getVersion().getValue());
                    properties.put("project.parent.groupId", parentId.getGroupId());
                    properties.put("project.parent.artifactId", parentId.getArtifactId());
                    properties.put("project.parent.version", parentId.getVersion().getValue());
                    nutsDescriptor = nutsDescriptor.builder().applyProperties(properties).build();
                }
                if (!CoreNutsUtils.isEffectiveId(thisId = nutsDescriptor.getId())) {
                    if (parentId != null) {
                        if (NutsUtilStrings.isBlank((CharSequence)thisId.getGroupId())) {
                            thisId = thisId.builder().setGroupId(parentId.getGroupId()).build();
                        }
                        if (NutsUtilStrings.isBlank((CharSequence)thisId.getVersion().getValue())) {
                            thisId = thisId.builder().setVersion(parentId.getVersion().getValue()).build();
                        }
                    }
                    HashMap<NutsId, NutsDescriptor> cache = new HashMap<NutsId, NutsDescriptor>();
                    HashSet<String> done = new HashSet<String>();
                    Stack<NutsId> todo = new Stack<NutsId>();
                    todo.push(nutsDescriptor.getId());
                    cache.put(nutsDescriptor.getId(), nutsDescriptor);
                    while (todo.isEmpty()) {
                        NutsId pid = (NutsId)todo.pop();
                        NutsDescriptor d = (NutsDescriptor)cache.get(pid);
                        if (d == null) {
                            try {
                                d = this.ws.fetch().setId(pid).setEffective(true).setSession(this.session).getResultDescriptor();
                            }
                            catch (NutsException ex) {
                                throw ex;
                            }
                            catch (Exception ex) {
                                throw new NutsNotFoundException(this.session, nutsDescriptor.getId(), NutsMessage.cstyle((String)"unable to resolve %s parent %s", (Object[])new Object[]{nutsDescriptor.getId(), pid, ex}));
                            }
                        }
                        done.add(pid.getShortName());
                        if (!CoreNutsUtils.containsVars(thisId)) break;
                        thisId.builder().apply(new MapToFunction(d.getProperties())).build();
                        for (NutsId nutsId : d.getParents()) {
                            if (done.contains(nutsId.getShortName())) continue;
                            todo.push(nutsId);
                        }
                    }
                    if (CoreNutsUtils.containsVars(thisId)) {
                        throw new NutsNotFoundException(this.session, nutsDescriptor.getId(), NutsMessage.cstyle((String)"unable to resolve %s parent %s", (Object[])new Object[]{nutsDescriptor.getId(), parentId}));
                    }
                    nutsDescriptor = nutsDescriptor.builder().setId(thisId).build();
                }
                if (!NutsUtilStrings.isBlank((CharSequence)(nutsPackaging = (String)nutsDescriptor.getProperties().get("nuts-packaging")))) {
                    nutsDescriptor = nutsDescriptor.builder().setPackaging(nutsPackaging).build();
                }
                properties.put("pom.groupId", thisId.getGroupId());
                properties.put("pom.version", thisId.getVersion().getValue());
                properties.put("pom.artifactId", thisId.getArtifactId());
                properties.put("project.groupId", thisId.getGroupId());
                properties.put("project.artifactId", thisId.getArtifactId());
                properties.put("project.version", thisId.getVersion().getValue());
                properties.put("version", thisId.getVersion().getValue());
                nutsDescriptor = nutsDescriptor.builder().applyProperties(properties).build();
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
        catch (Exception ex) {
            throw new NutsParseException(this.session, NutsMessage.cstyle((String)"error Parsing %s", (Object[])new Object[]{urlDesc}), (Throwable)ex);
        }
        return nutsDescriptor;
    }

    public Iterator<NutsId> createArchetypeCatalogIterator(InputStream stream, final NutsIdFilter filter, boolean autoClose, final NutsSession session) {
        Iterator<PomId> it = ArchetypeCatalogParser.createArchetypeCatalogIterator(stream, filter == null ? null : new PomIdFilter(){

            @Override
            public boolean accept(PomId id) {
                return filter.acceptId(MavenUtils.this.toNutsId(id), session);
            }
        }, autoClose);
        return IteratorBuilder.of(it).convert(pomId -> this.toNutsId((PomId)pomId), "PomId->NutsId").build();
    }

    public MavenMetadata parseMavenMetaData(InputStream metadataStream, NutsSession session) {
        MavenMetadata s = new MavenMetadataParser(session).parseMavenMetaData(metadataStream);
        if (s == null) {
            return s;
        }
        Iterator<String> iterator = s.getVersions().iterator();
        while (iterator.hasNext()) {
            String version = iterator.next();
            if (s.getLatest().length() <= 0 || DefaultNutsVersion.compareVersions(version, s.getLatest()) <= 0) continue;
            iterator.remove();
        }
        return s;
    }

    public DepsAndRepos loadDependenciesAndRepositoriesFromPomPath(NutsId rid, NutsRepositorySelector.Selection[] bootRepositories, NutsSession session) {
        String urlPath = CoreNutsUtils.idToPath(rid) + "/" + rid.getArtifactId() + "-" + rid.getVersion() + ".pom";
        return this.loadDependenciesAndRepositoriesFromPomPath(urlPath, bootRepositories, session);
    }

    public DepsAndRepos loadDependenciesAndRepositoriesFromPomPath(String urlPath, NutsRepositorySelector.Selection[] bootRepositories, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
        DepsAndRepos depsAndRepos = null;
        File mavenNutsCorePom = new File(System.getProperty("user.home"), (".m2/repository/" + urlPath).replace("/", File.separator));
        if (mavenNutsCorePom.isFile()) {
            depsAndRepos = this.loadDependenciesAndRepositoriesFromPomUrl(mavenNutsCorePom.getPath(), session);
        }
        if (depsAndRepos == null || depsAndRepos.deps.isEmpty()) {
            for (NutsRepositorySelector.Selection baseUrl : bootRepositories) {
                NutsAddRepositoryOptions opt = NutsRepositorySelector.createRepositoryOptions(baseUrl, false, session);
                String location = opt.getConfig() == null ? opt.getLocation() : opt.getConfig().getLocation();
                depsAndRepos = this.loadDependenciesAndRepositoriesFromPomUrl(location + "/" + urlPath, session);
                if (!depsAndRepos.deps.isEmpty()) break;
            }
        }
        return depsAndRepos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DepsAndRepos loadDependenciesAndRepositoriesFromPomUrl(String url, NutsSession session) {
        session.getTerminal().printProgress("%-8s %s", new Object[]{"load", session.getWorkspace().io().path(url).toCompressedForm()});
        DepsAndRepos depsAndRepos = new DepsAndRepos();
        InputStream xml = null;
        try {
            if (CoreIOUtils.isPathHttp(url)) {
                xml = NutsWorkspaceUtils.of(session).openURL(url);
            } else {
                File file = new File(url);
                if (file.isFile()) {
                    xml = Files.newInputStream(file.toPath(), new OpenOption[0]);
                } else {
                    DepsAndRepos depsAndRepos2 = depsAndRepos;
                    return depsAndRepos2;
                }
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(xml);
            Element c = doc.getDocumentElement();
            for (int i = 0; i < c.getChildNodes().getLength(); ++i) {
                Element c3;
                int j;
                Element c2;
                if (c.getChildNodes().item(i) instanceof Element && c.getChildNodes().item(i).getNodeName().equals("dependencies")) {
                    c2 = (Element)c.getChildNodes().item(i);
                    for (j = 0; j < c2.getChildNodes().getLength(); ++j) {
                        if (!(c2.getChildNodes().item(j) instanceof Element) || !c2.getChildNodes().item(j).getNodeName().equals("dependency")) continue;
                        c3 = (Element)c2.getChildNodes().item(j);
                        String groupId = null;
                        String artifactId = null;
                        String version = null;
                        String scope = null;
                        block34: for (int k = 0; k < c3.getChildNodes().getLength(); ++k) {
                            if (!(c3.getChildNodes().item(k) instanceof Element)) continue;
                            Element c4 = (Element)c3.getChildNodes().item(k);
                            switch (c4.getNodeName()) {
                                case "groupId": {
                                    groupId = c4.getTextContent().trim();
                                    continue block34;
                                }
                                case "artifactId": {
                                    artifactId = c4.getTextContent().trim();
                                    continue block34;
                                }
                                case "version": {
                                    version = c4.getTextContent().trim();
                                    continue block34;
                                }
                                case "scope": {
                                    scope = c4.getTextContent().trim();
                                }
                            }
                        }
                        if (NutsUtilStrings.isBlank(groupId)) {
                            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unexpected empty groupId", (Object[])new Object[0]));
                        }
                        if (groupId.contains("$")) {
                            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unexpected maven variable in groupId=%s", (Object[])new Object[]{groupId}));
                        }
                        if (NutsUtilStrings.isBlank(artifactId)) {
                            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unexpected empty artifactId", (Object[])new Object[0]));
                        }
                        if (artifactId.contains("$")) {
                            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unexpected maven variable in artifactId=%s", (Object[])new Object[]{artifactId}));
                        }
                        if (NutsUtilStrings.isBlank(version)) {
                            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unexpected empty artifactId", (Object[])new Object[0]));
                        }
                        if (version.contains("$")) {
                            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unexpected maven variable in artifactId=%s", (Object[])new Object[]{version}));
                        }
                        if (NutsUtilStrings.isBlank(scope) || scope.equals("compile")) {
                            depsAndRepos.deps.add(groupId + ":" + artifactId + "#" + version);
                            continue;
                        }
                        if (!version.contains("$")) continue;
                        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unexpected maven variable in artifactId=%s", (Object[])new Object[]{version}));
                    }
                    continue;
                }
                if (!(c.getChildNodes().item(i) instanceof Element) || !c.getChildNodes().item(i).getNodeName().equals("properties")) continue;
                c2 = (Element)c.getChildNodes().item(i);
                block35: for (j = 0; j < c2.getChildNodes().getLength(); ++j) {
                    if (!(c2.getChildNodes().item(j) instanceof Element)) continue;
                    c3 = (Element)c2.getChildNodes().item(j);
                    switch (c3.getNodeName()) {
                        case "nuts-runtime-repositories": {
                            String t = c3.getTextContent().trim();
                            if (t.length() <= 0) continue block35;
                            depsAndRepos.deps.addAll(StringTokenizerUtils.split(t, ";", true));
                            continue block35;
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            this.LOG.with().session(session).level(Level.SEVERE).error((Throwable)ex).log("failed to loadDependenciesAndRepositoriesFromPomUrl {0} : {1}", new Object[]{url, ex});
        }
        finally {
            if (xml != null) {
                try {
                    xml.close();
                }
                catch (IOException iOException) {}
            }
        }
        return depsAndRepos;
    }

    public NutsId resolveLatestMavenId(NutsId zId, Predicate<String> filter, NutsSession session) {
        File[] children;
        String path = zId.getGroupId().replace('.', '/') + '/' + zId.getArtifactId();
        String bestVersion = null;
        File mavenNutsCoreFolder = new File(System.getProperty("user.home"), ".m2/repository/" + path + "/".replace("/", File.separator));
        if (mavenNutsCoreFolder.isDirectory() && (children = mavenNutsCoreFolder.listFiles()) != null) {
            File[] fileArray = children;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                String[] goodChildren;
                File file = fileArray[i];
                if (!file.isDirectory() || (goodChildren = file.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".pom");
                    }
                })) == null || goodChildren.length <= 0) continue;
                String p = file.getName();
                if (filter != null && !filter.test(p) || bestVersion != null && DefaultNutsVersion.compareVersions(bestVersion, p) >= 0) continue;
                bestVersion = p;
            }
        }
        for (String repoUrl : new String[]{"https://repo.maven.apache.org/maven2"}) {
            if (!repoUrl.endsWith("/")) {
                repoUrl = repoUrl + "/";
            }
            boolean found = false;
            String mavenMetadataXml = repoUrl + path + "/maven-metadata.xml";
            try {
                URL runtimeMetadata = new URL(mavenMetadataXml);
                found = true;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(NutsWorkspaceUtils.of(session).openURL(runtimeMetadata));
                Element c = doc.getDocumentElement();
                for (int i = 0; i < c.getChildNodes().getLength(); ++i) {
                    if (!(c.getChildNodes().item(i) instanceof Element) || !c.getChildNodes().item(i).getNodeName().equals("versioning")) continue;
                    Element c2 = (Element)c.getChildNodes().item(i);
                    for (int j = 0; j < c2.getChildNodes().getLength(); ++j) {
                        if (!(c2.getChildNodes().item(j) instanceof Element) || !c2.getChildNodes().item(j).getNodeName().equals("versions")) continue;
                        Element c3 = (Element)c2.getChildNodes().item(j);
                        for (int k = 0; k < c3.getChildNodes().getLength(); ++k) {
                            if (!(c3.getChildNodes().item(k) instanceof Element) || !c3.getChildNodes().item(k).getNodeName().equals("version")) continue;
                            Element c4 = (Element)c3.getChildNodes().item(k);
                            String p = c4.getTextContent();
                            if (filter != null && !filter.test(p) || bestVersion != null && DefaultNutsVersion.compareVersions(bestVersion, p) >= 0) continue;
                            bestVersion = p;
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.LOG.with().session(session).level(Level.SEVERE).error((Throwable)ex).log("failed to load and parse {0} : {1}", new Object[]{mavenMetadataXml, ex});
            }
            if (found) break;
        }
        if (bestVersion == null) {
            return null;
        }
        return zId.builder().setVersion(bestVersion).build();
    }

    private static class NutsPomUrlReader
    implements PomUrlReader {
        private final NutsSession session;

        public NutsPomUrlReader(NutsSession session) {
            this.session = session;
        }

        @Override
        public InputStream openStream(URL url) {
            return NutsWorkspaceUtils.of(this.session).openURL(url);
        }
    }

    private static class NutsPomLogger
    implements PomLogger {
        private final NutsSession session;
        NutsLogger LOG;

        public NutsPomLogger(NutsSession session) {
            this.session = session;
            this.LOG = session.getWorkspace().log().of(PomIdResolver.class);
        }

        @Override
        public void log(Level level, String msg, Object ... params) {
            this.LOG.with().session(this.session).level(Level.FINE).verb(NutsLogVerb.FAIL).log(msg, params);
        }

        @Override
        public void log(Level level, String msg, Throwable throwable) {
            this.LOG.with().session(this.session).level(Level.FINE).verb(NutsLogVerb.FAIL).log("%s", new Object[]{msg});
        }
    }

    public static class DepsAndRepos {
        public LinkedHashSet<String> deps = new LinkedHashSet();
        public LinkedHashSet<String> repos = new LinkedHashSet();
    }
}

