/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.bridges.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchModeNotSupportedException;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsIOCopyValidator;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIdManager;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfigManager;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.iter.IteratorUtils;
import net.thevpc.nuts.runtime.bundles.mvn.MavenMetadata;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.bridges.maven.AbstractMavenRepositoryHelper;
import net.thevpc.nuts.runtime.standalone.bridges.maven.MavenUtils;
import net.thevpc.nuts.runtime.standalone.bridges.maven.MvnClient;
import net.thevpc.nuts.runtime.standalone.repos.FilesFoldersApi;
import net.thevpc.nuts.runtime.standalone.repos.NutsCachedRepository;
import net.thevpc.nuts.runtime.standalone.repos.RemoteRepoApi;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsRepositorySPI;

public class MavenRemoteRepository
extends NutsCachedRepository {
    private final NutsLogger LOG;
    private final FilesFoldersApi.IteratorModel findModel = new FilesFoldersApi.AbstractIteratorModel(){

        @Override
        public void undeploy(NutsId id, NutsSession session) throws NutsExecutionException {
            throw new NutsUnsupportedOperationException(session, NutsMessage.cstyle((String)"not supported undeploy.", (Object[])new Object[0]));
        }

        @Override
        public boolean isDescFile(String pathname) {
            return pathname.endsWith(".pom");
        }

        @Override
        public NutsDescriptor parseDescriptor(String pathname, InputStream in, NutsFetchMode fetchMode, NutsRepository repository, NutsSession session, String rootURL) throws IOException {
            session.getTerminal().printProgress("%-8s %s", new Object[]{"parse", session.getWorkspace().io().path(pathname).toCompressedForm()});
            return MavenUtils.of(session).parsePomXml(in, fetchMode, pathname, repository);
        }

        @Override
        public NutsId parseId(String path, String rootPath, NutsIdFilter filter, NutsRepository repository, NutsSession session) throws IOException {
            String versionFolder;
            String fn = CoreIOUtils.getURLName(path);
            if (fn.endsWith(".pom") && (versionFolder = CoreIOUtils.getURLParent(path)).length() > 0) {
                String groupFolder;
                String an;
                String vn = CoreIOUtils.getURLName(versionFolder);
                String artifactFolder = CoreIOUtils.getURLParent(versionFolder);
                if (artifactFolder.length() > 0 && fn.equals((an = CoreIOUtils.getURLName(artifactFolder)) + "-" + vn + ".pom") && (groupFolder = CoreIOUtils.getURLParent(artifactFolder)).length() > 0) {
                    String[] gg = CoreIOUtils.urlTrimFirstSlash(groupFolder.substring(rootPath.length())).split("/");
                    StringBuilder gn = new StringBuilder();
                    for (int i = 0; i < gg.length; ++i) {
                        String ns = gg[i];
                        if (i > 0) {
                            gn.append('.');
                        }
                        gn.append(ns);
                    }
                    return this.validate(session.getWorkspace().id().builder().setGroupId(gn.toString()).setArtifactId(an).setVersion(vn).build(), null, path, rootPath, filter, repository, session);
                }
            }
            return null;
        }
    };
    private MvnClient wrapper;
    private RemoteRepoApi versionApi = RemoteRepoApi.DEFAULT;
    private RemoteRepoApi findApi = RemoteRepoApi.DEFAULT;
    private AbstractMavenRepositoryHelper helper = new AbstractMavenRepositoryHelper(this){

        @Override
        protected String getIdPath(NutsId id, NutsSession session) {
            return MavenRemoteRepository.this.getIdRemotePath(id, session);
        }

        @Override
        protected boolean exists(NutsId id, String path, Object source, String typeName, NutsSession session) {
            session.getTerminal().printProgress("%-8s %s", new Object[]{"search", session.getWorkspace().io().path(path).toCompressedForm()});
            try {
                InputStream s = session.getWorkspace().io().monitor().setSource(path).setOrigin(source).setSession(session).setSourceTypeName(typeName).createSource().open();
                Throwable throwable = null;
                if (s != null) {
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        s.close();
                    }
                }
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }

        @Override
        protected NutsInput openStream(NutsId id, String path, Object source, String typeName, String action, NutsSession session) {
            session.getTerminal().printProgress("%-8s %s", new Object[]{action, session.getWorkspace().io().path(path).toCompressedForm()});
            return session.getWorkspace().io().monitor().setSource(path).setOrigin(source).setSession(session).setSourceTypeName(typeName).createSource();
        }
    };

    protected MavenRemoteRepository(NutsAddRepositoryOptions options, NutsSession session, NutsRepository parentRepository, String repoType) {
        super(options, session, parentRepository, 1000, false, repoType);
        this.LOG = session.getWorkspace().log().of(MavenRemoteRepository.class);
        switch (repoType) {
            case "maven": {
                this.findApi = RemoteRepoApi.MAVEN;
                this.versionApi = RemoteRepoApi.MAVEN;
                break;
            }
            case "maven+dirtext": {
                this.findApi = RemoteRepoApi.DIR_TEXT;
                this.versionApi = RemoteRepoApi.DIR_TEXT;
                break;
            }
            case "maven+dirlist": {
                this.findApi = RemoteRepoApi.DIR_LIST;
                this.versionApi = RemoteRepoApi.DIR_LIST;
                break;
            }
            case "maven+github": {
                this.findApi = RemoteRepoApi.GITHUB;
                this.versionApi = RemoteRepoApi.GITHUB;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported maven repo type: " + repoType);
            }
        }
    }

    @Override
    public Iterator<NutsId> searchVersionsCore(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            return null;
        }
        if (id.getVersion().isSingleValue()) {
            String groupId = id.getGroupId();
            String artifactId = id.getArtifactId();
            ArrayList<NutsId> ret = new ArrayList<NutsId>();
            String metadataURL = CoreIOUtils.buildUrl(this.config().setSession(session).getLocation(true), groupId.replace('.', '/') + "/" + artifactId + "/" + id.getVersion().toString() + "/" + this.getIdFilename(id.builder().setFaceDescriptor().build(), session));
            if (this.helper.exists(id, metadataURL, id.builder().setFace("catalog").build(), "artifact catalog", session)) {
                ret.add(id);
            }
            return ret.iterator();
        }
        NutsIdFilter filter2 = ((NutsIdFilter)session.getWorkspace().id().filter().nonnull((NutsFilter)idFilter)).and(session.getWorkspace().id().filter().byName(new String[]{id.getShortName()}));
        switch (this.versionApi) {
            case DEFAULT: 
            case MAVEN: {
                return this.findVersionsImplMetadataXml(id, filter2, fetchMode, session);
            }
            case GITHUB: {
                return this.findVersionsImplGithub(id, filter2, fetchMode, session);
            }
            case DIR_TEXT: {
                return this.findVersionsImplFilesFolders(id, filter2, fetchMode, RemoteRepoApi.DIR_TEXT, session);
            }
            case DIR_LIST: {
                return this.findVersionsImplFilesFolders(id, filter2, fetchMode, RemoteRepoApi.DIR_LIST, session);
            }
            case UNSUPPORTED: {
                return null;
            }
        }
        throw new NutsUnsupportedEnumException(session, (Enum)this.versionApi);
    }

    @Override
    public NutsDescriptor fetchDescriptorCore(NutsId id, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        return this.helper.fetchDescriptorImpl(id, fetchMode, session);
    }

    @Override
    public NutsContent fetchContentCore(final NutsId id, NutsDescriptor descriptor, String localPath, NutsFetchMode fetchMode, final NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        if (this.wrapper == null) {
            this.wrapper = this.getWrapper();
        }
        NutsWorkspace ws = session.getWorkspace();
        if (this.wrapper != null && this.wrapper.get(id, this.config().getLocation(true), session)) {
            NutsRepository repo = this.getLocalMavenRepo(session);
            if (repo != null) {
                NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(session).repoSPI(repo);
                return repoSPI.fetchContent().setId(id).setDescriptor(descriptor).setLocalPath(localPath).setSession(session).setFetchMode(NutsFetchMode.LOCAL).run().getResult();
            }
            Path content = this.getMavenLocalFolderContent(id, session);
            if (content != null && Files.exists(content, new LinkOption[0])) {
                if (localPath == null) {
                    return new NutsDefaultContent(session.getWorkspace().io().path(content.toString()), true, false);
                }
                String tempFile = ws.io().tmp().setSession(session).setRepositoryId(this.getUuid()).createTempFile(content.getFileName().toString());
                ws.io().copy().setSession(session).from(content).to(tempFile).setSafe(true).run();
                return new NutsDefaultContent(session.getWorkspace().io().path(tempFile), true, false);
            }
        }
        if (localPath == null) {
            String p = this.helper.getIdPath(id, session);
            String tempFile = ws.io().tmp().setSession(session).setRepositoryId(this.getUuid()).createTempFile(new File(p).getName());
            try {
                ws.io().copy().setSession(session).from(this.helper.getStream(id, "artifact binaries", "retrieve", session)).to(tempFile).setValidator(new NutsIOCopyValidator(){

                    public void validate(InputStream in) throws IOException {
                        MavenRemoteRepository.this.helper.checkSHA1Hash(id.builder().setFace("content-hash").build(), in, "artifact binaries", session);
                    }
                }).run();
            }
            catch (UncheckedIOException | NutsIOException ex) {
                throw new NutsNotFoundException(session, id, null, ex);
            }
            return new NutsDefaultContent(session.getWorkspace().io().path(tempFile), true, true);
        }
        try {
            ws.io().copy().setSession(session).from(this.helper.getStream(id, "artifact content", "retrieve", session)).to(localPath).setValidator(in -> this.helper.checkSHA1Hash(id.builder().setFace("content-hash").build(), in, "artifact binaries", session)).setLogProgress(true).run();
        }
        catch (UncheckedIOException | NutsIOException ex) {
            throw new NutsNotFoundException(session, id, null, ex);
        }
        return new NutsDefaultContent(session.getWorkspace().io().path(localPath), true, false);
    }

    @Override
    public Iterator<NutsId> searchCore(NutsIdFilter filter, String[] roots, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            return null;
        }
        NutsRepositoryConfigManager config = this.config().setSession(session);
        switch (this.findApi) {
            case DEFAULT: 
            case GITHUB: 
            case DIR_TEXT: {
                ArrayList li = new ArrayList();
                for (String root : roots) {
                    session.getTerminal().printProgress("%-8s %s", new Object[]{"browse", session.getWorkspace().io().path(root).toCompressedForm()});
                    if (root.endsWith("/*")) {
                        String name = root.substring(0, root.length() - 2);
                        li.add(FilesFoldersApi.createIterator(this.getWorkspace(), this, config.getLocation(true), name, filter, RemoteRepoApi.DIR_TEXT, session, Integer.MAX_VALUE, this.findModel));
                        continue;
                    }
                    li.add(FilesFoldersApi.createIterator(this.getWorkspace(), this, config.getLocation(true), root, filter, RemoteRepoApi.DIR_TEXT, session, 2, this.findModel));
                }
                return IteratorUtils.concat(li);
            }
            case DIR_LIST: {
                ArrayList li = new ArrayList();
                for (String root : roots) {
                    session.getTerminal().printProgress("%-8s %s", new Object[]{"browse", session.getWorkspace().io().path(root).toCompressedForm()});
                    if (root.endsWith("/*")) {
                        String name = root.substring(0, root.length() - 2);
                        li.add(FilesFoldersApi.createIterator(this.getWorkspace(), this, config.getLocation(true), name, filter, RemoteRepoApi.DIR_LIST, session, Integer.MAX_VALUE, this.findModel));
                        continue;
                    }
                    li.add(FilesFoldersApi.createIterator(this.getWorkspace(), this, config.getLocation(true), root, filter, RemoteRepoApi.DIR_LIST, session, 2, this.findModel));
                }
                return IteratorUtils.concat(li);
            }
            case MAVEN: {
                String url = CoreIOUtils.buildUrl(config.getLocation(true), "/archetype-catalog.xml");
                try {
                    NutsInput s = CoreIOUtils.getCachedUrlWithSHA1(this.getWorkspace(), url, "archetype-catalog.xml", true, session);
                    InputStream is = session.getWorkspace().io().monitor().setSource(s.open()).setSession(session).create();
                    return MavenUtils.of(session).createArchetypeCatalogIterator(is, filter, true, session);
                }
                catch (UncheckedIOException ex) {
                    return IteratorUtils.emptyIterator();
                }
            }
            case UNSUPPORTED: {
                return null;
            }
        }
        throw new NutsUnsupportedEnumException(session, (Enum)this.versionApi);
    }

    @Override
    public boolean isAcceptFetchMode(NutsFetchMode mode, NutsSession session) {
        return true;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<NutsId> findVersionsImplGithub(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            return IteratorUtils.emptyIterator();
        }
        if (id.getVersion().isSingleValue()) {
            return this.findSingleVersionImpl(id, idFilter, fetchMode, session);
        }
        String location = this.config().getLocation(true);
        String[] all = location.split("/+");
        String userName = all[2];
        String repo = all[3];
        String apiUrlBase = "https://api.github.com/repos/" + userName + "/" + repo + "/contents";
        String groupId = id.getGroupId();
        String artifactId = id.getArtifactId();
        InputStream metadataStream = null;
        ArrayList<NutsId> ret = new ArrayList<NutsId>();
        try {
            String metadataURL = CoreIOUtils.buildUrl(apiUrlBase, groupId.replace('.', '/') + "/" + artifactId);
            try {
                metadataStream = this.helper.openStream(id, metadataURL, id.builder().setFace("catalog").build(), "artifact catalog", "retrieve", session).open();
            }
            catch (UncheckedIOException | NutsIOException ex) {
                throw new NutsNotFoundException(session, id, ex);
            }
            List info = (List)session.getWorkspace().elem().setContentType(NutsContentType.JSON).parse((Reader)new InputStreamReader(metadataStream), List.class);
            if (info != null) {
                NutsIdManager idMan = session.getWorkspace().id();
                for (Map version : info) {
                    if (!"dir".equals(version.get("type"))) continue;
                    String versionName = (String)version.get("name");
                    NutsId nutsId = id.builder().setVersion(versionName).build();
                    if (idFilter != null && !idFilter.acceptId(nutsId, session)) continue;
                    ret.add(idMan.builder().setGroupId(groupId).setArtifactId(artifactId).setVersion(versionName).build());
                }
            }
        }
        finally {
            if (metadataStream != null) {
                try {
                    metadataStream.close();
                }
                catch (IOException e) {
                    throw new NutsIOException(session, (Throwable)e);
                }
            }
        }
        return ret.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<NutsId> findVersionsImplMetadataXml(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            return null;
        }
        if (id.getVersion().isSingleValue()) {
            return this.findSingleVersionImpl(id, idFilter, fetchMode, session);
        }
        String groupId = id.getGroupId();
        String artifactId = id.getArtifactId();
        InputStream metadataStream = null;
        ArrayList<NutsId> ret = new ArrayList<NutsId>();
        try {
            String metadataURL = CoreIOUtils.buildUrl(this.config().getLocation(true), groupId.replace('.', '/') + "/" + artifactId + "/maven-metadata.xml");
            try {
                metadataStream = this.helper.openStream(id, metadataURL, id.builder().setFace("catalog").build(), "artifact catalog", "retrieve", session).open();
            }
            catch (UncheckedIOException | NutsIOException ex) {
                Iterator<NutsId> iterator = null;
                if (metadataStream != null) {
                    try {
                        metadataStream.close();
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                return iterator;
            }
            MavenMetadata info = MavenUtils.of(session).parseMavenMetaData(metadataStream, session);
            if (info != null) {
                NutsIdManager idMan = session.getWorkspace().id();
                for (String version : info.getVersions()) {
                    NutsId nutsId = id.builder().setVersion(version).build();
                    if (idFilter != null && !idFilter.acceptId(nutsId, session)) continue;
                    ret.add(idMan.builder().setGroupId(groupId).setArtifactId(artifactId).setVersion(version).build());
                }
            }
        }
        catch (UncheckedIOException | NutsIOException ex) {
            Iterator<NutsId> iterator = null;
            return iterator;
        }
        finally {
            if (metadataStream != null) {
                try {
                    metadataStream.close();
                }
                catch (IOException e) {
                    return null;
                }
            }
        }
        return ret.iterator();
    }

    public Iterator<NutsId> findSingleVersionImpl(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        if (id.getVersion().isSingleValue()) {
            String groupId = id.getGroupId();
            String artifactId = id.getArtifactId();
            ArrayList<NutsId> ret = new ArrayList<NutsId>();
            String metadataURL = CoreIOUtils.buildUrl(this.config().getLocation(true), groupId.replace('.', '/') + "/" + artifactId + "/" + id.getVersion().toString() + "/" + this.getIdFilename(id.builder().setFaceDescriptor().build(), session));
            if (this.helper.exists(id, metadataURL, id.builder().setFace("catalog").build(), "artifact catalog", session)) {
                ret.add(id);
            }
            return ret.iterator();
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"expected single version in %s", (Object[])new Object[]{id}));
    }

    public Iterator<NutsId> findVersionsImplFilesFolders(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, RemoteRepoApi versionApi, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            return IteratorUtils.emptyIterator();
        }
        if (id.getVersion().isSingleValue()) {
            return this.findSingleVersionImpl(id, idFilter, fetchMode, session);
        }
        String groupId = id.getGroupId();
        String artifactId = id.getArtifactId();
        ArrayList<NutsId> ret = new ArrayList<NutsId>();
        String foldersFileUrl = CoreIOUtils.buildUrl(this.config().setSession(session).getLocation(true), groupId.replace('.', '/') + "/" + artifactId);
        FilesFoldersApi.Item[] all = FilesFoldersApi.getDirItems(true, false, versionApi, foldersFileUrl, session);
        if (all != null) {
            NutsIdManager idMan = session.getWorkspace().id();
            for (FilesFoldersApi.Item version : all) {
                NutsId nutsId = id.builder().setVersion(version.getName()).build();
                if (idFilter != null && !idFilter.acceptId(nutsId, session)) continue;
                ret.add(idMan.builder().setGroupId(groupId).setArtifactId(artifactId).setVersion(version.getName()).build());
            }
        }
        return ret.iterator();
    }

    private NutsRepository getLocalMavenRepo(NutsSession session) {
        for (NutsRepository nutsRepository : session.getWorkspace().repos().setSession(session).getRepositories()) {
            if (!nutsRepository.getRepositoryType().equals("maven") || nutsRepository.config().getLocation(true) == null || !nutsRepository.config().getLocation(true).equals(Paths.get(session.getWorkspace().io().expandPath("~/.m2"), new String[0]).toString())) continue;
            return nutsRepository;
        }
        return null;
    }

    protected Path getMavenLocalFolderContent(NutsId id, NutsSession session) {
        String p = this.getIdRelativePath(id, session);
        if (p != null) {
            return Paths.get(System.getProperty("user.home"), ".m2", p);
        }
        return null;
    }

    private MvnClient getWrapper() {
        return null;
    }

    @Override
    protected String getIdExtension(NutsId id, NutsSession session) {
        return this.helper.getIdExtension(id, session);
    }
}

