/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.bridges.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchModeNotSupportedException;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.runtime.bundles.io.FolderNutIdIterator;
import net.thevpc.nuts.runtime.bundles.iter.IteratorUtils;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.bridges.maven.AbstractMavenRepositoryHelper;
import net.thevpc.nuts.runtime.standalone.bridges.maven.MavenUtils;
import net.thevpc.nuts.runtime.standalone.repos.NutsCachedRepository;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class MavenFolderRepository
extends NutsCachedRepository {
    protected final NutsLogger LOG;
    private final AbstractMavenRepositoryHelper helper = new AbstractMavenRepositoryHelper(this){

        @Override
        protected String getIdPath(NutsId id, NutsSession session) {
            return MavenFolderRepository.this.getLocationAsPath(session).resolve(CoreIOUtils.syspath(MavenFolderRepository.this.getIdRelativePath(id, session))).toString();
        }

        @Override
        protected NutsInput openStream(NutsId id, String path, Object source, String typeName, String action, NutsSession session) {
            return session.getWorkspace().io().input().setTypeName(typeName).of(Paths.get(path, new String[0]));
        }

        @Override
        protected boolean exists(NutsId id, String path, Object source, String typeName, NutsSession session) {
            return Files.isRegularFile(Paths.get(path, new String[0]), new LinkOption[0]);
        }

        @Override
        protected String getStreamSHA1(NutsId id, NutsSession session, String typeName) {
            return CoreIOUtils.evalSHA1Hex(this.getStream(id.builder().setFace("content-hash").build(), typeName, "verify", session).open(), true);
        }

        @Override
        protected void checkSHA1Hash(NutsId id, InputStream stream, String typeName, NutsSession session) {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new NutsIOException(session, (Throwable)e);
            }
        }
    };

    public MavenFolderRepository(NutsAddRepositoryOptions options, NutsSession session, NutsRepository parentRepository) {
        super(options, session, parentRepository, 100000, false, "maven");
        this.LOG = session.getWorkspace().log().of(MavenFolderRepository.class);
        if (options.getConfig().getStoreLocationStrategy() != NutsStoreLocationStrategy.STANDALONE) {
            this.cache.setWriteEnabled(false);
            this.cache.setReadEnabled(false);
        }
    }

    @Override
    protected boolean isAvailableImpl() {
        try {
            String loc = this.config().setSession(this.initSession).getLocation(true);
            return Files.isDirectory(Paths.get(loc, new String[0]), new LinkOption[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    private Path getLocationAsPath(NutsSession session) {
        return Paths.get(this.config().setSession(session).getLocation(true), new String[0]);
    }

    public Path getIdFile(NutsId id, NutsSession session) {
        String p = this.getIdRelativePath(id, session);
        if (p != null) {
            return this.getLocationAsPath(session).resolve(p);
        }
        return null;
    }

    @Override
    public NutsDescriptor fetchDescriptorCore(NutsId id, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode == NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        return this.helper.fetchDescriptorImpl(id, fetchMode, session);
    }

    @Override
    public NutsContent fetchContentCore(NutsId id, NutsDescriptor descriptor, String localPath, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode == NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        Path f = this.getIdFile(id, session);
        if (f == null) {
            throw new NutsNotFoundException(session, id, (Throwable)new RuntimeException("Invalid id"));
        }
        if (!Files.exists(f, new LinkOption[0])) {
            throw new NutsNotFoundException(session, id, (Throwable)new IOException("File not found : " + f));
        }
        if (localPath == null) {
            return new NutsDefaultContent(session.getWorkspace().io().path(f.toString()), true, false);
        }
        this.getWorkspace().io().copy().setSession(session).from(f).to(localPath).setSafe(true).run();
        return new NutsDefaultContent(session.getWorkspace().io().path(localPath), true, false);
    }

    protected Path getLocalGroupAndArtifactFile(NutsId id, NutsSession session) {
        NutsWorkspaceUtils.of(session).checkSimpleNameNutsId(id);
        Path groupFolder = this.getLocationAsPath(session).resolve(id.getGroupId().replace('.', File.separatorChar));
        return groupFolder.resolve(id.getArtifactId());
    }

    @Override
    public Iterator<NutsId> searchVersionsCore(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        Iterator<NutsId> namedNutIdIterator = null;
        if (fetchMode != NutsFetchMode.REMOTE) {
            if (id.getVersion().isSingleValue()) {
                Path f = this.getIdFile(id.builder().setFaceDescriptor().build(), session);
                if (f != null && Files.isRegularFile(f, new LinkOption[0])) {
                    return Collections.singletonList(id.builder().setRepository(this.getName()).build()).iterator();
                }
                return null;
            }
            try {
                namedNutIdIterator = this.findInFolder(this.getLocationAsPath(session), this.getLocalGroupAndArtifactFile(id, session), ((NutsIdFilter)session.getWorkspace().id().filter().nonnull((NutsFilter)idFilter)).and(session.getWorkspace().id().filter().byName(new String[]{id.getShortName()})), Integer.MAX_VALUE, session);
            }
            catch (NutsNotFoundException nutsNotFoundException) {
                // empty catch block
            }
        }
        return namedNutIdIterator;
    }

    @Override
    public NutsId searchLatestVersionCore(NutsId id, NutsIdFilter filter, NutsFetchMode fetchMode, NutsSession session) {
        if (id.getVersion().isBlank() && filter == null) {
            Path file = this.getLocalGroupAndArtifactFile(id, session);
            NutsId bestId = null;
            if (Files.isDirectory(file, new LinkOption[0])) {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(file, CoreIOUtils.DIR_FILTER);){
                    for (Path versionPath : stream) {
                        NutsId id2;
                        String fn;
                        if (!Files.exists(versionPath.resolve(fn = this.getIdFilename((id2 = id.builder().setVersion(versionPath.getFileName().toString()).build()).builder().setFaceDescriptor().build(), session)), new LinkOption[0]) || bestId != null && id2.getVersion().compareTo(bestId.getVersion()) <= 0) continue;
                        bestId = id2;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return bestId;
        }
        return super.searchLatestVersion(id, filter, fetchMode, session);
    }

    protected Iterator<NutsId> findInFolder(Path rootPath, Path folder, NutsIdFilter filter, int maxDepth, NutsSession session) {
        if (folder == null || !Files.exists(folder, new LinkOption[0]) || !Files.isDirectory(folder, new LinkOption[0])) {
            return null;
        }
        return new FolderNutIdIterator(this.getName(), folder, rootPath, filter, session, new MavenFolderRepositoryIteratorModel(), maxDepth);
    }

    @Override
    public Iterator<NutsId> searchCore(NutsIdFilter filter, String[] roots, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            Path locationFolder = this.getLocationAsPath(session);
            ArrayList list = new ArrayList();
            for (String root : roots) {
                if (root.endsWith("/*")) {
                    String name = root.substring(0, root.length() - 2);
                    list.add(this.findInFolder(locationFolder, locationFolder.resolve(name), filter, Integer.MAX_VALUE, session));
                    continue;
                }
                list.add(this.findInFolder(locationFolder, locationFolder.resolve(root), filter, 2, session));
            }
            return IteratorUtils.concat(list);
        }
        return null;
    }

    @Override
    public void updateStatistics2(final NutsSession session) {
        try {
            Files.walkFileTree(Paths.get(this.config().getLocation(true), new String[0]), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    throw new NutsIOException(session, NutsMessage.cstyle((String)"updateStatistics Not supported.", (Object[])new Object[0]));
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    throw new NutsIOException(session, NutsMessage.cstyle((String)"updateStatistics Not supported.", (Object[])new Object[0]));
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    throw new NutsIOException(session, NutsMessage.cstyle((String)"updateStatistics Not supported.", (Object[])new Object[0]));
                }
            });
        }
        catch (IOException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
    }

    @Override
    protected String getIdExtension(NutsId id, NutsSession session) {
        return this.helper.getIdExtension(id, session);
    }

    @Override
    public boolean isAcceptFetchMode(NutsFetchMode mode, NutsSession session) {
        return mode == NutsFetchMode.LOCAL;
    }

    class MavenFolderRepositoryIteratorModel
    extends FolderNutIdIterator.AbstractFolderNutIdIteratorModel {
        @Override
        public void undeploy(NutsId id, NutsSession session) {
            MavenFolderRepository.this.undeploy().setId(id).setSession(session).run();
        }

        @Override
        public boolean isDescFile(Path pathname) {
            return pathname.getFileName().toString().endsWith(".pom");
        }

        @Override
        public NutsDescriptor parseDescriptor(Path pathname, NutsSession session) throws IOException {
            return MavenUtils.of(session).parsePomXml(pathname, NutsFetchMode.LOCAL, MavenFolderRepository.this);
        }

        @Override
        public NutsId parseId(Path pomFile, Path rootPath, NutsIdFilter filter, String repository, NutsSession session) throws IOException {
            Path versionFolder;
            String fn;
            pomFile = pomFile.normalize();
            rootPath = rootPath.normalize();
            if (Files.isRegularFile(pomFile, new LinkOption[0]) && (fn = pomFile.getFileName().toString()).endsWith(".pom") && (versionFolder = pomFile.getParent()) != null) {
                Path groupFolder;
                String an;
                String vn = versionFolder.getFileName().toString();
                Path artifactFolder = versionFolder.getParent();
                if (artifactFolder != null && fn.equals((an = artifactFolder.getFileName().toString()) + "-" + vn + ".pom") && (groupFolder = artifactFolder.getParent()) != null) {
                    Path gg = groupFolder.subpath(rootPath.getNameCount(), groupFolder.getNameCount());
                    StringBuilder gn = new StringBuilder();
                    for (int i = 0; i < gg.getNameCount(); ++i) {
                        String ns = gg.getName(i).toString();
                        if (i > 0) {
                            gn.append('.');
                        }
                        gn.append(ns);
                    }
                    return this.validate(session.getWorkspace().id().builder().setGroupId(gn.toString()).setArtifactId(an).setVersion(vn).build(), null, filter, repository, session);
                }
            }
            return null;
        }
    }
}

