/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.thevpc.nuts.NutsDefaultSupportLevelContext;
import net.thevpc.nuts.NutsElementNotFoundException;
import net.thevpc.nuts.NutsFactoryException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrototype;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSingleton;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.collections.ClassClassMap;
import net.thevpc.nuts.runtime.bundles.collections.ListMap;
import net.thevpc.nuts.runtime.core.NutsWorkspaceFactory;
import net.thevpc.nuts.runtime.core.util.CoreServiceUtils;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.DefaultNutsWorkspace;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsComponent;

public class DefaultNutsWorkspaceFactory
implements NutsWorkspaceFactory {
    private final NutsLogger LOG;
    private final ListMap<Class, Object> instances = new ListMap();
    private final Map<Class, Object> singletons = new HashMap<Class, Object>();
    private final Map<NutsId, IdCache> discoveredCacheById = new HashMap<NutsId, IdCache>();
    private final NutsWorkspace workspace;

    public DefaultNutsWorkspaceFactory(NutsWorkspace ws) {
        this.workspace = ws;
        this.LOG = ((DefaultNutsWorkspace)ws).LOG;
    }

    @Override
    public Set<Class> discoverTypes(NutsId id, URL url, ClassLoader bootClassLoader, NutsSession session) {
        return this.discoverTypes(id, url, bootClassLoader, new Class[]{NutsComponent.class}, session);
    }

    @Override
    public Set<Class> discoverTypes(NutsId id, URL url, ClassLoader bootClassLoader, Class[] extensionPoints, NutsSession session) {
        if (!this.discoveredCacheById.containsKey(id)) {
            this.discoveredCacheById.put(id, new IdCache(id, url, bootClassLoader, this.LOG, extensionPoints, session));
        }
        return null;
    }

    @Override
    public <T extends NutsComponent<V>, V> T createSupported(Class<T> type, V supportCriteria, NutsSession session) {
        List<T> list = this.createAll(type, session);
        int bestSupportLevel = Integer.MIN_VALUE;
        NutsComponent bestObj = null;
        NutsDefaultSupportLevelContext context = new NutsDefaultSupportLevelContext(session, supportCriteria);
        for (NutsComponent t : list) {
            int supportLevel = t.getSupportLevel((NutsSupportLevelContext)context);
            if (supportLevel <= 0 || bestObj != null && supportLevel <= bestSupportLevel) continue;
            bestSupportLevel = supportLevel;
            bestObj = t;
        }
        return (T)bestObj;
    }

    @Override
    public <T extends NutsComponent<V>, V> T createSupported(Class<T> type, V supportCriteria, Class[] constructorParameterTypes, Object[] constructorParameters, NutsSession session) {
        List<T> list = this.createAll(type, constructorParameterTypes, constructorParameters, session);
        int bestSupportLevel = Integer.MIN_VALUE;
        NutsDefaultSupportLevelContext lc = new NutsDefaultSupportLevelContext(session, supportCriteria);
        NutsComponent bestObj = null;
        for (NutsComponent t : list) {
            int supportLevel = t.getSupportLevel((NutsSupportLevelContext)lc);
            if (supportLevel <= 0 || bestObj != null && supportLevel <= bestSupportLevel) continue;
            bestSupportLevel = supportLevel;
            bestObj = t;
        }
        return (T)bestObj;
    }

    @Override
    public <T extends NutsComponent<V>, V> List<T> createAllSupported(Class<T> type, V supportCriteria, NutsSession session) {
        List<T> list = this.createAll(type, session);
        NutsDefaultSupportLevelContext context = new NutsDefaultSupportLevelContext(session, supportCriteria);
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            NutsComponent t = (NutsComponent)iterator.next();
            int supportLevel = t.getSupportLevel((NutsSupportLevelContext)context);
            if (supportLevel > 0) continue;
            iterator.remove();
        }
        return list;
    }

    @Override
    public <T> List<T> createAll(Class<T> type, NutsSession session) {
        ArrayList<Object> all = new ArrayList<Object>();
        for (Object obj : this.instances.getAll(type)) {
            all.add(obj);
        }
        LinkedHashSet<Class> allTypes = new LinkedHashSet<Class>();
        allTypes.addAll(this.getExtensionTypes(type, session));
        for (Class c : allTypes) {
            Object obj = null;
            try {
                obj = this.resolveInstance(c, type, session);
            }
            catch (Exception e) {
                this.LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.FAIL).formatted().error((Throwable)e).log("unable to instantiate {0} for {1} : {2}", new Object[]{c, type, e});
            }
            if (obj == null) continue;
            all.add(obj);
        }
        return all;
    }

    @Override
    public Set<Class> getExtensionTypes(Class type, NutsSession session) {
        LinkedHashSet<Class> all = new LinkedHashSet<Class>();
        for (IdCache v : this.discoveredCacheById.values()) {
            all.addAll(v.getExtensionTypes(type));
        }
        return all;
    }

    @Override
    public List<Object> getExtensionObjects(Class extensionPoint) {
        return new ArrayList<Object>(this.instances.getAll(extensionPoint));
    }

    @Override
    public boolean isRegisteredType(Class extensionPoint, String implementation, NutsSession session) {
        return this.findRegisteredType(extensionPoint, implementation, session) != null;
    }

    @Override
    public boolean isRegisteredInstance(Class extensionPoint, Object implementation, NutsSession session) {
        return this.instances.contains(extensionPoint, implementation);
    }

    @Override
    public <T> void registerInstance(Class<T> extensionPoint, T implementation, NutsSession session) {
        this.checkSession(session);
        if (this.isRegisteredInstance(extensionPoint, implementation, session)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"already registered Extension %s for %s", (Object[])new Object[]{implementation, extensionPoint.getName()}));
        }
        if (this.LOG.isLoggable(Level.CONFIG)) {
            this.LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.UPDATE).formatted().log("bind    {0} for impl instance {1}", new Object[]{CoreStringUtils.alignLeft(extensionPoint.getSimpleName(), 40), implementation.getClass().getName()});
        }
        this.instances.add(extensionPoint, implementation);
    }

    @Override
    public void registerType(Class extensionPoint, Class implementation, NutsId source, NutsSession session) {
        ClassClassMap y;
        IdCache t;
        this.checkSession(session);
        if (this.isRegisteredType(extensionPoint, implementation.getName(), session)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"already registered Extension %s for %s", (Object[])new Object[]{implementation.getName(), extensionPoint.getName()}));
        }
        if (this.LOG.isLoggable(Level.CONFIG)) {
            this.LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.UPDATE).formatted().log("bind    {0} for impl type {1}", new Object[]{CoreStringUtils.alignLeft(extensionPoint.getSimpleName(), 40), implementation.getName()});
        }
        if ((t = this.discoveredCacheById.get(source)) == null) {
            t = new IdCache(source);
            this.discoveredCacheById.put(source, t);
        }
        if (!(y = t.getClassClassMap(NutsComponent.class, true)).containsExactKey(implementation)) {
            y.add(implementation);
        }
    }

    @Override
    public boolean isRegisteredType(Class extensionPoint, Class implementation, NutsSession session) {
        return this.getExtensionTypes(extensionPoint, session).contains(implementation);
    }

    public Class findRegisteredType(Class extensionPoint, String implementation, NutsSession session) {
        for (Class cls : this.getExtensionTypes(extensionPoint, session)) {
            if (!cls.getName().equals(implementation)) continue;
            return cls;
        }
        return null;
    }

    private void checkSession(NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.workspace, session);
    }

    private Object resolveClassSource(Class implementation) {
        return null;
    }

    protected <T> T instantiate0(Class<T> t, NutsSession session) {
        this.checkSession(session);
        T theInstance = null;
        try {
            theInstance = t.newInstance();
        }
        catch (InstantiationException e) {
            Throwable cause;
            if (this.LOG.isLoggable(Level.FINEST)) {
                this.LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.FAIL).formatted().error((Throwable)e).log("unable to instantiate {0}", new Object[]{t});
            }
            if ((cause = e.getCause()) == null) {
                cause = e;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new NutsFactoryException(session, NutsMessage.cstyle((String)"instantiate '%s' failed", (Object[])new Object[]{t}), cause);
        }
        catch (IllegalAccessException e) {
            throw new NutsFactoryException(session, NutsMessage.cstyle((String)"instantiate '%s' failed", (Object[])new Object[]{t}), (Throwable)e);
        }
        return theInstance;
    }

    protected <T> T instantiate0(Class<T> t, Class[] argTypes, Object[] args, NutsSession session) {
        this.checkSession(session);
        T t1 = null;
        try {
            t1 = t.getConstructor(argTypes).newInstance(args);
        }
        catch (InstantiationException e) {
            Throwable cause;
            if (this.LOG.isLoggable(Level.FINEST)) {
                this.LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.FAIL).formatted().error((Throwable)e).log("unable to instantiate {0}", new Object[]{t});
            }
            if ((cause = e.getCause()) == null) {
                cause = e;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new NutsFactoryException(session, NutsMessage.cstyle((String)"instantiate '%s' failed", (Object[])new Object[]{t}), cause);
        }
        catch (Exception e) {
            if (this.LOG.isLoggable(Level.FINEST)) {
                this.LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.FAIL).formatted().error((Throwable)e).log("unable to instantiate {0}", new Object[]{t});
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new NutsFactoryException(session, NutsMessage.cstyle((String)"instantiate '%s' failed", (Object[])new Object[]{t}), (Throwable)e);
        }
        return t1;
    }

    protected <T> T resolveInstance(Class<T> type, Class<T> baseType, NutsSession session) {
        if (type == null) {
            return null;
        }
        Boolean singleton = null;
        if (baseType.getAnnotation(NutsSingleton.class) != null) {
            singleton = true;
        } else if (baseType.getAnnotation(NutsPrototype.class) != null) {
            singleton = false;
        }
        if (type.getAnnotation(NutsSingleton.class) != null) {
            singleton = true;
        } else if (type.getAnnotation(NutsPrototype.class) != null) {
            singleton = false;
        }
        if (singleton == null) {
            singleton = false;
        }
        if (singleton.booleanValue()) {
            Object o = this.singletons.get(type);
            if (o == null) {
                o = this.instantiate0(type, session);
                this.singletons.put(type, o);
                if (this.LOG.isLoggable(Level.CONFIG)) {
                    this.LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.READ).formatted().log("resolve {0} to  ```underlined singleton``` {1}", new Object[]{CoreStringUtils.alignLeft(baseType.getSimpleName(), 40), o.getClass().getName()});
                }
            }
            return (T)o;
        }
        T o = this.instantiate0(type, session);
        if (this.LOG.isLoggable(Level.CONFIG)) {
            this.LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.READ).formatted().log("resolve {0} to  ```underlined prototype``` {1}", new Object[]{CoreStringUtils.alignLeft(baseType.getSimpleName(), 40), o.getClass().getName()});
        }
        return o;
    }

    protected <T> T resolveInstance(Class<T> type, Class<T> baseType, Class[] argTypes, Object[] args, NutsSession session) {
        this.checkSession(session);
        if (type == null) {
            return null;
        }
        Boolean singleton = null;
        if (baseType.getAnnotation(NutsSingleton.class) != null) {
            singleton = true;
        } else if (baseType.getAnnotation(NutsPrototype.class) != null) {
            singleton = false;
        }
        if (type.getAnnotation(NutsSingleton.class) != null) {
            singleton = true;
        } else if (type.getAnnotation(NutsPrototype.class) != null) {
            singleton = false;
        }
        if (singleton == null) {
            singleton = false;
        }
        if (singleton.booleanValue()) {
            if (argTypes.length > 0) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"singletons should have no arg types", (Object[])new Object[0]));
            }
            Object o = this.singletons.get(type);
            if (o == null) {
                o = this.instantiate0(type, session);
                this.singletons.put(type, o);
                if (this.LOG.isLoggable(Level.CONFIG)) {
                    this.LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.READ).formatted().log("resolve {0} to  ```underlined singleton``` {1}", new Object[]{CoreStringUtils.alignLeft(baseType.getSimpleName(), 40), o.getClass().getName()});
                }
            }
            return (T)o;
        }
        T o = this.instantiate0(type, argTypes, args, session);
        if (this.LOG.isLoggable(Level.CONFIG)) {
            this.LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.READ).formatted().log("resolve {0} to  ```underlined prototype``` {1}", new Object[]{CoreStringUtils.alignLeft(baseType.getSimpleName(), 40), o.getClass().getName()});
        }
        return o;
    }

    public <T> T create(Class<T> type, NutsSession session) {
        this.checkSession(session);
        Object one = this.instances.getOne(type);
        if (one != null) {
            if (this.LOG.isLoggable(Level.CONFIG)) {
                this.LOG.with().session(session).level(Level.FINEST).verb(NutsLogVerb.READ).formatted().log("resolve {0} to singleton {1}", new Object[]{CoreStringUtils.alignLeft(type.getSimpleName(), 40), one.getClass().getName()});
            }
            return (T)one;
        }
        Set<Class> extensionTypes = this.getExtensionTypes(type, session);
        Iterator<Class> iterator = extensionTypes.iterator();
        if (iterator.hasNext()) {
            Class e = iterator.next();
            return this.resolveInstance(e, type, session);
        }
        iterator = extensionTypes.iterator();
        if (iterator.hasNext()) {
            Class t = iterator.next();
            return this.instantiate0(t, session);
        }
        throw new NutsElementNotFoundException(session, NutsMessage.cstyle((String)"type %s not found", (Object[])new Object[]{type}));
    }

    public <T> List<T> createAll(Class<T> type, Class[] argTypes, Object[] args, NutsSession session) {
        ArrayList<Object> all = new ArrayList<Object>();
        for (Class c : this.getExtensionTypes(type, session)) {
            Object obj = null;
            try {
                obj = this.resolveInstance(c, type, argTypes, args, session);
            }
            catch (Exception e) {
                this.LOG.with().session(session).level(Level.WARNING).verb(NutsLogVerb.FAIL).formatted().error((Throwable)e).log("unable to instantiate {0} for {1} : {2}", new Object[]{c, type, e});
            }
            if (obj == null) continue;
            all.add(obj);
        }
        return all;
    }

    private static class IdCache {
        private final NutsId id;
        private URL url;
        private final Map<Class, ClassClassMap> classes = new HashMap<Class, ClassClassMap>();

        public IdCache(NutsId id) {
            this.id = id;
        }

        public IdCache(NutsId id, URL url, ClassLoader bootClassLoader, NutsLogger LOG, Class[] extensionPoints, NutsSession session) {
            this.id = id;
            this.url = url;
            for (Class extensionPoint : extensionPoints) {
                ClassClassMap cc = new ClassClassMap();
                this.classes.put(extensionPoint, cc);
                Class<NutsComponent> serviceClass = NutsComponent.class;
                for (String n : CoreServiceUtils.loadZipServiceClassNames(url, serviceClass)) {
                    Class<?> c = null;
                    try {
                        c = Class.forName(n, false, bootClassLoader);
                    }
                    catch (ClassNotFoundException x) {
                        LOG.with().session(session).verb(NutsLogVerb.WARNING).level(Level.FINE).error((Throwable)x).log("not a valid type {0}", new Object[]{c});
                    }
                    if (c == null) continue;
                    if (!serviceClass.isAssignableFrom(c)) {
                        LOG.with().session(session).verb(NutsLogVerb.WARNING).level(Level.FINE).log("not a valid type {0} <> {1}, ignore...", new Object[]{c, serviceClass});
                        continue;
                    }
                    cc.add(c);
                }
            }
        }

        private ClassClassMap getClassClassMap(Class extensionPoint, boolean create) {
            ClassClassMap r = this.classes.get(extensionPoint);
            if (r == null && create) {
                r = new ClassClassMap();
                this.classes.put(extensionPoint, r);
            }
            return r;
        }

        public NutsId getId() {
            return this.id;
        }

        public URL getUrl() {
            return this.url;
        }

        public Set<Class> getExtensionPoints() {
            return new LinkedHashSet<Class>(this.classes.keySet());
        }

        public Set<Class> getExtensionTypes(Class extensionPoint) {
            LinkedHashSet<Class> all = new LinkedHashSet<Class>();
            for (Map.Entry<Class, ClassClassMap> rr : this.classes.entrySet()) {
                if (!rr.getKey().isAssignableFrom(extensionPoint)) continue;
                all.addAll(Arrays.asList(rr.getValue().getAll(extensionPoint)));
            }
            return all;
        }
    }

    private static final class ClassExtension {
        Class clazz;
        Object source;
        boolean enabled = true;

        public ClassExtension(Class clazz, Object source, boolean enabled) {
            this.clazz = clazz;
            this.source = source;
            this.enabled = enabled;
        }
    }
}

