/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyleGenerator;
import net.thevpc.nuts.NutsTextStyles;

public class DefaultNutsTextStyleGenerator
implements NutsTextStyleGenerator {
    private boolean includeForeground;
    private boolean includeBackground;
    private int colors = 8;
    private boolean includePlain;
    private boolean includeBold;
    private boolean includeBlink;
    private boolean includeReversed;
    private boolean includeItalic;
    private boolean includeUnderlined;
    private boolean includeStriked;
    private Random rnd = new Random();
    private List<NutsTextStyle> decos;
    private List<Function<Integer, NutsTextStyles>> supps;

    private int resolveColorType() {
        switch (this.colors) {
            case 0: 
            case 4: {
                return 1;
            }
            case 2: 
            case 8: {
                return 2;
            }
            case 3: 
            case 24: {
                return 3;
            }
        }
        return 3;
    }

    private NutsTextStyle fg(int i) {
        switch (this.resolveColorType()) {
            case 1: {
                if (i < 0) {
                    i = this.rnd.nextInt(16);
                }
                return NutsTextStyle.primary((int)(i % 16));
            }
            case 2: {
                if (i < 0) {
                    i = this.rnd.nextInt(256);
                }
                return NutsTextStyle.foregroundColor((int)(i % 256));
            }
        }
        if (i < 0) {
            i = this.rnd.nextInt(0x2000000);
        }
        return NutsTextStyle.foregroundTrueColor((int)(i % 0x2000000));
    }

    private NutsTextStyle bg(int i) {
        switch (this.resolveColorType()) {
            case 1: {
                if (i < 0) {
                    i = this.rnd.nextInt(16);
                }
                return NutsTextStyle.secondary((int)(i % 16));
            }
            case 2: {
                if (i < 0) {
                    i = this.rnd.nextInt(256);
                }
                return NutsTextStyle.backgroundColor((int)(i % 256));
            }
        }
        if (i < 0) {
            i = this.rnd.nextInt(0x2000000);
        }
        return NutsTextStyle.backgroundTrueColor((int)(i % 0x2000000));
    }

    private List<Function<Integer, NutsTextStyles>> supps() {
        if (this.supps == null) {
            boolean includeAny = this.isIncludeAny();
            this.supps = new ArrayList<Function<Integer, NutsTextStyles>>();
            if (this.includePlain || includeAny) {
                this.supps.add(i -> NutsTextStyles.NONE);
            }
            if (this.includeForeground || includeAny) {
                this.supps.add(i -> {
                    NutsTextStyle s = this.fg((int)i);
                    if (!this.decos().isEmpty() && this.rnd.nextBoolean()) {
                        NutsTextStyle s2 = this.decos().get(this.rnd.nextInt(this.decos().size()));
                        return NutsTextStyles.of((NutsTextStyle[])new NutsTextStyle[]{s, s2});
                    }
                    return NutsTextStyles.of((NutsTextStyle)s);
                });
            }
            if (this.includeBackground || includeAny) {
                this.supps.add(i -> {
                    NutsTextStyle s = this.bg(-1);
                    if (!this.decos().isEmpty() && this.rnd.nextBoolean()) {
                        NutsTextStyle s2 = this.decos().get(this.rnd.nextInt(this.decos().size()));
                        return NutsTextStyles.of((NutsTextStyle[])new NutsTextStyle[]{s, s2});
                    }
                    return NutsTextStyles.of((NutsTextStyle)s);
                });
            }
            if (!this.decos().isEmpty() && this.rnd.nextBoolean()) {
                this.supps.add(i -> {
                    NutsTextStyle s2 = this.decos().get(this.rnd.nextInt(this.decos().size()));
                    return NutsTextStyles.of((NutsTextStyle)s2);
                });
            }
        }
        return this.supps;
    }

    public NutsTextStyles hash(Object i) {
        return this.hash(i == null ? 0 : i.hashCode());
    }

    public NutsTextStyles hash(int i) {
        i = Math.abs(i);
        int a = (i & 3) % this.supps().size();
        return this.supps().get(a).apply(i >>= 2);
    }

    public NutsTextStyles random() {
        return this.supps().get(this.rnd.nextInt(this.supps().size())).apply(-1);
    }

    public boolean isIncludePlain() {
        return this.includePlain;
    }

    public NutsTextStyleGenerator setIncludePlain(boolean includePlain) {
        this.includePlain = includePlain;
        return this;
    }

    public boolean isIncludeBold() {
        return this.includeBold;
    }

    public NutsTextStyleGenerator setIncludeBold(boolean includeBold) {
        this.includeBold = includeBold;
        return this;
    }

    public boolean isIncludeBlink() {
        return this.includeBlink;
    }

    public NutsTextStyleGenerator setIncludeBlink(boolean includeBlink) {
        this.includeBlink = includeBlink;
        return this;
    }

    public boolean isIncludeReversed() {
        return this.includeReversed;
    }

    public NutsTextStyleGenerator setIncludeReversed(boolean includeReversed) {
        this.includeReversed = includeReversed;
        return this;
    }

    public boolean isIncludeItalic() {
        return this.includeItalic;
    }

    public NutsTextStyleGenerator setIncludeItalic(boolean includeItalic) {
        this.includeItalic = includeItalic;
        return this;
    }

    public boolean isIncludeUnderlined() {
        return this.includeUnderlined;
    }

    public NutsTextStyleGenerator setIncludeUnderlined(boolean includeUnderlined) {
        this.includeUnderlined = includeUnderlined;
        return this;
    }

    public boolean isIncludeStriked() {
        return this.includeStriked;
    }

    public NutsTextStyleGenerator setIncludeStriked(boolean includeStriked) {
        this.includeStriked = includeStriked;
        return this;
    }

    private List<NutsTextStyle> decos() {
        boolean includeAny = this.isIncludeAny();
        if (this.decos == null) {
            this.decos = new ArrayList<NutsTextStyle>();
            if (this.includeStriked || includeAny) {
                this.decos.add(NutsTextStyle.striked());
            }
            if (this.includeBold || includeAny) {
                this.decos.add(NutsTextStyle.bold());
            }
            if (this.includeBlink || includeAny) {
                this.decos.add(NutsTextStyle.blink());
            }
            if (this.includeReversed || includeAny) {
                this.decos.add(NutsTextStyle.reversed());
            }
            if (this.includeItalic || includeAny) {
                this.decos.add(NutsTextStyle.italic());
            }
            if (this.includeUnderlined || includeAny) {
                this.decos.add(NutsTextStyle.underlined());
            }
        }
        return this.decos;
    }

    public boolean isIncludeAny() {
        return !this.includeForeground && !this.includeBackground && !this.includeBold && !this.includeBlink && !this.includeUnderlined && !this.includeReversed && !this.includeStriked && !this.includeItalic && !this.includePlain;
    }

    public boolean isIncludeForeground() {
        return this.includeForeground;
    }

    public NutsTextStyleGenerator setIncludeForeground(boolean includeForeground) {
        this.includeForeground = includeForeground;
        return this;
    }

    public boolean isIncludeBackground() {
        return this.includeBackground;
    }

    public NutsTextStyleGenerator setIncludeBackground(boolean includeBackground) {
        this.includeBackground = includeBackground;
        return this;
    }

    public boolean isUseThemeColors() {
        return this.colors == 4;
    }

    public boolean isUsePaletteColors() {
        return this.colors == 8;
    }

    public boolean isUseTrueColors() {
        return this.colors == 24;
    }

    public NutsTextStyleGenerator setUseThemeColors() {
        this.colors = 4;
        return this;
    }

    public NutsTextStyleGenerator setUsePaletteColors() {
        this.colors = 8;
        return this;
    }

    public NutsTextStyleGenerator setUseTrueColors() {
        this.colors = 24;
        return this;
    }
}

