/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.io.IOException;
import java.io.InputStream;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.NamedByteArrayInputStream;
import net.thevpc.nuts.spi.NutsDescriptorContentParserContext;

public class DefaultNutsDescriptorContentParserContext
implements NutsDescriptorContentParserContext {
    private final NutsSession session;
    private final NutsInput file;
    private final String fileExtension;
    private final String mimeType;
    private byte[] bytes;
    private final String[] parseOptions;

    public DefaultNutsDescriptorContentParserContext(NutsSession session, NutsInput file, String fileExtension, String mimeType, String[] parseOptions) {
        this.file = session.getWorkspace().io().input().setMultiRead(true).of(file);
        this.session = session;
        this.fileExtension = fileExtension;
        this.mimeType = mimeType;
        this.parseOptions = parseOptions;
    }

    public NutsWorkspace getWorkspace() {
        return this.getSession().getWorkspace();
    }

    public NutsSession getSession() {
        return this.session;
    }

    public String[] getParseOptions() {
        return this.parseOptions;
    }

    public InputStream getHeadStream() {
        if (this.bytes == null) {
            try (InputStream is = this.file.open();){
                this.bytes = CoreIOUtils.loadByteArray(is, 0xA00000, true);
            }
            catch (IOException e) {
                throw new NutsIOException(this.session, (Throwable)e);
            }
        }
        return new NamedByteArrayInputStream(this.bytes, this.file.getName());
    }

    public InputStream getFullStream() {
        return this.file.open();
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getName() {
        return this.file.getName();
    }
}

