/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.io.File;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.NutsClassLoaderNode;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspaceInitInformation;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.boot.NutsBootDescriptor;
import net.thevpc.nuts.boot.NutsBootId;
import net.thevpc.nuts.runtime.core.model.CoreNutsWorkspaceOptions;
import net.thevpc.nuts.spi.NutsBootWorkspaceFactory;

public final class CoreNutsWorkspaceInitInformation
implements NutsWorkspaceInitInformation {
    private NutsWorkspaceOptions options;
    private String apiVersion;
    private NutsBootId runtimeId;
    private NutsBootDescriptor runtimeBootDescriptor;
    private NutsClassLoaderNode runtimeBootDependencyNode;
    private NutsBootDescriptor[] extensionBootDescriptors;
    private NutsClassLoaderNode[] extensionBootDependencyNodes;
    private NutsBootWorkspaceFactory bootWorkspaceFactory;
    private URL[] bootClassWorldURLs;
    private ClassLoader workspaceClassLoader;
    private String uuid;
    private String name;
    private String workspace;
    private LinkedHashSet<String> extensionsSet;
    private String bootRepositories;
    private String javaCommand;
    private String javaOptions;
    private NutsStoreLocationStrategy storeLocationStrategy;
    private NutsStoreLocationStrategy repositoryStoreLocationStrategy;
    private NutsOsFamily storeLocationLayout;
    private boolean global;
    private Map<String, String> storeLocations;
    private Map<String, String> homeLocations;
    private NutsSession session;

    public CoreNutsWorkspaceInitInformation(NutsWorkspaceInitInformation boot, NutsSession session) {
        this.session = session;
        this.options = new CoreNutsWorkspaceOptions(session).setAll(boot.getOptions()).build();
        this.apiVersion = boot.getApiVersion();
        this.runtimeId = boot.getRuntimeId();
        this.runtimeBootDescriptor = boot.getRuntimeBootDescriptor();
        this.runtimeBootDependencyNode = boot.getRuntimeBootDependencyNode();
        this.extensionBootDescriptors = boot.getExtensionBootDescriptors();
        this.extensionBootDependencyNodes = boot.getExtensionBootDependencyNodes();
        this.bootWorkspaceFactory = boot.getBootWorkspaceFactory();
        this.bootClassWorldURLs = boot.getClassWorldURLs();
        this.workspaceClassLoader = boot.getClassWorldLoader();
        this.uuid = boot.getUuid();
        this.name = boot.getName();
        this.workspace = boot.getWorkspaceLocation();
        this.extensionsSet = boot.getExtensionsSet() == null ? new LinkedHashSet() : new LinkedHashSet(boot.getExtensionsSet());
        this.bootRepositories = boot.getBootRepositories();
        this.javaCommand = boot.getJavaCommand();
        this.javaOptions = boot.getJavaOptions();
        this.storeLocationStrategy = boot.getStoreLocationStrategy();
        this.repositoryStoreLocationStrategy = boot.getRepositoryStoreLocationStrategy();
        this.storeLocationLayout = boot.getStoreLocationLayout();
        this.global = boot.isGlobal();
        this.storeLocations = boot.getStoreLocations() == null ? new LinkedHashMap<String, String>() : new LinkedHashMap(boot.getStoreLocations());
        this.homeLocations = boot.getHomeLocations() == null ? new LinkedHashMap<String, String>() : new LinkedHashMap(boot.getHomeLocations());
    }

    public NutsWorkspaceOptions getOptions() {
        return this.options;
    }

    public CoreNutsWorkspaceInitInformation setOptions(NutsWorkspaceOptions options) {
        this.options = options;
        if (options != null) {
            this.setWorkspaceLocation(options.getWorkspace());
            this.setName(options.getName());
            this.setStoreLocationStrategy(options.getStoreLocationStrategy());
            this.setRepositoryStoreLocationStrategy(options.getRepositoryStoreLocationStrategy());
            this.setStoreLocationLayout(options.getStoreLocationLayout());
            this.storeLocations = new LinkedHashMap<String, String>(options.getStoreLocations());
            this.homeLocations = new LinkedHashMap<String, String>(options.getHomeLocations());
            this.setRuntimeId(options.getRuntimeId() == null ? null : NutsBootId.parse((String)options.getRuntimeId()));
            this.global = options.isGlobal();
            this.javaCommand = options.getJavaCommand();
            this.javaOptions = options.getJavaOptions();
            this.apiVersion = NutsUtilStrings.trimToNull((String)options.getApiVersion());
        }
        return this;
    }

    public String getWorkspaceLocation() {
        return this.workspace;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public CoreNutsWorkspaceInitInformation setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public NutsBootId getRuntimeId() {
        return this.runtimeId;
    }

    public NutsBootDescriptor getRuntimeBootDescriptor() {
        return this.runtimeBootDescriptor;
    }

    public CoreNutsWorkspaceInitInformation setRuntimeBootDescriptor(NutsBootDescriptor runtimeBootDescriptor) {
        this.runtimeBootDescriptor = runtimeBootDescriptor;
        return this;
    }

    public NutsBootDescriptor[] getExtensionBootDescriptors() {
        return this.extensionBootDescriptors;
    }

    public CoreNutsWorkspaceInitInformation setExtensionBootDescriptors(NutsBootDescriptor[] extensionBootDescriptors) {
        this.extensionBootDescriptors = extensionBootDescriptors;
        return this;
    }

    public String getBootRepositories() {
        return this.bootRepositories;
    }

    public NutsBootWorkspaceFactory getBootWorkspaceFactory() {
        return this.bootWorkspaceFactory;
    }

    public CoreNutsWorkspaceInitInformation setBootWorkspaceFactory(NutsBootWorkspaceFactory bootWorkspaceFactory) {
        this.bootWorkspaceFactory = bootWorkspaceFactory;
        return this;
    }

    public URL[] getClassWorldURLs() {
        return this.bootClassWorldURLs;
    }

    public ClassLoader getClassWorldLoader() {
        return this.workspaceClassLoader;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getApiId() {
        return "net.thevpc.nuts:nuts#" + this.apiVersion;
    }

    public String getJavaCommand() {
        return this.javaCommand;
    }

    public CoreNutsWorkspaceInitInformation setJavaCommand(String javaCommand) {
        this.javaCommand = javaCommand;
        return this;
    }

    public String getJavaOptions() {
        return this.javaOptions;
    }

    public CoreNutsWorkspaceInitInformation setJavaOptions(String javaOptions) {
        this.javaOptions = javaOptions;
        return this;
    }

    public NutsStoreLocationStrategy getStoreLocationStrategy() {
        return this.storeLocationStrategy;
    }

    public CoreNutsWorkspaceInitInformation setStoreLocationStrategy(NutsStoreLocationStrategy storeLocationStrategy) {
        this.storeLocationStrategy = storeLocationStrategy;
        return this;
    }

    public NutsOsFamily getStoreLocationLayout() {
        return this.storeLocationLayout;
    }

    public CoreNutsWorkspaceInitInformation setStoreLocationLayout(NutsOsFamily storeLocationLayout) {
        this.storeLocationLayout = storeLocationLayout;
        return this;
    }

    public NutsStoreLocationStrategy getRepositoryStoreLocationStrategy() {
        return this.repositoryStoreLocationStrategy;
    }

    public CoreNutsWorkspaceInitInformation setRepositoryStoreLocationStrategy(NutsStoreLocationStrategy repositoryStoreLocationStrategy) {
        this.repositoryStoreLocationStrategy = repositoryStoreLocationStrategy;
        return this;
    }

    public String getStoreLocation(NutsStoreLocation location) {
        Map<String, String> s = this.storeLocations;
        if (s != null) {
            return s.get(location.id());
        }
        return null;
    }

    public Map<String, String> getStoreLocations() {
        return this.storeLocations;
    }

    public void setStoreLocations(Map<String, String> storeLocations) {
        this.storeLocations = storeLocations;
    }

    public Map<String, String> getHomeLocations() {
        return this.homeLocations;
    }

    public void setHomeLocations(Map<String, String> homeLocations) {
        this.homeLocations = homeLocations;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public Set<String> getExtensionsSet() {
        return this.extensionsSet;
    }

    public void setExtensionsSet(Set<String> extensionsSet) {
        this.extensionsSet = extensionsSet == null ? new LinkedHashSet() : new LinkedHashSet<String>(extensionsSet);
    }

    public NutsClassLoaderNode getRuntimeBootDependencyNode() {
        return this.runtimeBootDependencyNode;
    }

    public CoreNutsWorkspaceInitInformation setRuntimeBootDependencyNode(NutsClassLoaderNode runtimeBootDependencyNode) {
        this.runtimeBootDependencyNode = runtimeBootDependencyNode;
        return this;
    }

    public NutsClassLoaderNode[] getExtensionBootDependencyNodes() {
        return this.extensionBootDependencyNodes;
    }

    public CoreNutsWorkspaceInitInformation setExtensionBootDependencyNodes(NutsClassLoaderNode[] extensionBootDependencyNodes) {
        this.extensionBootDependencyNodes = extensionBootDependencyNodes;
        return this;
    }

    public CoreNutsWorkspaceInitInformation setBootRepositories(String repositories) {
        this.bootRepositories = repositories;
        return this;
    }

    public CoreNutsWorkspaceInitInformation setRuntimeId(NutsBootId runtimeId) {
        this.runtimeId = runtimeId;
        return this;
    }

    public CoreNutsWorkspaceInitInformation setWorkspaceLocation(String workspace) {
        this.workspace = workspace;
        return this;
    }

    public CoreNutsWorkspaceInitInformation setBootClassWorldURLs(URL[] bootClassWorldURLs) {
        this.bootClassWorldURLs = bootClassWorldURLs;
        return this;
    }

    public CoreNutsWorkspaceInitInformation setWorkspaceClassLoader(ClassLoader workspaceClassLoader) {
        this.workspaceClassLoader = workspaceClassLoader;
        return this;
    }

    public String getCacheBoot() {
        return this.getStoreLocation(NutsStoreLocation.CACHE) + File.separator + "id";
    }

    public String getLib() {
        return this.getStoreLocation(NutsStoreLocation.LIB) + File.separator + "id";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("NutsBootConfig{");
        if (!NutsUtilStrings.isBlank((CharSequence)this.apiVersion)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("apiVersion='").append(this.apiVersion).append('\'');
        }
        if (this.runtimeId != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("runtimeId='").append(this.runtimeId).append('\'');
        }
        if (!NutsUtilStrings.isBlank((CharSequence)this.bootRepositories)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("bootRepositories='").append(this.bootRepositories).append('\'');
        }
        if (!NutsUtilStrings.isBlank((CharSequence)this.javaCommand)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("javaCommand='").append(this.javaCommand).append('\'');
        }
        if (!NutsUtilStrings.isBlank((CharSequence)this.javaOptions)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("javaOptions='").append(this.javaOptions).append('\'');
        }
        if (!NutsUtilStrings.isBlank((CharSequence)this.workspace)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("workspace='").append(this.workspace).append('\'');
        }
        if (this.storeLocations != null && !this.storeLocations.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("storeLocations=").append(this.storeLocations);
        }
        if (this.homeLocations != null && !this.homeLocations.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("homeLocations=").append(this.homeLocations);
        }
        if (this.storeLocationStrategy != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("storeLocationStrategy=").append(this.storeLocationStrategy);
        }
        if (this.repositoryStoreLocationStrategy != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("repositoryStoreLocationStrategy=").append(this.repositoryStoreLocationStrategy);
        }
        if (this.storeLocationLayout != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("storeLocationLayout=").append(this.storeLocationLayout);
        }
        if (this.global) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("global");
        }
        sb.append('}');
        return sb.toString();
    }

    public void setSession(NutsSession session) {
        this.session = session;
        ((CoreNutsWorkspaceOptions)this.options).setSession(session);
    }
}

