/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.remote;

import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementFormat;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.runtime.bundles.ntalk.NTalkClient;
import net.thevpc.nuts.runtime.core.AbstractNutsWorkspace;

public abstract class RemoteNutsWorkspace
extends AbstractNutsWorkspace {
    public NutsElement createCall(String commandName, NutsElement body, NutsSession session) {
        Throwable throwable = null;
        try (NTalkClient cli = new NTalkClient();){
            NutsElementFormat e = this.elem().setContentType(NutsContentType.JSON);
            NutsObjectElement q = e.forObject().set("cmd", commandName).set("body", body).build();
            NutsString json = e.setValue((Object)q).format();
            String wsURL = this.env().getBootOptions().getWorkspace();
            byte[] result = cli.request("nuts/ws:" + wsURL, json.toString().getBytes());
            NutsObjectElement resultObject = (NutsObjectElement)e.parse(result, NutsObjectElement.class);
            NutsElementFormat prv = this.elem().setSession(session);
            boolean success = resultObject.get((NutsElement)prv.forString("success")).asPrimitive().getBoolean();
            if (success) {
                NutsElement nutsElement = resultObject.get((NutsElement)prv.forString("body"));
                return nutsElement;
            }
            try {
                throw new NutsException(session, NutsMessage.cstyle((String)"unable to call %s", (Object[])new Object[]{session.getWorkspace().text().forStyled(commandName, NutsTextStyle.primary1())}));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public NutsElement createCall(String commandName, String callId, NutsElement body) {
        NutsElementFormat e = this.elem();
        return e.forObject().set("cmd", (NutsElement)e.forString(commandName)).set("id", (NutsElement)e.forString(callId)).set("body", body).build();
    }

    public <T> T remoteCall(NutsElement call, Class<T> expectedType) {
        throw new NutsUnsupportedOperationException(null, NutsMessage.cstyle((String)"not yet supported remoteCall", (Object[])new Object[0]));
    }
}

