/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.bundles.io.InputStreamVisitor;
import net.thevpc.nuts.runtime.bundles.io.ZipUtils;

public final class CoreServiceUtils {
    private CoreServiceUtils() {
    }

    public static Set<String> loadZipServiceClassNames(URL url, Class service) {
        final LinkedHashSet<String> found = new LinkedHashSet<String>();
        try (InputStream jarStream = url.openStream();){
            if (jarStream != null) {
                ZipUtils.visitZipStream(jarStream, s -> s.equals("META-INF/services/" + service.getName()), new InputStreamVisitor(){

                    @Override
                    public boolean visit(String path, InputStream inputStream) throws IOException {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                            found.add(line);
                        }
                        return false;
                    }
                });
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return found;
    }

    public static List<String> loadServiceClasseNames(URL u, Class<?> service) {
        InputStream in = null;
        BufferedReader r = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            String line;
            in = u.openStream();
            r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            boolean lc = true;
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                names.add(line);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex2) {
                throw new UncheckedIOException(ex2);
            }
        }
        return names;
    }

    public static List<Class> loadServiceClasses(Class service, ClassLoader classLoader, NutsSession ws) {
        Enumeration<URL> configs;
        String fullName = "META-INF/services/" + service.getName();
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        try {
            configs = classLoader == null ? ClassLoader.getSystemResources(fullName) : classLoader.getResources(fullName);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        while (configs.hasMoreElements()) {
            names.addAll(CoreServiceUtils.loadServiceClasseNames(configs.nextElement(), service));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (String n : names) {
            Class<?> c = null;
            try {
                c = Class.forName(n, false, classLoader);
            }
            catch (ClassNotFoundException x) {
                throw new NutsException(ws, NutsMessage.cstyle((String)"unable to load service class %s", (Object[])new Object[]{n}), (Throwable)x);
            }
            if (!service.isAssignableFrom(c)) {
                throw new NutsException(ws, NutsMessage.cstyle((String)"not a valid type %s <> %s", (Object[])new Object[]{c, service}));
            }
            classes.add(c);
        }
        return classes;
    }
}

