/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchModeNotSupportedException;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdLocation;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsRepositoryRef;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.bundles.parsers.StringPlaceHolderParser;
import net.thevpc.nuts.runtime.bundles.parsers.StringTokenizerUtils;
import net.thevpc.nuts.runtime.core.util.CoreBooleanUtils;
import net.thevpc.nuts.runtime.core.util.CoreEnumUtils;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.core.util.Simplifiable;
import net.thevpc.nuts.runtime.standalone.DefaultNutsWorkspace;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class CoreNutsUtils {
    public static final String LOCAL_NUTS_FOLDER = "${home.config}/.vpc-public-nuts";
    public static final int DEFAULT_UUID_LENGTH = 25;
    public static final int DEFAULT_DATE_TIME_FORMATTER_LENGTH = 23;
    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    public static final String[] COLOR_NAMES = new TreeSet<String>(Arrays.asList("Maroon", "Brown", "Olive", "Teal", "Navy", "Black", "Red", "Orange", "Yellow", "Lime", "Green", "Cyan", "Blue", "Purple", "Magenta", "Grey", "Pink", "Apricot", "Beige", "Mint", "Lavender", "White", "Turquoise", "Aqua", "Aquamarine", "Gold", "Coral", "Tomato", "Firebrick", "Crimson", "Salmon", "Moccasin", "PeachPuff", "Khaki", "Cornsilk", "Bisque", "Wheat", "Tan", "Peru", "Chocolate", "Sienna", "Snow", "Azure", "Ivory", "Linen", "Silver", "Gray")).toArray(new String[0]);
    public static final int LOCK_TIME = 3;
    public static final TimeUnit LOCK_TIME_UNIT = TimeUnit.SECONDS;
    public static final NutsDefaultThreadFactory nutsDefaultThreadFactory = new NutsDefaultThreadFactory("nuts-pool", true);
    private static final Map<String, String> _QUERY_EMPTY_ENV = new HashMap<String, String>();
    public static final Map<String, String> QUERY_EMPTY_ENV = Collections.unmodifiableMap(_QUERY_EMPTY_ENV);
    public static Comparator<NutsId> NUTS_ID_COMPARATOR = new Comparator<NutsId>(){

        @Override
        public int compare(NutsId o1, NutsId o2) {
            if (o1 == null || o2 == null) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                return 1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    };
    public static Comparator<NutsDefinition> NUTS_FILE_COMPARATOR = new Comparator<NutsDefinition>(){

        @Override
        public int compare(NutsDefinition o1, NutsDefinition o2) {
            if (o1 == null || o2 == null) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                return 1;
            }
            return NUTS_ID_COMPARATOR.compare(o1.getId(), o2.getId());
        }
    };

    public static String randomColorName() {
        return COLOR_NAMES[(int)(Math.random() * (double)COLOR_NAMES.length)];
    }

    public static String repeat(char txt, int count) {
        StringBuilder sb = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            sb.append(txt);
        }
        return sb.toString();
    }

    public static NutsId findNutsIdBySimpleName(NutsId id, Collection<NutsId> all) {
        if (all != null) {
            for (NutsId nutsId : all) {
                if (nutsId == null || !nutsId.equalsShortName(id)) continue;
                return nutsId;
            }
        }
        return null;
    }

    public static String formatImport(List<String> imports) {
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        StringBuilder sb = new StringBuilder();
        for (String s : imports) {
            if ((s = s.trim()).length() <= 0 || all.contains(s)) continue;
            all.add(s);
            if (sb.length() > 0) {
                sb.append(":");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static boolean isEffectiveValue(String value) {
        return !NutsUtilStrings.isBlank((CharSequence)value) && !CoreStringUtils.containsVars(value);
    }

    public static boolean isEffectiveId(NutsId id) {
        return CoreNutsUtils.isEffectiveValue(id.getGroupId()) && CoreNutsUtils.isEffectiveValue(id.getArtifactId()) && CoreNutsUtils.isEffectiveValue(id.getVersion().getValue());
    }

    public static boolean containsVars(NutsId id) {
        return CoreStringUtils.containsVars(id.getGroupId()) && CoreStringUtils.containsVars(id.getArtifactId()) && CoreStringUtils.containsVars(id.getVersion().getValue());
    }

    public static String[] applyStringProperties(String[] child, Function<String, String> properties) {
        String[] vals = new String[child.length];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = CoreNutsUtils.applyStringProperties(child[i], properties);
        }
        return vals;
    }

    public static Map<String, String> applyMapProperties(Map<String, String> child, Function<String, String> properties) {
        LinkedHashMap<String, String> m2 = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : child.entrySet()) {
            m2.put(CoreNutsUtils.applyStringProperties(entry.getKey(), properties), CoreNutsUtils.applyStringProperties(entry.getValue(), properties));
        }
        return m2;
    }

    public static NutsVersion applyStringProperties(NutsVersion child, Function<String, String> properties, NutsWorkspace ws) {
        if (child == null) {
            return child;
        }
        String s = child.getValue();
        if (NutsUtilStrings.isBlank((CharSequence)s)) {
            return ws.version().parser().parse("");
        }
        String s2 = CoreNutsUtils.applyStringProperties(s, properties);
        if (!NutsUtilStrings.trim((String)s2).equals(s)) {
            return ws.version().parser().parse(s2);
        }
        return child;
    }

    public static String applyStringProperties(String child, Function<String, String> properties) {
        if (NutsUtilStrings.isBlank((CharSequence)child)) {
            return null;
        }
        return StringPlaceHolderParser.replaceDollarPlaceHolders(child, properties);
    }

    public static String applyStringInheritance(String child, String parent) {
        child = NutsUtilStrings.trimToNull((String)child);
        parent = NutsUtilStrings.trimToNull((String)parent);
        if (child == null) {
            return parent;
        }
        return child;
    }

    public static <T> T simplify(T any) {
        if (any == null) {
            return null;
        }
        if (any instanceof Simplifiable) {
            return ((Simplifiable)any).simplify();
        }
        return any;
    }

    public static <T extends NutsFilter> T simplifyFilterOr(NutsWorkspace ws, Class<T> cls, T base, NutsFilter ... all) {
        if (all.length == 0) {
            return (T)ws.filters().always(cls);
        }
        if (all.length == 1) {
            return (T)all[0].simplify();
        }
        ArrayList<NutsFilter> all2 = new ArrayList<NutsFilter>();
        boolean updates = false;
        boolean someFalse = false;
        for (NutsFilter t : all) {
            NutsFilter t2;
            NutsFilter nutsFilter = t2 = t == null ? null : t.simplify();
            if (t2 != null) {
                switch (t2.getFilterOp()) {
                    case TRUE: {
                        return (T)ws.filters().always(cls);
                    }
                    case FALSE: {
                        someFalse = true;
                        break;
                    }
                    default: {
                        if (t2 != t) {
                            updates = true;
                        }
                        all2.add(t2);
                        break;
                    }
                }
                continue;
            }
            updates = true;
        }
        if (all2.isEmpty()) {
            if (someFalse) {
                return (T)ws.filters().never(cls);
            }
            return (T)ws.filters().always(cls);
        }
        if (all2.size() == 1) {
            return (T)((NutsFilter)all2.get(0));
        }
        if (!updates) {
            return base;
        }
        return (T)ws.filters().any(cls, all2.toArray((NutsFilter[])Array.newInstance(cls, 0)));
    }

    public static <T extends NutsFilter> T simplifyFilterAnd(NutsWorkspace ws, Class<T> cls, T base, NutsFilter ... all) {
        if (all.length == 0) {
            return (T)ws.filters().always(cls);
        }
        if (all.length == 1) {
            return (T)all[0].simplify();
        }
        ArrayList<NutsFilter> all2 = new ArrayList<NutsFilter>();
        boolean updates = false;
        for (NutsFilter t : all) {
            NutsFilter t2;
            NutsFilter nutsFilter = t2 = t == null ? null : t.simplify();
            if (t2 != null) {
                switch (t2.getFilterOp()) {
                    case FALSE: {
                        return (T)ws.filters().never(cls);
                    }
                    case TRUE: {
                        updates = true;
                        break;
                    }
                    default: {
                        if (t2 != t) {
                            updates = true;
                        }
                        all2.add(t2);
                        break;
                    }
                }
                continue;
            }
            updates = true;
        }
        if (all2.size() == 0) {
            return (T)ws.filters().always(cls);
        }
        if (all2.size() == 1) {
            return (T)((NutsFilter)all2.get(0));
        }
        if (!updates) {
            return base;
        }
        return (T)ws.filters().all(cls, all2.toArray((NutsFilter[])Array.newInstance(cls, 0)));
    }

    public static <T extends NutsFilter> T simplifyFilterNone(NutsWorkspace ws, Class<T> cls, T base, NutsFilter ... all) {
        if (all.length == 0) {
            return (T)ws.filters().always(cls);
        }
        ArrayList<NutsFilter> all2 = new ArrayList<NutsFilter>();
        boolean updates = false;
        for (NutsFilter t : all) {
            NutsFilter t2;
            NutsFilter nutsFilter = t2 = t == null ? null : t.simplify();
            if (t2 != null) {
                switch (t2.getFilterOp()) {
                    case TRUE: {
                        return (T)ws.filters().never(cls);
                    }
                    case FALSE: {
                        updates = true;
                        break;
                    }
                    default: {
                        if (t2 != t) {
                            updates = true;
                        }
                        all2.add(t2);
                        break;
                    }
                }
                continue;
            }
            updates = true;
        }
        if (all2.size() == 0) {
            return (T)ws.filters().always(cls);
        }
        if (!updates) {
            return base;
        }
        return (T)ws.filters().none(cls, all2.toArray((NutsFilter[])Array.newInstance(cls, 0)));
    }

    public static <T> T[] simplifyAndShrink(Class<T> cls, T ... any) {
        ArrayList<T> all = new ArrayList<T>();
        boolean updates = false;
        for (T t : any) {
            T t2 = CoreNutsUtils.simplify(t);
            if (t2 != null) {
                if (t2 != t) {
                    updates = true;
                }
                all.add(t2);
                continue;
            }
            updates = true;
        }
        if (!updates) {
            return null;
        }
        return all.toArray((Object[])Array.newInstance(cls, 0));
    }

    public static <T extends NutsFilter> T[] simplifyAndShrinkFilters(Class<T> cls, Predicate<T> onRemove, T ... any) {
        ArrayList<NutsFilter> all = new ArrayList<NutsFilter>();
        boolean updates = false;
        for (T t : any) {
            NutsFilter t2;
            NutsFilter nutsFilter = t2 = t == null ? null : t.simplify();
            if (t2 != null) {
                if (onRemove != null && onRemove.test(t2)) {
                    updates = true;
                    continue;
                }
                if (t2 != t) {
                    updates = true;
                }
                all.add(t2);
                continue;
            }
            updates = true;
        }
        if (!updates) {
            return null;
        }
        return all.toArray((NutsFilter[])Array.newInstance(cls, 0));
    }

    public static NutsId applyNutsIdInheritance(NutsId child, NutsId parent, NutsWorkspace ws) {
        if (parent != null) {
            Map parentFaceMap;
            boolean modified = false;
            String repository = child.getRepository();
            String group = child.getGroupId();
            String name = child.getArtifactId();
            String version = child.getVersion().getValue();
            Map props = child.getProperties();
            if (NutsUtilStrings.isBlank((CharSequence)repository)) {
                modified = true;
                repository = parent.getRepository();
            }
            if (NutsUtilStrings.isBlank((CharSequence)group)) {
                modified = true;
                group = parent.getGroupId();
            }
            if (NutsUtilStrings.isBlank((CharSequence)name)) {
                modified = true;
                name = parent.getArtifactId();
            }
            if (NutsUtilStrings.isBlank((CharSequence)version)) {
                modified = true;
                version = parent.getVersion().getValue();
            }
            if (!(parentFaceMap = parent.getProperties()).isEmpty()) {
                modified = true;
                props.putAll(parentFaceMap);
            }
            if (modified) {
                return ws.id().builder().setRepository(repository).setGroupId(group).setArtifactId(name).setVersion(version).setProperties(props).build();
            }
        }
        return child;
    }

    public static boolean isDefaultOptional(String s1) {
        return (s1 = NutsUtilStrings.trim((String)s1)).isEmpty() || s1.equals("false");
    }

    public static boolean isValidIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] c = s.toCharArray();
        if (!Character.isJavaIdentifierStart(c[0])) {
            return false;
        }
        for (int i = 1; i < c.length; ++i) {
            if (Character.isJavaIdentifierPart(c[i]) || c[i] == '-') continue;
            return false;
        }
        return true;
    }

    public static NutsRepositoryRef optionsToRef(NutsAddRepositoryOptions options) {
        return new NutsRepositoryRef().setEnabled(options.isEnabled()).setFailSafe(options.isFailSafe()).setName(options.getName()).setLocation(options.getLocation()).setDeployOrder(options.getDeployOrder());
    }

    public static NutsAddRepositoryOptions refToOptions(NutsRepositoryRef ref) {
        return new NutsAddRepositoryOptions().setEnabled(ref.isEnabled()).setFailSafe(ref.isFailSafe()).setName(ref.getName()).setLocation(ref.getLocation()).setDeployOrder(ref.getDeployOrder()).setTemporary(false);
    }

    public static NutsSession silent(NutsSession session) {
        return session.isTrace() ? session.copy().setTrace(Boolean.valueOf(false)) : session;
    }

    public static Map<String, Object> traceJsonNutsDefinition(NutsSession session, NutsDefinition def) {
        LinkedHashMap<String, Object> x = new LinkedHashMap<String, Object>();
        x.put("id", def.getId());
        if (def.getContent() != null) {
            if (def.getContent().getPath() != null) {
                x.put("path", def.getContent().getPath().toString());
            }
            x.put("cached", def.getContent().isCached());
            x.put("temporary", def.getContent().isTemporary());
        }
        if (def.getInstallInformation() != null) {
            if (def.getInstallInformation().getInstallFolder() != null) {
                x.put("install-folder", def.getInstallInformation().getInstallFolder().toString());
            }
            x.put("install-status", def.getInstallInformation().getInstallStatus().toString());
            x.put("was-installed", def.getInstallInformation().isWasInstalled());
            x.put("was-required", def.getInstallInformation().isWasRequired());
        }
        if (def.getRepositoryName() != null) {
            x.put("repository-name", def.getRepositoryName());
        }
        if (def.getRepositoryUuid() != null) {
            x.put("repository-uuid", def.getRepositoryUuid());
        }
        if (def.getDescriptor() != null) {
            x.put("descriptor", session.getWorkspace().descriptor().formatter().setValue(def.getDescriptor()).format());
            x.put("effective-descriptor", session.getWorkspace().descriptor().formatter(NutsWorkspaceUtils.of(session).getEffectiveDescriptor(def)).format());
        }
        return x;
    }

    public static boolean isIncludesHelpOption(String[] cmd) {
        if (cmd != null) {
            for (String c : cmd) {
                if (!c.startsWith("-")) break;
                if (!"--help".equals(c)) continue;
                return true;
            }
        }
        return false;
    }

    public static void traceMessage(NutsLogger log, Level lvl, String name, NutsSession session, NutsFetchMode fetchMode, NutsId id, NutsLogVerb tracePhase, String title, long startTime, NutsMessage extraMsg) {
        if (!log.isLoggable(lvl)) {
            return;
        }
        if (extraMsg == null) {
            String sep = "";
            extraMsg = NutsMessage.formatted((String)"");
        } else {
            String sep = " : ";
        }
        long time = startTime != 0L ? System.currentTimeMillis() - startTime : 0L;
        String modeString = CoreStringUtils.alignLeft(fetchMode.id(), 7);
        log.with().session(session).level(lvl).verb(tracePhase).time(time).formatted().log("[{0}] {1} {2} {3} {4}", new Object[]{modeString, CoreStringUtils.alignLeft(name, 20), CoreStringUtils.alignLeft(title, 18), id == null ? "" : id, extraMsg});
    }

    public static NutsContentType readOptionOutputFormat(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        switch (a.getStringKey()) {
            case "--output-format": {
                a = cmdLine.nextString(new String[0]);
                return CoreEnumUtils.parseEnumString(a.getStringValue(), NutsContentType.class, false);
            }
            case "--json": {
                a = cmdLine.nextString(new String[0]);
                return NutsContentType.JSON;
            }
            case "--props": {
                a = cmdLine.nextString(new String[0]);
                return NutsContentType.PROPS;
            }
            case "--table": {
                a = cmdLine.nextString(new String[0]);
                return NutsContentType.TABLE;
            }
            case "--tree": {
                a = cmdLine.nextString(new String[0]);
                return NutsContentType.TREE;
            }
            case "--plain": {
                a = cmdLine.nextString(new String[0]);
                return NutsContentType.PLAIN;
            }
        }
        return null;
    }

    public static boolean matchesSimpleNameStaticVersion(NutsId id, NutsId pattern) {
        if (pattern == null) {
            return id == null;
        }
        if (id == null) {
            return false;
        }
        if (pattern.getVersion().isBlank()) {
            return pattern.getShortName().equals(id.getShortName());
        }
        return pattern.getLongName().equals(id.getLongName());
    }

    public static String[] nullArray_Locations(String[] a) {
        return CoreNutsUtils.nullArray(a, NutsStoreLocation.values().length);
    }

    public static String[] nullArray_LocationsAndOses(String[] a) {
        return CoreNutsUtils.nullArray(a, NutsStoreLocation.values().length * NutsOsFamily.values().length);
    }

    public static String[] nullArray(String[] a, int size) {
        if (a == null) {
            return null;
        }
        boolean ok = false;
        for (String string : a) {
            if (string == null) continue;
            ok = true;
            break;
        }
        if (ok) {
            if (a.length == size) {
                return a;
            }
            String[] aa = new String[size];
            System.arraycopy(a, 0, aa, 0, size);
            return aa;
        }
        return null;
    }

    public static String getArrItem(String[] a, int index) {
        return a == null || a.length <= index ? null : a[index];
    }

    public static String[] nonNullArray_Locations(String[] a) {
        return CoreNutsUtils.nonNullArray(a, NutsStoreLocation.values().length);
    }

    public static String[] nonNullArray_LocationsAndOses(String[] a) {
        return CoreNutsUtils.nonNullArray(a, NutsStoreLocation.values().length * NutsOsFamily.values().length);
    }

    public static String[] nonNullArray(String[] a, int size) {
        if (a == null) {
            return new String[size];
        }
        if (a.length == size) {
            return a;
        }
        String[] aa = new String[size];
        System.arraycopy(a, 0, aa, 0, size);
        return aa;
    }

    public static int getApiVersionOrdinalNumber(String s) {
        try {
            int a = 0;
            for (String part : s.split("\\.")) {
                a = a * 100 + Integer.parseInt(part);
            }
            return a;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public static boolean isValidWorkspaceName(String workspace) {
        if (NutsUtilStrings.isBlank((CharSequence)workspace)) {
            return true;
        }
        String workspaceName = workspace.trim();
        return workspaceName.matches("[^/\\\\]+") && !workspaceName.equals(".") && !workspaceName.equals("..");
    }

    public static String resolveValidWorkspaceName(String workspace) {
        if (NutsUtilStrings.isBlank((CharSequence)workspace)) {
            return "default-workspace";
        }
        String workspaceName = workspace.trim();
        if (workspaceName.matches("[^/\\\\]+") && !workspaceName.equals(".") && !workspaceName.equals("..")) {
            return workspaceName;
        }
        String p = null;
        try {
            p = new File(workspaceName).getCanonicalFile().getName();
        }
        catch (IOException ex) {
            p = new File(workspaceName).getAbsoluteFile().getName();
        }
        if (p.isEmpty() || p.equals(".") || p.equals("..")) {
            return "unknown";
        }
        return p;
    }

    public static String idToPath(NutsId id) {
        return id.getGroupId().replace('.', '/') + "/" + id.getArtifactId() + "/" + id.getVersion();
    }

    public static Properties copyOfNonNull(Properties p) {
        if (p == null) {
            return new Properties();
        }
        Properties p2 = new Properties();
        p2.putAll((Map<?, ?>)p);
        return p2;
    }

    public static Properties copyOfOrNull(Properties p) {
        if (p == null) {
            return null;
        }
        Properties p2 = new Properties();
        p2.putAll((Map<?, ?>)p);
        return p2;
    }

    public static boolean acceptClassifier(NutsIdLocation location, String classifier) {
        if (location == null) {
            return false;
        }
        String c0 = NutsUtilStrings.trim((String)classifier);
        String c1 = NutsUtilStrings.trim((String)location.getClassifier());
        return c0.equals(c1);
    }

    public static NutsString formatLogValue(NutsTextManager text, Object unresolved, Object resolved) {
        NutsString b;
        NutsString a = CoreNutsUtils.desc(unresolved, text);
        if (a.equals(b = CoreNutsUtils.desc(resolved, text))) {
            return a;
        }
        return text.builder().append((Object)a).append((Object)" => ").append((Object)b);
    }

    public static NutsString desc(Object s, NutsTextManager text) {
        if (s == null || s instanceof String && ((String)s).isEmpty()) {
            return text.forStyled("<EMPTY>", NutsTextStyle.option());
        }
        return text.toText(s);
    }

    public static boolean isUnsupportedFetchModeException(Throwable ex) {
        Throwable ex2;
        Object msg = null;
        if (ex instanceof NutsFetchModeNotSupportedException) {
            return true;
        }
        return ex instanceof NutsNotFoundException && ex.getCause() != null && (ex2 = ex.getCause()) instanceof NutsFetchModeNotSupportedException;
    }

    public static Set<String> parseProgressOptions(NutsSession session) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String s : StringTokenizerUtils.split(session.getProgressOptions(), ",; ")) {
            Boolean n = NutsUtilStrings.parseBoolean((String)s, null, null);
            if (n == null) {
                set.add(s);
                continue;
            }
            set.add(n.toString());
        }
        return set;
    }

    public static boolean acceptProgress(NutsSession session) {
        if (!session.isPlainOut()) {
            return false;
        }
        return !session.isBot() && !CoreNutsUtils.parseProgressOptions(session).contains("false");
    }

    public static boolean acceptMonitoring(NutsSession session) {
        if (!session.isPlainOut()) {
            return false;
        }
        if (!CoreNutsUtils.acceptProgress(session)) {
            return false;
        }
        Object o = session.getProperty("monitor-allowed");
        NutsWorkspace ws = session.getWorkspace();
        if (o != null) {
            o = ws.commandLine().create(new String[]{String.valueOf(o)}).next().getBoolean();
        }
        boolean monitorable = true;
        if (o instanceof Boolean) {
            monitorable = (Boolean)o;
        }
        if (!CoreBooleanUtils.getSysBoolNutsProperty("monitor.enabled", true)) {
            monitorable = false;
        }
        if (ws instanceof DefaultNutsWorkspace && !((DefaultNutsWorkspace)ws).LOG.isLoggable(Level.INFO)) {
            monitorable = false;
        }
        return monitorable;
    }

    public static Iterator<NutsDependency> itIdToDep(Iterator<NutsId> id) {
        return IteratorBuilder.of(id).convert(x -> x.toDependency(), "IdToDependency").build();
    }

    public static Iterator<NutsDependency> itIdToDep(Iterator<NutsId> id, NutsDependency copyFrom) {
        String _optional = copyFrom.getOptional();
        String _scope = copyFrom.getScope();
        return IteratorBuilder.of(id).convert(x -> x.toDependency().builder().setOptional(_optional).setScope(_scope).build(), "IdToDependency").build();
    }

    static {
        _QUERY_EMPTY_ENV.put("arch", null);
        _QUERY_EMPTY_ENV.put("os", null);
        _QUERY_EMPTY_ENV.put("osdist", null);
        _QUERY_EMPTY_ENV.put("platform", null);
    }

    public static class NutsDefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final boolean daemon;

        NutsDefaultThreadFactory(String namePattern, boolean daemon) {
            this.daemon = daemon;
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = namePattern + "-" + CoreStringUtils.indexToString(poolNumber.getAndIncrement()) + "-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(this.daemon);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

