/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.util;

import java.lang.reflect.Array;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArrayElement;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsElementType;
import net.thevpc.nuts.NutsFormattable;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsPrimitiveElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.util.CoreEnumUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;

public class CoreCommonUtils {
    public static NutsString stringValueFormatted(Object o, boolean escapeString, NutsSession session) {
        ArrayList<Object> all;
        Object[] a;
        Object c;
        NutsWorkspace ws = session.getWorkspace();
        NutsTextManager txt = ws.text();
        if (o == null) {
            return txt.forBlank();
        }
        if (o instanceof NutsFormattable) {
            return txt.toText(o);
        }
        if (o instanceof NutsPrimitiveElement) {
            o = ((NutsPrimitiveElement)o).getValue();
        } else if (o instanceof NutsArrayElement) {
            o = ((NutsArrayElement)o).children();
        } else {
            if (o instanceof NutsObjectElement) {
                Collection c2 = ((NutsObjectElement)o).children();
                Object[] a2 = c2.toArray();
                if (a2.length == 0) {
                    return txt.forBlank();
                }
                if (a2.length == 1) {
                    return txt.forPlain(CoreCommonUtils.stringValue(a2[0]));
                }
                return txt.builder().append((Object)"{").appendJoined((Object)txt.forPlain(", "), (Collection)c2.stream().map(x -> CoreCommonUtils.stringValueFormatted(x, escapeString, session)).collect(Collectors.toList())).append((Object)"}");
            }
            if (o instanceof NutsElementEntry) {
                NutsElementEntry ne = (NutsElementEntry)o;
                NutsTextBuilder sb = ws.text().builder();
                sb.append((Object)CoreCommonUtils.stringValueFormatted(ne.getKey(), escapeString, session));
                sb.append((Object)"=");
                if (ne.getValue().type() == NutsElementType.STRING) {
                    sb.append(txt.toText((Object)CoreStringUtils.dblQuote(CoreCommonUtils.stringValueFormatted(ne.getValue(), escapeString, session).toString())));
                } else {
                    sb.append((Object)CoreCommonUtils.stringValueFormatted(ne.getValue(), escapeString, session));
                }
                o = sb.toString();
            } else {
                if (o instanceof Map.Entry) {
                    Map.Entry ne = (Map.Entry)o;
                    NutsTextBuilder sb = ws.text().builder();
                    sb.append((Object)CoreCommonUtils.stringValueFormatted(ne.getKey(), escapeString, session));
                    sb.append((Object)"=");
                    if (ne.getValue() instanceof String || ne.getValue() instanceof NutsElement && ((NutsElement)ne.getValue()).isString()) {
                        sb.append(txt.toText((Object)CoreStringUtils.dblQuote(CoreCommonUtils.stringValueFormatted(ne.getValue(), escapeString, session).toString())));
                    } else {
                        sb.append((Object)CoreCommonUtils.stringValueFormatted(ne.getValue(), escapeString, session));
                    }
                    return sb.immutable();
                }
                if (o instanceof Map) {
                    o = ((Map)o).entrySet();
                }
            }
        }
        if (o == null) {
            return txt.forBlank();
        }
        if (o instanceof Instant) {
            return txt.forPlain(CoreNutsUtils.DEFAULT_DATE_TIME_FORMATTER.format((Instant)o));
        }
        if (o instanceof Temporal) {
            return txt.forPlain(CoreNutsUtils.DEFAULT_DATE_TIME_FORMATTER.format((Temporal)o));
        }
        if (o instanceof Date) {
            return txt.forPlain(CoreNutsUtils.DEFAULT_DATE_TIME_FORMATTER.format(((Date)o).toInstant()));
        }
        if (o instanceof Collection) {
            c = (Collection)o;
            a = c.toArray();
            if (a.length == 0) {
                return txt.forBlank();
            }
            if (a.length == 1) {
                return txt.forPlain(CoreCommonUtils.stringValue(a[0]));
            }
            List ll = c.stream().map(x -> CoreCommonUtils.stringValueFormatted(x, escapeString, session)).collect(Collectors.toList());
            return txt.builder().append((Object)"[").appendJoined((Object)txt.forPlain(", "), ll).append((Object)"]");
        }
        if (o instanceof Map) {
            c = (Map)o;
            a = c.entrySet().toArray(new Map.Entry[0]);
            if (a.length == 0) {
                return txt.forBlank();
            }
            if (a.length == 1) {
                return txt.forPlain(CoreCommonUtils.stringValue(a[0]));
            }
            List ll = Arrays.stream(a).map(x -> CoreCommonUtils.stringValueFormatted(x, escapeString, session)).collect(Collectors.toList());
            return txt.builder().append((Object)"{").appendJoined((Object)txt.forPlain(", "), ll).append((Object)"}");
        }
        if (o.getClass().isArray()) {
            int len = Array.getLength(o);
            if (len == 0) {
                return txt.forBlank();
            }
            if (len == 1) {
                return CoreCommonUtils.stringValueFormatted(Array.get(o, 0), escapeString, session);
            }
            all = new ArrayList(len);
            for (int i = 0; i < len; ++i) {
                all.add(CoreCommonUtils.stringValueFormatted(Array.get(o, i), escapeString, session));
            }
            return txt.builder().append((Object)"[").appendJoined((Object)txt.forPlain(", "), all).append((Object)"]");
        }
        if (o instanceof Iterator) {
            Iterator x2 = (Iterator)o;
            all = new ArrayList<Object>();
            while (x2.hasNext()) {
                all.add(CoreCommonUtils.stringValueFormatted(x2.next(), escapeString, session).toString());
            }
            return CoreCommonUtils.stringValueFormatted(all, escapeString, session);
        }
        return txt.toText(o);
    }

    public static String stringValue(Object o) {
        if (o == null) {
            return "";
        }
        if (o.getClass().isEnum()) {
            return CoreEnumUtils.getEnumString((Enum)o);
        }
        if (o instanceof Instant) {
            return CoreNutsUtils.DEFAULT_DATE_TIME_FORMATTER.format((Instant)o);
        }
        if (o instanceof Date) {
            return CoreNutsUtils.DEFAULT_DATE_TIME_FORMATTER.format(((Date)o).toInstant());
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            Object[] a = c.toArray();
            if (a.length == 0) {
                return "";
            }
            if (a.length == 1) {
                return CoreCommonUtils.stringValue(a[0]);
            }
            return "[" + String.join((CharSequence)", ", c.stream().map(x -> CoreCommonUtils.stringValue(x)).collect(Collectors.toList())) + "]";
        }
        if (o.getClass().isArray()) {
            int len = Array.getLength(o);
            if (len == 0) {
                return "";
            }
            if (len == 1) {
                return CoreCommonUtils.stringValue(Array.get(o, 0));
            }
            ArrayList<String> all = new ArrayList<String>(len);
            for (int i = 0; i < len; ++i) {
                all.add(CoreCommonUtils.stringValue(Array.get(o, i)).toString());
            }
            return "[" + String.join((CharSequence)", ", all) + "]";
        }
        return o.toString();
    }
}

