/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.util;

import java.util.function.Supplier;

public class CachedValue<T> {
    private final Supplier<T> supplier;
    private T lastValue;
    private long lastDate;
    private long timeoutSeconds;
    private boolean updating = false;

    public CachedValue(Supplier<T> callable, long timeoutSeconds) {
        this.supplier = callable;
        this.timeoutSeconds = timeoutSeconds;
    }

    public long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public boolean isValid() {
        return !this.isInvalid();
    }

    public boolean isInvalid() {
        long x;
        if (this.lastDate == 0L) {
            return true;
        }
        if (this.timeoutSeconds < 0L) {
            this.timeoutSeconds = 10L;
        }
        return (x = (System.currentTimeMillis() - this.lastDate) / 1000L) < 0L || x > this.timeoutSeconds;
    }

    public void updateAsync() {
        if (!this.updating) {
            new Thread(){

                @Override
                public void run() {
                    CachedValue.this.update();
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T update() {
        this.updating = true;
        try {
            long now = System.currentTimeMillis();
            try {
                this.lastValue = this.supplier.get();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            this.lastDate = now;
        }
        finally {
            this.updating = false;
        }
        return this.lastValue;
    }

    public boolean tryUpdate() {
        if (this.isInvalid()) {
            this.update();
            return true;
        }
        return false;
    }

    public T getValue() {
        this.tryUpdate();
        return this.lastValue;
    }

    public T getLastValue() {
        return this.lastValue;
    }

    public long getLastDate() {
        return this.lastDate;
    }
}

