/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.terminals;

import java.io.InputStream;
import net.thevpc.nuts.NutsCommandAutoCompleteResolver;
import net.thevpc.nuts.NutsCommandHistory;
import net.thevpc.nuts.NutsCommandReadHighlighter;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsSystemTerminal;
import net.thevpc.nuts.NutsTerminalSpec;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.terminals.AbstractNutsTerminal;
import net.thevpc.nuts.runtime.core.terminals.CoreTerminalUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.io.progress.CProgressBar;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;

public abstract class AbstractSystemTerminalAdapter
extends AbstractNutsTerminal
implements NutsSystemTerminal {
    protected CProgressBar progressBar;
    private NutsWorkspace ws;

    public NutsCommandAutoCompleteResolver getAutoCompleteResolver() {
        NutsSystemTerminalBase p = this.getParent();
        if (p != null) {
            return p.getAutoCompleteResolver();
        }
        return null;
    }

    public boolean isAutoCompleteSupported() {
        return this.getParent().isAutoCompleteSupported();
    }

    public NutsSystemTerminalBase setCommandAutoCompleteResolver(NutsCommandAutoCompleteResolver autoCompleteResolver) {
        NutsSystemTerminalBase p = this.getParent();
        if (p != null) {
            p.setCommandAutoCompleteResolver(autoCompleteResolver);
        }
        return this;
    }

    public NutsSystemTerminalBase setCommandHistory(NutsCommandHistory history) {
        this.getParent().setCommandHistory(history);
        return this;
    }

    public NutsCommandHistory getCommandHistory() {
        return this.getParent().getCommandHistory();
    }

    public NutsCommandReadHighlighter getCommandReadHighlighter() {
        return this.getParent().getCommandReadHighlighter();
    }

    public NutsSystemTerminalBase setCommandReadHighlighter(NutsCommandReadHighlighter commandReadHighlighter) {
        this.getParent().setCommandReadHighlighter(commandReadHighlighter);
        return this;
    }

    public String readLine(NutsMessage message, NutsSession session) {
        NutsSystemTerminalBase p = this.getParent();
        if (p instanceof NutsSystemTerminal) {
            return ((NutsSystemTerminal)p).readLine(message, session);
        }
        return this.getParent().readLine(this.out(), message, session);
    }

    public char[] readPassword(NutsMessage message, NutsSession session) {
        NutsSystemTerminalBase p = this.getParent();
        if (p instanceof NutsSystemTerminal) {
            return ((NutsSystemTerminal)p).readPassword(message, session);
        }
        return p.readPassword(this.out(), message, session);
    }

    public InputStream in() {
        return this.getIn();
    }

    public NutsPrintStream out() {
        return this.getOut();
    }

    public NutsPrintStream err() {
        return this.getErr();
    }

    public NutsSystemTerminal printProgress(float progress, NutsMessage message, NutsSession session) {
        if (CoreNutsUtils.acceptProgress(session)) {
            if (this.getParent() instanceof NutsSystemTerminal) {
                ((NutsSystemTerminal)this.getParent()).printProgress(progress, message, session);
            } else {
                this.getProgressBar(session).printProgress(Float.isNaN(progress) ? -1 : (int)(progress * 100.0f), session.getWorkspace().text().toText((Object)message).toString(), this.err());
            }
        }
        return this;
    }

    private CProgressBar getProgressBar(NutsSession session) {
        if (this.progressBar == null) {
            this.progressBar = CoreTerminalUtils.createProgressBar(session);
        }
        return this.progressBar;
    }

    public int getSupportLevel(NutsSupportLevelContext<NutsTerminalSpec> criteria) {
        return 10;
    }

    public String readLine(NutsPrintStream out, NutsMessage message, NutsSession session) {
        return this.getParent().readLine(out, message, session);
    }

    public char[] readPassword(NutsPrintStream out, NutsMessage message, NutsSession session) {
        return this.getParent().readPassword(out, message, session);
    }

    public InputStream getIn() {
        return this.getParent().getIn();
    }

    public NutsPrintStream getOut() {
        return this.getParent().getOut();
    }

    public NutsPrintStream getErr() {
        return this.getParent().getErr();
    }

    public abstract NutsSystemTerminalBase getParent();
}

