/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.repos;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryType;

public class NutsRepositoryURL {
    protected static final Pattern NAME_PATTERN = Pattern.compile("(?<n>[A-Za-z-])=(?<r>.*)");
    protected static final Pattern UTC_PATTERN = Pattern.compile("([A-Z]:.*)|(\\.*)|(/.*)");
    protected static final Pattern URL_PATTERN = Pattern.compile("(?<p>[a-z-]+):(?<r>.*)");
    private final String name;
    private final String protocol;
    private final NutsRepositoryType repositoryType;
    private final Set<String> pathProtocols = new TreeSet<String>();
    private final String location;

    private NutsRepositoryURL(String name, String protocol, NutsRepositoryType repositoryType, Set<String> pathProtocols, String location) {
        this.name = name;
        this.protocol = protocol;
        this.repositoryType = repositoryType;
        this.pathProtocols.addAll(pathProtocols);
        this.location = location;
    }

    public NutsRepositoryURL(String url) {
        String p;
        Matcher nm;
        if (url == null) {
            url = "";
        }
        if ((nm = NAME_PATTERN.matcher(url)).find()) {
            this.name = nm.group("n");
            url = nm.group("r");
        } else {
            this.name = "";
        }
        if (UTC_PATTERN.matcher(url).matches()) {
            this.repositoryType = new NutsRepositoryType(new String[0]);
            this.location = url;
        } else {
            Matcher matcher = URL_PATTERN.matcher(url);
            LinkedHashSet<String> repoProtocols = new LinkedHashSet<String>();
            if (matcher.find()) {
                String protocol = matcher.group("p");
                String rest = matcher.group("r");
                String[] stringArray = protocol.split("[+]");
                int n = stringArray.length;
                block10: for (int i = 0; i < n; ++i) {
                    String s;
                    switch (s = stringArray[i]) {
                        case "https": 
                        case "http": 
                        case "ftp": 
                        case "file": 
                        case "ssh": {
                            this.pathProtocols.add(s);
                            continue block10;
                        }
                        default: {
                            repoProtocols.add(s);
                        }
                    }
                }
                this.repositoryType = new NutsRepositoryType(repoProtocols.toArray(new String[0]));
                this.location = String.join((CharSequence)"+", this.pathProtocols) + ":" + rest;
            } else {
                this.repositoryType = new NutsRepositoryType(new String[0]);
                this.location = url;
            }
        }
        String string = p = this.repositoryType.isEmpty() ? "" : this.repositoryType.toString();
        if (!this.repositoryType.isEmpty() && this.pathProtocols.size() > 0) {
            p = p + "+";
        }
        this.protocol = p + String.join((CharSequence)"+", this.pathProtocols);
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isHttp() {
        return this.pathProtocols.contains("http") || this.pathProtocols.contains("https");
    }

    public String getProtocol() {
        return this.protocol;
    }

    public NutsRepositoryType getRepositoryType() {
        return this.repositoryType;
    }

    public String getPathProtocol() {
        return String.join((CharSequence)"+", this.pathProtocols);
    }

    public Set<String> getPathProtocols() {
        return Collections.unmodifiableSet(this.pathProtocols);
    }

    public Set<String> getProtocols() {
        LinkedHashSet<String> s = new LinkedHashSet<String>(this.repositoryType.getProtocols());
        s.addAll(this.pathProtocols);
        return Collections.unmodifiableSet(s);
    }

    public String getURLString() {
        if (this.repositoryType.isEmpty()) {
            return this.location;
        }
        if (this.pathProtocols.size() > 0) {
            return this.repositoryType + "+" + this.location;
        }
        return this.repositoryType + ":" + this.location;
    }

    public String toString() {
        return this.name.isEmpty() ? this.getURLString() : this.getName() + "=" + this.getURLString();
    }

    public NutsRepositoryURL changeName(String s) {
        return new NutsRepositoryURL(s == null ? "" : s, this.protocol, this.repositoryType, this.pathProtocols, this.location);
    }
}

