/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.repos;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class NutsRepositoryType {
    private Set<String> repoProtocols = new LinkedHashSet<String>();

    public NutsRepositoryType(String ... types) {
        if (types != null) {
            for (String t : types) {
                if (t == null) continue;
                for (String i : t.split("[+]")) {
                    if ((i = i.trim()).length() <= 0) continue;
                    this.repoProtocols.add(i);
                }
            }
        }
    }

    public boolean contains(String desc) {
        return this.repoProtocols.contains(desc);
    }

    public boolean isEmpty() {
        return this.repoProtocols.isEmpty();
    }

    public Set<String> getProtocols() {
        return Collections.unmodifiableSet(this.repoProtocols);
    }

    public boolean isNuts() {
        return this.repoProtocols.contains("nuts");
    }

    public boolean isMaven() {
        return this.repoProtocols.contains("maven");
    }

    public String toString() {
        return String.join((CharSequence)"+", this.repoProtocols);
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + Objects.hashCode(this.repoProtocols);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsRepositoryType other = (NutsRepositoryType)obj;
        return Objects.equals(this.repoProtocols, other.repoProtocols);
    }
}

