/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.repos;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsRepositoryConfig;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryURL;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;

public class NutsRepositorySelector {
    private static final Map<String, String> defaultRepositoriesByName = new LinkedHashMap<String, String>();
    private Op op = Op.INCLUDE;
    private String name;
    private String url;

    public static String getRepositoryNameByURL(String url) {
        NutsRepositoryURL nru = new NutsRepositoryURL(url);
        for (Map.Entry<String, String> entry : defaultRepositoriesByName.entrySet()) {
            String v = entry.getValue();
            if (!v.equals(nru.getURLString()) && !v.equals(nru.getLocation())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String getRepositoryURLByName(String name) {
        return defaultRepositoriesByName.get(name);
    }

    public static SelectorList parse(String[] textes) {
        if (textes == null) {
            return new SelectorList();
        }
        SelectorList all = new SelectorList();
        for (String t : textes) {
            all = all.join(NutsRepositorySelector.parseList(t));
        }
        return all;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.op == Op.EXACT) {
            sb.append(":=");
        } else if (this.op == Op.EXCLUDE) {
            sb.append(":-");
        } else if (this.op == Op.INCLUDE) {
            sb.append(":+");
        }
        if (this.name != null && this.name.length() > 0) {
            sb.append(this.name);
        }
        if (this.url != null && this.url.length() > 0) {
            sb.append("(");
            sb.append(this.url);
            sb.append(")");
        }
        return sb.toString();
    }

    public static Selection parseSelection(String s) {
        String name = null;
        String url = null;
        if (s == null) {
            throw new IllegalArgumentException("invalid null selection");
        }
        if ((s = s.trim()).startsWith("-") || s.startsWith("+") || s.startsWith("=") || s.indexOf(",") >= 0 || s.indexOf(";") >= 0) {
            throw new IllegalArgumentException("invalid selection syntax");
        }
        Matcher matcher = Pattern.compile("(?<name>[a-zA-Z-_]+)=(?<value>.+)").matcher(s);
        if (matcher.find()) {
            name = matcher.group("name");
            url = matcher.group("value");
        } else if (s.matches("[a-zA-Z-_]+")) {
            name = s;
            String u = NutsRepositorySelector.getRepositoryURLByName(name);
            url = u == null ? name : u;
        } else {
            url = s;
            String n = NutsRepositorySelector.getRepositoryNameByURL(url);
            name = n == null ? url : n;
        }
        if (url.length() > 0) {
            return new Selection(name, url);
        }
        return null;
    }

    public static SelectorList parseList(String text) {
        if (text == null) {
            return new SelectorList();
        }
        Op op = Op.INCLUDE;
        ArrayList<NutsRepositorySelector> all = new ArrayList<NutsRepositorySelector>();
        for (String s : text.split("[,;]")) {
            if ((s = s.trim()).length() <= 0) continue;
            if (s.startsWith("+")) {
                op = Op.INCLUDE;
                s = s.substring(1);
            } else if (s.startsWith("-")) {
                op = Op.EXCLUDE;
                s = s.substring(1);
            } else if (s.startsWith("=")) {
                op = Op.EXACT;
                s = s.substring(1);
            }
            Selection z = NutsRepositorySelector.parseSelection(s);
            if (z == null) continue;
            all.add(new NutsRepositorySelector(op, z.getName(), z.getUrl()));
        }
        return new SelectorList(all.toArray(new NutsRepositorySelector[0]));
    }

    public NutsRepositorySelector(Op op, String name, String url) {
        this.op = op;
        this.name = name;
        this.url = url;
    }

    public Op getOp() {
        return this.op;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean matches(String otherName, String otherURL) {
        otherName = otherName == null ? "" : otherName.trim();
        otherURL = otherURL == null ? "" : otherURL.trim();
        String _name = this.name == null ? "" : this.name.trim();
        String _url = this.url == null ? "" : this.url.trim();
        String string = otherURL = otherURL == null ? otherURL : otherURL.trim();
        if (_name.length() > 0 && _name.equals(otherName)) {
            return true;
        }
        return _url.length() > 0 && _url.equals(otherURL);
    }

    public static NutsAddRepositoryOptions createRepositoryOptions(String s, boolean requireName, NutsSession session) {
        SelectorList r = NutsRepositorySelector.parseList(s);
        Selection[] all = r.resolveSelectors(null);
        if (all.length != 1) {
            throw new IllegalArgumentException("unexpected");
        }
        return NutsRepositorySelector.createRepositoryOptions(all[0], requireName, session);
    }

    public static NutsAddRepositoryOptions createRepositoryOptions(Selection s, boolean requireName, NutsSession session) {
        NutsAddRepositoryOptions u;
        NutsRepositoryURL nru = new NutsRepositoryURL(s.getUrl()).changeName(s.getName());
        String defaultName = null;
        if (defaultRepositoriesByName.containsKey(nru.getName())) {
            defaultName = nru.getName();
        } else {
            String nn = NutsRepositorySelector.getRepositoryNameByURL(nru.getLocation());
            if (nn != null) {
                defaultName = nn;
            }
        }
        if (defaultName != null && (u = NutsRepositorySelector.createDefaultRepositoryOptions(defaultName, session)) != null && (nru.getLocation().isEmpty() || nru.getLocation().equals(u.getConfig().getLocation()) || nru.getURLString().equals(u.getConfig().getLocation()))) {
            if (!u.getName().equals(s.getName())) {
                u.setName(s.getName());
            }
            return u;
        }
        return NutsRepositorySelector.createCustomRepositoryOptions(nru.getName(), nru.getURLString(), requireName, session);
    }

    public static NutsAddRepositoryOptions createCustomRepositoryOptions(String name, String url, boolean requireName, NutsSession session) {
        if ((name == null || name.isEmpty()) && requireName) {
            throw new IllegalArgumentException("missing repository name (<name>=<url>) for " + name);
        }
        if (name == null || name.isEmpty()) {
            name = url;
            if (name.startsWith("http://")) {
                name = name.substring("http://".length());
            } else if (name.startsWith("https://")) {
                name = name.substring("https://".length());
            }
            name = name.replaceAll("[/\\:?.]", "-");
            while (name.endsWith("-")) {
                name = name.substring(0, name.length() - 1);
            }
            while (name.startsWith("-")) {
                name = name.substring(1);
            }
        }
        if (name.isEmpty() || url.isEmpty()) {
            throw new IllegalArgumentException("missing repository name (<name>=<url>) for " + name);
        }
        return new NutsAddRepositoryOptions().setName(name).setFailSafe(false).setCreate(true).setOrder(CoreIOUtils.isPathFile(url) ? 1000 : 10000).setConfig(new NutsRepositoryConfig().setLocation(url));
    }

    public static NutsAddRepositoryOptions createDefaultRepositoryOptions(String nameOrURL, NutsSession session) {
        switch (nameOrURL) {
            case "local": {
                return new NutsAddRepositoryOptions().setName("local").setDeployOrder(10).setFailSafe(false).setCreate(true).setConfig(new NutsRepositoryConfig().setLocation("local").setType("nuts"));
            }
            case "system": {
                return new NutsAddRepositoryOptions().setDeployOrder(100).setName("system").setFailSafe(true).setCreate(true).setOrder(2000).setConfig(new NutsRepositoryConfig().setLocation(CoreIOUtils.getNativePath(Nuts.getPlatformHomeFolder(null, (NutsStoreLocation)NutsStoreLocation.CONFIG, null, (boolean)true, (String)"default-workspace") + "/" + "repos" + "/" + "local")).setType("nuts"));
            }
            case ".m2": 
            case "m2": 
            case "maven-local": {
                return new NutsAddRepositoryOptions().setName("maven-local").setFailSafe(false).setCreate(true).setOrder(1000).setConfig(new NutsRepositoryConfig().setLocation(System.getProperty("user.home") + CoreIOUtils.syspath("/.m2/repository")).setType("maven"));
            }
            case "maven": 
            case "central": 
            case "maven-central": {
                return new NutsAddRepositoryOptions().setName("maven-central").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation("https://repo.maven.apache.org/maven2").setType("maven+dirlist"));
            }
            case "jcenter": {
                return new NutsAddRepositoryOptions().setName("jcenter").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation("https://jcenter.bintray.com").setType("maven+dirlist"));
            }
            case "jboss": {
                return new NutsAddRepositoryOptions().setName("jboss").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation("https://repository.jboss.org/nexus/content/repositories/releases").setType("maven+dirlist"));
            }
            case "clojars": {
                return new NutsAddRepositoryOptions().setName("clojars").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation("https://repo.clojars.org").setType("maven+dirlist"));
            }
            case "atlassian": {
                return new NutsAddRepositoryOptions().setName("atlassian").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation("https://packages.atlassian.com/maven/public").setType("maven+dirlist"));
            }
            case "atlassian-snapshot": {
                return new NutsAddRepositoryOptions().setName("atlassian-atlassian").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation("https://packages.atlassian.com/maven/public-snapshot").setType("maven+dirlist"));
            }
            case "oracle": {
                return new NutsAddRepositoryOptions().setName("oracle").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation("https://maven.oracle.com").setType("maven+dirlist"));
            }
            case "google": {
                return new NutsAddRepositoryOptions().setName("google").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation("maven+dirlist+https://maven.google.com").setType("maven+dirlist"));
            }
            case "spring": 
            case "spring-framework": {
                return new NutsAddRepositoryOptions().setName("spring").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation("https://repo.spring.io/release").setType("maven+dirlist"));
            }
            case "maven-thevpc-git": 
            case "vpc-public-maven": {
                return new NutsAddRepositoryOptions().setName("vpc-public-maven").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation("https://raw.githubusercontent.com/thevpc/vpc-public-maven/master").setType("maven+dirtext"));
            }
            case "nuts-thevpc-git": 
            case "vpc-public-nuts": {
                return new NutsAddRepositoryOptions().setName("vpc-public-nuts").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation("https://raw.githubusercontent.com/thevpc/vpc-public-nuts/master").setType("nuts+dirtext"));
            }
            case "dev": 
            case "thevpc": {
                return new NutsAddRepositoryOptions().setName("thevpc").setFailSafe(false).setCreate(true).setOrder(10000).setConfig(new NutsRepositoryConfig().setLocation("http://thevpc.net/maven").setType("maven+dirlist"));
            }
        }
        return null;
    }

    private static String[] extractKeyEqValue(String s) {
        Matcher matcher = Pattern.compile("(?<name>[a-zA-Z-_]+)=(?<value>.+)").matcher(s);
        if (matcher.find()) {
            return new String[]{matcher.group("name"), matcher.group("value")};
        }
        return null;
    }

    static {
        defaultRepositoriesByName.put("system", CoreIOUtils.getNativePath(Nuts.getPlatformHomeFolder(null, (NutsStoreLocation)NutsStoreLocation.CONFIG, null, (boolean)true, (String)"default-workspace") + "/" + "repos" + "/" + "local"));
        defaultRepositoriesByName.put("maven-local", System.getProperty("user.home") + CoreIOUtils.syspath("/.m2/repository"));
        defaultRepositoriesByName.put(".m2", defaultRepositoriesByName.get("maven-local"));
        defaultRepositoriesByName.put("m2", defaultRepositoriesByName.get("maven-local"));
        defaultRepositoriesByName.put("maven-central", "https://repo.maven.apache.org/maven2");
        defaultRepositoriesByName.put("m2", defaultRepositoriesByName.get("maven-central"));
        defaultRepositoriesByName.put("central", defaultRepositoriesByName.get("maven-central"));
        defaultRepositoriesByName.put("jcenter", "https://jcenter.bintray.com");
        defaultRepositoriesByName.put("jboss", "https://repository.jboss.org/nexus/content/repositories/releases");
        defaultRepositoriesByName.put("clojars", "https://repo.clojars.org");
        defaultRepositoriesByName.put("atlassian", "https://packages.atlassian.com/maven/public");
        defaultRepositoriesByName.put("atlassian-snapshot", "https://packages.atlassian.com/maven/public-snapshot");
        defaultRepositoriesByName.put("oracle", "https://maven.oracle.com");
        defaultRepositoriesByName.put("google", "https://maven.google.com");
        defaultRepositoriesByName.put("spring", "https://repo.spring.io/release");
        defaultRepositoriesByName.put("spring-framework", defaultRepositoriesByName.get("spring"));
        defaultRepositoriesByName.put("maven-thevpc-git", "https://raw.githubusercontent.com/thevpc/vpc-public-maven/master");
        defaultRepositoriesByName.put("vpc-public-maven", defaultRepositoriesByName.get("maven-thevpc-git"));
        defaultRepositoriesByName.put("nuts-thevpc-git", "https://raw.githubusercontent.com/thevpc/vpc-public-nuts/master");
        defaultRepositoriesByName.put("vpc-public-nuts", defaultRepositoriesByName.get("nuts-thevpc-git"));
        defaultRepositoriesByName.put("thevpc", "http://thevpc.net/maven");
        defaultRepositoriesByName.put("dev", defaultRepositoriesByName.get("thevpc"));
        defaultRepositoriesByName.put("local", "local");
    }

    public static class SelectorList {
        private List<NutsRepositorySelector> all = new ArrayList<NutsRepositorySelector>();

        public SelectorList() {
        }

        public SelectorList(NutsRepositorySelector[] a) {
            for (NutsRepositorySelector repoDefString : a) {
                if (repoDefString == null) continue;
                this.all.add(repoDefString);
            }
        }

        public SelectorList join(SelectorList other) {
            if (other == null || other.all.isEmpty()) {
                return this;
            }
            ArrayList<NutsRepositorySelector> all2 = new ArrayList<NutsRepositorySelector>();
            all2.addAll(this.all);
            all2.addAll(other.all);
            return new SelectorList(all2.toArray(new NutsRepositorySelector[0]));
        }

        /*
         * WARNING - void declaration
         */
        public Selection[] resolveSelectors(Map<String, String> existing) {
            HashMap<void, String> existing2 = new HashMap<void, String>();
            if (existing != null) {
                for (Map.Entry<String, String> entry : existing.entrySet()) {
                    void var5_5;
                    String u2;
                    String string = entry.getKey();
                    String v = entry.getValue();
                    if (NutsUtilStrings.isBlank((CharSequence)v) && !NutsUtilStrings.isBlank((CharSequence)string)) {
                        u2 = NutsRepositorySelector.getRepositoryURLByName(string);
                        v = u2 != null ? u2 : string;
                    } else if (!NutsUtilStrings.isBlank((CharSequence)v) && NutsUtilStrings.isBlank((CharSequence)string) && (u2 = NutsRepositorySelector.getRepositoryNameByURL(string)) != null) {
                        String string2 = u2;
                    }
                    existing2.put(var5_5, v);
                }
            }
            ArrayList<Selection> all2 = new ArrayList<Selection>();
            for (NutsRepositorySelector nutsRepositorySelector : this.all) {
                if (nutsRepositorySelector.op == Op.EXCLUDE) continue;
                if (nutsRepositorySelector.name != null) {
                    String ss;
                    String u2 = nutsRepositorySelector.getUrl();
                    if (existing2.containsKey(nutsRepositorySelector.name) && (ss = (String)existing2.remove(nutsRepositorySelector.name)) != null && u2 == null) {
                        u2 = ss;
                    }
                    all2.add(new Selection(nutsRepositorySelector.name, u2));
                    continue;
                }
                if (nutsRepositorySelector.op != Op.EXACT) continue;
                all2.add(new Selection(nutsRepositorySelector.name, nutsRepositorySelector.getUrl()));
            }
            for (Map.Entry entry : existing2.entrySet()) {
                if (!this.acceptExisting((String)entry.getKey(), (String)entry.getValue())) continue;
                all2.add(new Selection((String)entry.getKey(), (String)entry.getValue()));
            }
            return all2.toArray(new Selection[0]);
        }

        public boolean acceptExisting(String n, String url) {
            boolean includeOthers = true;
            for (NutsRepositorySelector s : this.all) {
                if (s.matches(n, url)) {
                    switch (s.op) {
                        case EXACT: {
                            return true;
                        }
                        case INCLUDE: {
                            return true;
                        }
                        case EXCLUDE: {
                            return false;
                        }
                    }
                }
                if (s.op != Op.EXACT) continue;
                includeOthers = false;
            }
            return includeOthers;
        }
    }

    public static class Selection {
        private String name;
        private String url;

        public Selection(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public String toString() {
            if (this.name == null) {
                return this.url;
            }
            if (this.url == null) {
                return this.name;
            }
            if (this.name.equals(this.url)) {
                return this.url;
            }
            return this.name + "=" + this.url;
        }
    }

    public static enum Op {
        INCLUDE,
        EXCLUDE,
        EXACT;

    }
}

