/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.repos;

import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInvalidRepositoryException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfig;
import net.thevpc.nuts.NutsRepositoryFilterManager;
import net.thevpc.nuts.NutsRepositoryModel;
import net.thevpc.nuts.NutsRepositoryNotFoundException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceConfigManager;
import net.thevpc.nuts.NutsWorkspaceEnvManager;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.config.NutsRepositoryConfigManagerExt;
import net.thevpc.nuts.runtime.core.config.NutsWorkspaceConfigManagerExt;
import net.thevpc.nuts.runtime.core.events.DefaultNutsWorkspaceEvent;
import net.thevpc.nuts.runtime.core.repos.NutsRepositorySelector;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.repos.NutsRepositoryRegistryHelper;
import net.thevpc.nuts.runtime.standalone.repos.NutsSimpleRepositoryWrapper;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsRepositoryFactoryComponent;
import net.thevpc.nuts.spi.NutsRepositorySPI;

public class DefaultNutsRepositoryModel {
    private final NutsRepositoryRegistryHelper repositoryRegistryHelper;
    public NutsLogger LOG;
    private NutsWorkspace workspace;

    public DefaultNutsRepositoryModel(NutsWorkspace workspace) {
        this.workspace = workspace;
        this.repositoryRegistryHelper = new NutsRepositoryRegistryHelper(workspace);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = this.workspace.log().setSession(session).of(DefaultNutsRepositoryModel.class);
        }
        return this.LOG;
    }

    public NutsRepositoryFilterManager filter() {
        return this.getWorkspace().filters().repository();
    }

    public NutsRepository[] getRepositories(NutsSession session) {
        return this.repositoryRegistryHelper.getRepositories();
    }

    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }

    public NutsRepository findRepositoryById(String repositoryNameOrId, NutsSession session) {
        NutsRepository y = this.repositoryRegistryHelper.findRepositoryById(repositoryNameOrId);
        if (y != null) {
            return y;
        }
        if (session.isTransitive()) {
            for (NutsRepository child : this.repositoryRegistryHelper.getRepositories()) {
                NutsRepository m = child.config().setSession(session.copy().setTransitive(Boolean.valueOf(true))).findMirrorById(repositoryNameOrId);
                if (m == null) continue;
                if (y == null) {
                    y = m;
                    continue;
                }
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"ambiguous repository name %s found two Ids %s and %s", (Object[])new Object[]{repositoryNameOrId, y.getUuid(), m.getUuid()}));
            }
        }
        return y;
    }

    public NutsRepository findRepositoryByName(String repositoryNameOrId, NutsSession session) {
        NutsRepository y = this.repositoryRegistryHelper.findRepositoryByName(repositoryNameOrId);
        if (y != null) {
            return y;
        }
        if (session.isTransitive()) {
            for (NutsRepository child : this.repositoryRegistryHelper.getRepositories()) {
                NutsRepository m = child.config().setSession(session.copy().setTransitive(Boolean.valueOf(true))).findMirrorByName(repositoryNameOrId);
                if (m == null) continue;
                if (y == null) {
                    y = m;
                    continue;
                }
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"ambiguous repository name %s found two Ids %s and %s", (Object[])new Object[]{repositoryNameOrId, y.getUuid(), m.getUuid()}));
            }
        }
        return y;
    }

    public NutsRepository findRepository(String repositoryNameOrId, NutsSession session) {
        NutsRepository y = this.repositoryRegistryHelper.findRepository(repositoryNameOrId);
        if (y != null) {
            return y;
        }
        if (session.isTransitive()) {
            for (NutsRepository child : this.repositoryRegistryHelper.getRepositories()) {
                NutsRepository m = child.config().setSession(session.copy().setTransitive(Boolean.valueOf(true))).findMirror(repositoryNameOrId);
                if (m == null) continue;
                if (y == null) {
                    y = m;
                    continue;
                }
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"ambiguous repository name %s found two Ids %s and %s", (Object[])new Object[]{repositoryNameOrId, y.getUuid(), m.getUuid()}));
            }
        }
        return y;
    }

    public NutsRepository getRepository(String repositoryIdOrName, NutsSession session) throws NutsRepositoryNotFoundException {
        NutsWorkspaceUtils.checkSession(this.getWorkspace(), session);
        if ("<main>".equals(repositoryIdOrName)) {
            return NutsWorkspaceExt.of(this.getWorkspace()).getInstalledRepository();
        }
        NutsRepository r = this.findRepository(repositoryIdOrName, session);
        if (r != null) {
            return r;
        }
        throw new NutsRepositoryNotFoundException(session, repositoryIdOrName);
    }

    public void removeRepository(String repositoryId, NutsSession session) {
        this.getWorkspace().security().setSession(session).checkAllowed("remove-repo", "remove-repository");
        NutsRepository repository = this.repositoryRegistryHelper.removeRepository(repositoryId);
        if (repository != null) {
            NutsWorkspaceConfigManagerExt config = NutsWorkspaceConfigManagerExt.of(this.getWorkspace().config());
            config.getModel().fireConfigurationChanged("config-main", session, ConfigEventType.MAIN);
            NutsWorkspaceUtils.of(session).events().fireOnRemoveRepository(new DefaultNutsWorkspaceEvent(session, repository, "repository", repository, null));
        }
    }

    public void removeAllRepositories(NutsSession session) {
        for (NutsRepository repository : this.repositoryRegistryHelper.getRepositories()) {
            this.removeRepository(repository.getUuid(), session);
        }
    }

    protected void addRepository(NutsRepository repo, NutsSession session, boolean temp) {
        this.repositoryRegistryHelper.addRepository(repo, session);
        if (!temp) {
            NutsWorkspaceConfigManagerExt config = NutsWorkspaceConfigManagerExt.of(this.getWorkspace().config());
            config.getModel().fireConfigurationChanged("config-main", session, ConfigEventType.MAIN);
            if (repo != null) {
                NutsWorkspaceUtils.of(session).events().fireOnAddRepository(new DefaultNutsWorkspaceEvent(session, repo, "repository", null, repo));
            }
        }
    }

    public NutsRepository addRepository(NutsAddRepositoryOptions options, NutsSession session) {
        NutsRepository r = this.createRepository(options, null, session);
        this.addRepository(r, session, options.isTemporary());
        return r;
    }

    public NutsRepository createRepository(NutsAddRepositoryOptions options, NutsRepository parentRepository, NutsSession session) {
        return this.createRepository(options, null, parentRepository, session);
    }

    public NutsRepository createRepository(NutsAddRepositoryOptions options, Path rootFolder, NutsRepository parentRepository, NutsSession session) {
        NutsRepositoryModel repoModel = options.getRepositoryModel();
        if (rootFolder == null) {
            Object cc;
            if (parentRepository == null) {
                cc = NutsWorkspaceConfigManagerExt.of(this.getWorkspace().config());
                rootFolder = options.isTemporary() ? Paths.get(cc.getModel().getTempRepositoriesRoot(session), new String[0]) : Paths.get(cc.getModel().getRepositoriesRoot(session), new String[0]);
            } else {
                cc = NutsRepositoryConfigManagerExt.of(parentRepository.config());
                Path path = rootFolder = options.isTemporary() ? cc.getModel().getTempMirrorsRoot(session) : cc.getModel().getMirrorsRoot(session);
            }
        }
        if (repoModel != null) {
            NutsRepositoryConfig config = new NutsRepositoryConfig();
            String name = repoModel.getName();
            String uuid = repoModel.getUuid();
            if (NutsUtilStrings.isBlank((CharSequence)name)) {
                name = "custom";
            }
            if (NutsUtilStrings.isBlank((CharSequence)uuid)) {
                uuid = UUID.randomUUID().toString();
            }
            config.setName(name);
            config.setType("custom");
            config.setUuid(uuid);
            config.setStoreLocationStrategy(repoModel.getStoreLocationStrategy());
            NutsAddRepositoryOptions options2 = new NutsAddRepositoryOptions();
            options2.setName(config.getName());
            options2.setConfig(config);
            options2.setDeployOrder(options.getDeployOrder());
            options2.setTemporary(true);
            options2.setEnabled(options.isEnabled());
            options2.setLocation(CoreIOUtils.resolveRepositoryPath(options2, rootFolder, session));
            return new NutsSimpleRepositoryWrapper(options2, session, null, repoModel);
        }
        options = options.copy();
        try {
            NutsRepository r;
            NutsRepositoryFactoryComponent factory_;
            boolean temporary = options.isTemporary();
            NutsRepositoryConfig conf = options.getConfig();
            if (temporary) {
                options.setLocation(CoreIOUtils.resolveRepositoryPath(options, rootFolder, session));
                options.setEnabled(true);
            } else if (conf == null) {
                options.setLocation(CoreIOUtils.resolveRepositoryPath(options, rootFolder, session));
                conf = this.loadRepository(Paths.get(options.getLocation(), "nuts-repository.json"), options.getName(), this.getWorkspace(), session);
                if (conf == null) {
                    if (options.isFailSafe()) {
                        return null;
                    }
                    throw new NutsInvalidRepositoryException(session, options.getLocation(), NutsMessage.cstyle((String)"invalid repository location ", (Object[])new Object[]{options.getLocation()}));
                }
                options.setConfig(conf);
                if (options.isEnabled()) {
                    options.setEnabled(session.getWorkspace().env().getBootOptions().getRepositories() == null || NutsRepositorySelector.parse(session.getWorkspace().env().getBootOptions().getRepositories()).acceptExisting(options.getName(), conf.getLocation()));
                }
            } else {
                options.setConfig(conf);
                if (options.isEnabled()) {
                    options.setEnabled(session.getWorkspace().env().getBootOptions().getRepositories() == null || NutsRepositorySelector.parse(session.getWorkspace().env().getBootOptions().getRepositories()).acceptExisting(options.getName(), conf.getLocation()));
                }
                options.setLocation(CoreIOUtils.resolveRepositoryPath(options, rootFolder, session));
            }
            if (NutsUtilStrings.isBlank((CharSequence)conf.getName())) {
                conf.setName(options.getName());
            }
            if ((factory_ = (NutsRepositoryFactoryComponent)this.getWorkspace().extensions().setSession(session).createSupported(NutsRepositoryFactoryComponent.class, (Object)conf)) != null && (r = factory_.create(options, session, parentRepository)) != null) {
                return r;
            }
            if (options.isTemporary()) {
                if (NutsUtilStrings.isBlank((CharSequence)conf.getType())) {
                    throw new NutsInvalidRepositoryException(session, options.getName(), NutsMessage.cstyle((String)"unable to detect valid type for temporary repository", (Object[])new Object[0]));
                }
                throw new NutsInvalidRepositoryException(session, options.getName(), NutsMessage.cstyle((String)"invalid repository type %s", (Object[])new Object[]{conf.getType()}));
            }
            if (NutsUtilStrings.isBlank((CharSequence)conf.getType())) {
                throw new NutsInvalidRepositoryException(session, options.getName(), NutsMessage.cstyle((String)"unable to detect valid type for repository", (Object[])new Object[0]));
            }
            throw new NutsInvalidRepositoryException(session, options.getName(), NutsMessage.cstyle((String)"invalid repository type %s", (Object[])new Object[]{conf.getType()}));
        }
        catch (RuntimeException ex) {
            if (options.isFailSafe()) {
                return null;
            }
            throw ex;
        }
    }

    public NutsRepository addRepository(String repositoryNamedUrl, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.getWorkspace(), session);
        NutsRepositorySelector.Selection r = null;
        try {
            r = NutsRepositorySelector.parseSelection(repositoryNamedUrl);
        }
        catch (Exception ex) {
            throw new NutsInvalidRepositoryException(session, repositoryNamedUrl, NutsMessage.cstyle((String)"invalid repository definition", (Object[])new Object[0]));
        }
        NutsAddRepositoryOptions options = NutsRepositorySelector.createRepositoryOptions(r, true, session);
        return this.addRepository(options, session);
    }

    public NutsRepositoryConfig loadRepository(Path file, String name, NutsWorkspace ws, NutsSession session) {
        NutsRepositoryConfig conf = null;
        if (Files.isRegularFile(file, new LinkOption[0]) && Files.isReadable(file)) {
            byte[] bytes;
            try {
                bytes = Files.readAllBytes(file);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            try {
                int buildNumber;
                Map a_config0 = (Map)ws.elem().setSession(session).setContentType(NutsContentType.JSON).parse(bytes, Map.class);
                String version = (String)a_config0.get("configVersion");
                if (version == null) {
                    version = ws.getApiVersion().toString();
                }
                if ((buildNumber = CoreNutsUtils.getApiVersionOrdinalNumber(version)) < 506) {
                    // empty if block
                }
                conf = (NutsRepositoryConfig)ws.elem().setSession(session).setContentType(NutsContentType.JSON).parse(file, NutsRepositoryConfig.class);
            }
            catch (RuntimeException ex) {
                if (session.getWorkspace().env().getBootOptions().isRecover()) {
                    this.onLoadRepositoryError(file, name, null, ex, session);
                }
                throw ex;
            }
        }
        return conf;
    }

    public NutsRepositorySPI toRepositorySPI(NutsRepository repo) {
        return (NutsRepositorySPI)repo;
    }

    private void onLoadRepositoryError(Path file, String name, String uuid, Throwable ex, NutsSession session) {
        NutsWorkspaceConfigManager wconfig = this.getWorkspace().config().setSession(session);
        NutsWorkspaceEnvManager wenv = this.getWorkspace().env().setSession(session);
        if (wconfig.isReadOnly()) {
            throw new UncheckedIOException("error loading repository " + file.toString(), new IOException(ex));
        }
        String fileName = "nuts-repository" + (name == null ? "" : "-" + name) + (uuid == null ? "" : "-" + uuid) + "-" + Instant.now().toString();
        this.LOG.with().session(session).level(Level.SEVERE).verb(NutsLogVerb.FAIL).log("erroneous repository config file. Unable to load file {0} : {1}", new Object[]{file, ex});
        Path logError = Paths.get(this.getWorkspace().locations().getStoreLocation(this.getWorkspace().getApiId(), NutsStoreLocation.LOG), new String[0]).resolve("invalid-config");
        try {
            CoreIOUtils.mkdirs(logError);
        }
        catch (Exception ex1) {
            throw new UncheckedIOException("unable to log repository error while loading config file " + file.toString() + " : " + ex1.toString(), new IOException(ex));
        }
        Path newfile = logError.resolve(fileName + ".json");
        this.LOG.with().session(session).level(Level.SEVERE).verb(NutsLogVerb.FAIL).log("erroneous repository config file will be replaced by a fresh one. Old config is copied to {0}", new Object[]{newfile.toString()});
        try {
            Files.move(file, newfile, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to load and re-create repository config file " + file.toString() + " : " + e.toString(), new IOException(ex));
        }
        try (PrintStream o = new PrintStream(logError.resolve(fileName + ".error").toFile());){
            o.println("workspace.path:" + this.workspace.locations().getWorkspaceLocation());
            o.println("repository.path:" + file);
            o.println("workspace.options:" + wenv.getBootOptions().formatter().setCompact(false).setRuntime(true).setInit(true).setExported(true).getBootCommandLine());
            for (NutsStoreLocation location : NutsStoreLocation.values()) {
                o.println("location." + location.id() + ":" + this.workspace.locations().getStoreLocation(location));
            }
            o.println("java.class.path:" + System.getProperty("java.class.path"));
            o.println();
            ex.printStackTrace(o);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

