/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.repos;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsMapListener;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfigManager;
import net.thevpc.nuts.NutsRepositoryEnvManager;
import net.thevpc.nuts.NutsRepositoryListener;
import net.thevpc.nuts.NutsRepositorySecurityManager;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.common.DefaultObservableMap;
import net.thevpc.nuts.runtime.core.common.ObservableMap;
import net.thevpc.nuts.runtime.core.config.NutsRepositoryConfigManagerExt;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryConfigModel;
import net.thevpc.nuts.runtime.core.util.CachedValue;
import net.thevpc.nuts.runtime.standalone.repos.DefaultNutsRepoConfigManager;
import net.thevpc.nuts.runtime.standalone.repos.DefaultNutsRepositoryEnvManager;
import net.thevpc.nuts.runtime.standalone.repos.DefaultNutsRepositoryEnvModel;
import net.thevpc.nuts.runtime.standalone.security.DefaultNutsRepositorySecurityManager;
import net.thevpc.nuts.runtime.standalone.security.DefaultNutsRepositorySecurityModel;
import net.thevpc.nuts.spi.NutsRepositorySPI;

public abstract class AbstractNutsRepository
implements NutsRepository,
NutsRepositorySPI {
    private static final long serialVersionUID = 1L;
    private final List<NutsRepositoryListener> repositoryListeners = new ArrayList<NutsRepositoryListener>();
    protected Map<String, String> extensions = new HashMap<String, String>();
    protected NutsRepository parentRepository;
    protected NutsWorkspace workspace;
    protected DefaultNutsRepositorySecurityModel securityModel;
    protected NutsRepositoryConfigModel configModel;
    protected ObservableMap<String, Object> userProperties;
    protected boolean enabled = true;
    protected DefaultNutsRepositoryEnvModel envModel;
    protected NutsSession initSession;
    protected CachedValue<Boolean> available = new CachedValue<Boolean>(() -> this.isAvailableImpl(), 30L);

    public AbstractNutsRepository() {
        this.userProperties = new DefaultObservableMap<String, Object>();
        this.envModel = new DefaultNutsRepositoryEnvModel(this);
        this.securityModel = new DefaultNutsRepositorySecurityModel(this);
    }

    public boolean isAvailable() {
        return this.isAvailable(false);
    }

    public boolean isAvailable(boolean force) {
        if (force) {
            return this.available.update();
        }
        return this.available.getValue();
    }

    protected boolean isAvailableImpl() {
        return true;
    }

    public NutsRepositoryEnvManager env() {
        return new DefaultNutsRepositoryEnvManager(this.envModel);
    }

    public String getRepositoryType() {
        return this.config().getType();
    }

    public String getUuid() {
        return this.configModel.getUuid();
    }

    public String getName() {
        return this.configModel.getName();
    }

    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }

    public NutsRepository getParentRepository() {
        return this.parentRepository;
    }

    public NutsRepositoryConfigManager config() {
        return new DefaultNutsRepoConfigManager(this.configModel);
    }

    public NutsRepositorySecurityManager security() {
        return new DefaultNutsRepositorySecurityManager(this.securityModel);
    }

    public NutsRepository removeRepositoryListener(NutsRepositoryListener listener) {
        this.repositoryListeners.add(listener);
        return this;
    }

    public NutsRepository addRepositoryListener(NutsRepositoryListener listener) {
        if (listener != null) {
            this.repositoryListeners.add(listener);
        }
        return this;
    }

    public NutsRepositoryListener[] getRepositoryListeners() {
        return this.repositoryListeners.toArray(new NutsRepositoryListener[0]);
    }

    public Map<String, Object> getUserProperties() {
        return this.userProperties;
    }

    public NutsRepository addUserPropertyListener(NutsMapListener<String, Object> listener) {
        this.userProperties.addListener(listener);
        return this;
    }

    public NutsRepository removeUserPropertyListener(NutsMapListener<String, Object> listener) {
        this.userProperties.removeListener(listener);
        return this;
    }

    public NutsMapListener<String, Object>[] getUserPropertyListeners() {
        return this.userProperties.getListeners();
    }

    public boolean isEnabled() {
        return this.enabled && this.config().isEnabled();
    }

    public NutsRepository setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String toString() {
        NutsRepositoryConfigManagerExt cc = NutsRepositoryConfigManagerExt.of(this.config());
        NutsRepositoryConfigManager c = this.config();
        String name = this.getName();
        String storePath = null;
        String loc = cc.getModel().getLocation();
        String impl = this.getClass().getSimpleName();
        if (c != null) {
            String storeLocation = cc.getModel().getStoreLocation();
            storePath = storeLocation == null ? null : Paths.get(storeLocation, new String[0]).toAbsolutePath().toString();
        }
        LinkedHashMap<String, String> a = new LinkedHashMap<String, String>();
        if (name != null) {
            a.put("name", name);
        }
        if (impl != null) {
            a.put("impl", impl);
        }
        if (storePath != null) {
            a.put("store", storePath);
        }
        if (loc != null) {
            a.put("location", loc);
        }
        return a.toString();
    }

    protected String getIdExtension(NutsId id, NutsSession session) {
        return this.getWorkspace().locations().setSession(session).getDefaultIdExtension(id);
    }

    public String getIdBasedir(NutsId id, NutsSession session) {
        return this.getWorkspace().locations().setSession(session).getDefaultIdBasedir(id);
    }

    public String getIdFilename(NutsId id, NutsSession session) {
        String c;
        String classifier = "";
        String ext = this.getIdExtension(id, session);
        if (!(ext.equals(".nuts") || ext.equals(".pom") || NutsUtilStrings.isBlank((CharSequence)(c = id.getClassifier())))) {
            classifier = "-" + c;
        }
        return id.getArtifactId() + "-" + id.getVersion().getValue() + classifier + ext;
    }
}

