/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdParser;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsParseException;
import net.thevpc.nuts.NutsSession;

public class DefaultNutsIdParser
implements NutsIdParser {
    public static final Pattern NUTS_ID_PATTERN = Pattern.compile("^(?<group>[a-zA-Z0-9_.${}*-]+)(:(?<artifact>[a-zA-Z0-9_.${}*-]+))?(#(?<version>[^?]+))?(\\?(?<query>.+))?$");
    private NutsSession session;
    private boolean lenient = true;

    public DefaultNutsIdParser(NutsSession session) {
        this.session = session;
    }

    public NutsIdParser setLenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public NutsId parse(String nutsId) {
        Matcher m;
        if (nutsId != null && (m = NUTS_ID_PATTERN.matcher(nutsId)).find()) {
            NutsIdBuilder builder = this.session.getWorkspace().id().builder();
            String group = m.group("group");
            String artifact = m.group("artifact");
            builder.setArtifactId(artifact);
            builder.setVersion(m.group("version"));
            builder.setProperties(m.group("query"));
            if (artifact == null) {
                artifact = group;
                group = null;
            }
            builder.setArtifactId(artifact);
            builder.setGroupId(group);
            return builder.build();
        }
        if (!this.isLenient()) {
            throw new NutsParseException(this.session, NutsMessage.cstyle((String)"invalid id format : %s", (Object[])new Object[]{nutsId}));
        }
        return null;
    }
}

