/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.model;

import java.util.Map;
import java.util.function.Function;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.runtime.bundles.parsers.QueryStringParser;
import net.thevpc.nuts.runtime.core.model.DefaultNutsId;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;

public class DefaultNutsIdBuilder
implements NutsIdBuilder {
    private transient NutsSession session;
    private String groupId;
    private String artifactId;
    private NutsVersion version;
    private transient QueryStringParser propertiesQuery = new QueryStringParser(true, (name, value) -> {
        if (name != null) {
            switch (name) {
                case "version": {
                    this.setVersion(value);
                    return true;
                }
            }
        }
        return false;
    });

    public DefaultNutsIdBuilder(NutsSession session) {
        this.session = session;
    }

    public DefaultNutsIdBuilder(NutsId id, NutsSession session) {
        this.session = session;
        this.setGroupId(id.getGroupId());
        this.setArtifactId(id.getArtifactId());
        this.setVersion(id.getVersion());
        this.setProperties(id.getPropertiesQuery());
    }

    public DefaultNutsIdBuilder(String groupId, String artifactId, NutsVersion version, String propertiesQuery, NutsSession session) {
        this.session = session;
        this.groupId = NutsUtilStrings.trimToNull((String)groupId);
        this.artifactId = NutsUtilStrings.trimToNull((String)artifactId);
        this.version = version == null ? session.getWorkspace().version().parser().parse("") : version;
        this.propertiesQuery.setProperties(propertiesQuery);
    }

    public NutsIdBuilder set(NutsId id) {
        if (id == null) {
            this.clear();
        } else {
            this.setGroupId(id.getGroupId());
            this.setArtifactId(id.getArtifactId());
            this.setVersion(id.getVersion());
            this.setProperties(id.getPropertiesQuery());
        }
        return this;
    }

    public NutsIdBuilder clear() {
        this.setGroupId(null);
        this.setArtifactId(null);
        this.setVersion((NutsVersion)null);
        this.setProperties("");
        return this;
    }

    public NutsIdBuilder set(NutsIdBuilder id) {
        if (id == null) {
            this.clear();
        } else {
            this.setGroupId(id.getGroupId());
            this.setArtifactId(id.getArtifactId());
            this.setVersion(id.getVersion());
            this.setProperties(id.getPropertiesQuery());
        }
        return this;
    }

    public NutsIdBuilder setGroupId(String value) {
        this.groupId = NutsUtilStrings.trimToNull((String)value);
        return this;
    }

    public NutsIdBuilder setRepository(String value) {
        return this.setProperty("repo", NutsUtilStrings.trimToNull((String)value));
    }

    public NutsIdBuilder setVersion(NutsVersion value) {
        this.version = value == null ? this.session.getWorkspace().version().parser().parse("") : value;
        return this;
    }

    public NutsIdBuilder setVersion(String value) {
        this.version = this.session.getWorkspace().version().parser().parse(value);
        return this;
    }

    public DefaultNutsIdBuilder setArtifactId(String value) {
        this.artifactId = NutsUtilStrings.trimToNull((String)value);
        return this;
    }

    public String getFace() {
        String s = this.getProperties().get("face");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public String getOs() {
        String s = this.getProperties().get("os");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public String getOsdist() {
        String s = this.getProperties().get("osdist");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public String getPlatform() {
        String s = this.getProperties().get("platform");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public String getPackaging() {
        String s = this.getProperties().get("packaging");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public String getArch() {
        String s = this.getProperties().get("arch");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public NutsIdBuilder setFace(String value) {
        return this.setProperty("face", NutsUtilStrings.trimToNull((String)value));
    }

    public NutsIdBuilder setFaceContent() {
        return this.setFace("content");
    }

    public NutsIdBuilder setFaceDescriptor() {
        return this.setFace("descriptor");
    }

    public String getClassifier() {
        String s = this.getProperties().get("classifier");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public NutsIdBuilder setClassifier(String value) {
        return this.setProperty("classifier", NutsUtilStrings.trimToNull((String)value));
    }

    public NutsIdBuilder setPackaging(String value) {
        return this.setProperty("packaging", NutsUtilStrings.trimToNull((String)value));
    }

    public NutsIdBuilder setPlatform(String value) {
        return this.setProperty("platform", NutsUtilStrings.trimToNull((String)value));
    }

    public NutsIdBuilder setArch(String value) {
        return this.setProperty("arch", NutsUtilStrings.trimToNull((String)value));
    }

    public NutsIdBuilder setOs(String value) {
        return this.setProperty("osdist", NutsUtilStrings.trimToNull((String)value));
    }

    public NutsIdBuilder setOsdist(String value) {
        return this.setProperty("os", NutsUtilStrings.trimToNull((String)value));
    }

    public NutsIdBuilder setProperty(String property, String value) {
        this.propertiesQuery.setProperty(property, value);
        return this;
    }

    public NutsIdBuilder setProperties(Map<String, String> queryMap) {
        this.propertiesQuery.setProperties(queryMap);
        return this;
    }

    public NutsIdBuilder addProperties(Map<String, String> queryMap) {
        this.propertiesQuery.addProperties(queryMap);
        return this;
    }

    public NutsIdBuilder setProperties(String propertiesQuery) {
        this.propertiesQuery.setProperties(propertiesQuery);
        return this;
    }

    public NutsIdBuilder addProperties(String propertiesQuery) {
        this.propertiesQuery.addProperties(propertiesQuery);
        return this;
    }

    public String getPropertiesQuery() {
        return this.propertiesQuery.getPropertiesQuery();
    }

    public Map<String, String> getProperties() {
        return this.propertiesQuery.getProperties();
    }

    public String getRepository() {
        return NutsUtilStrings.trimToNull((String)this.getProperties().get("repo"));
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getFullName() {
        if (NutsUtilStrings.isBlank((CharSequence)this.groupId)) {
            return NutsUtilStrings.trim((String)this.artifactId);
        }
        return NutsUtilStrings.trim((String)this.groupId) + ":" + NutsUtilStrings.trim((String)this.artifactId);
    }

    public String getShortName() {
        if (NutsUtilStrings.isBlank((CharSequence)this.groupId)) {
            return NutsUtilStrings.trim((String)this.artifactId);
        }
        return NutsUtilStrings.trim((String)this.groupId) + ":" + NutsUtilStrings.trim((String)this.artifactId);
    }

    public String getLongName() {
        String s = this.getShortName();
        NutsVersion v = this.getVersion();
        if (v.isBlank()) {
            return s;
        }
        return s + "#" + v;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public NutsVersion getVersion() {
        return this.version;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!NutsUtilStrings.isBlank((CharSequence)this.groupId)) {
            sb.append(this.groupId).append(":");
        }
        sb.append(this.artifactId);
        if (!NutsUtilStrings.isBlank((CharSequence)this.version.getValue())) {
            sb.append("#").append(this.version);
        }
        if (!this.propertiesQuery.isEmpty()) {
            sb.append("?");
            sb.append(this.propertiesQuery.getPropertiesQuery());
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNutsIdBuilder nutsId = (DefaultNutsIdBuilder)o;
        if (this.groupId != null ? !this.groupId.equals(nutsId.groupId) : nutsId.groupId != null) {
            return false;
        }
        if (this.artifactId != null ? !this.artifactId.equals(nutsId.artifactId) : nutsId.artifactId != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(nutsId.version) : nutsId.version != null) {
            return false;
        }
        return this.propertiesQuery != null ? this.propertiesQuery.equals(nutsId.propertiesQuery) : nutsId.propertiesQuery == null;
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.propertiesQuery != null ? this.propertiesQuery.hashCode() : 0);
        return result;
    }

    public NutsIdBuilder apply(Function<String, String> properties) {
        this.setGroupId(CoreNutsUtils.applyStringProperties(this.getGroupId(), properties));
        this.setArtifactId(CoreNutsUtils.applyStringProperties(this.getArtifactId(), properties));
        this.setVersion(CoreNutsUtils.applyStringProperties(this.getVersion().getValue(), properties));
        this.setProperties(CoreNutsUtils.applyMapProperties(this.getProperties(), properties));
        return this;
    }

    public NutsIdBuilder omitImportedGroupId() {
        String g = this.getGroupId();
        if (g != null && g.length() > 0 && this.session.getWorkspace().imports().isImportedGroupId(g)) {
            this.setGroupId(null);
        }
        return this;
    }

    public NutsId build() {
        return new DefaultNutsId(this.groupId, this.artifactId, this.version == null ? null : this.version.getValue(), this.propertiesQuery.getPropertiesQuery(), this.session);
    }
}

