/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.model;

import java.util.ArrayList;
import java.util.Map;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsFormat;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTokenFilter;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.parsers.QueryStringParser;
import net.thevpc.nuts.runtime.bundles.string.GlobUtils;
import net.thevpc.nuts.runtime.core.filters.DefaultNutsTokenFilter;
import net.thevpc.nuts.runtime.core.model.DefaultNutsIdBuilder;

public class DefaultNutsId
implements NutsId {
    public static final long serialVersionUID = 1L;
    private final String groupId;
    private final String artifactId;
    private final NutsVersion version;
    private final String properties;
    private transient NutsWorkspace ws;
    private transient NutsSession session;

    public DefaultNutsId(String groupId, String artifactId, String version, Map<String, String> properties, NutsSession session) {
        this(groupId, artifactId, session.getWorkspace().version().parser().parse(version), properties, session);
    }

    protected DefaultNutsId(String groupId, String artifactId, NutsVersion version, Map<String, String> properties, NutsSession session) {
        this.ws = session.getWorkspace();
        this.session = session;
        this.groupId = NutsUtilStrings.trimToNull((String)groupId);
        this.artifactId = NutsUtilStrings.trimToNull((String)artifactId);
        this.version = version == null ? this.ws.version().parser().parse("") : version;
        this.properties = QueryStringParser.formatSortedPropertiesQuery(properties);
    }

    protected DefaultNutsId(String groupId, String artifactId, NutsVersion version, String properties, NutsSession session) {
        this.ws = session.getWorkspace();
        this.session = session;
        this.groupId = NutsUtilStrings.trimToNull((String)groupId);
        this.artifactId = NutsUtilStrings.trimToNull((String)artifactId);
        this.version = version == null ? this.ws.version().parser().parse("") : version;
        this.properties = QueryStringParser.formatSortedPropertiesQuery(properties);
    }

    public DefaultNutsId(String groupId, String artifactId, String version, NutsSession session) {
        this(groupId, artifactId, version, (String)null, session);
    }

    public DefaultNutsId(String groupId, String artifactId, String version, String properties, NutsSession session) {
        this.ws = session.getWorkspace();
        this.session = session;
        this.groupId = NutsUtilStrings.trimToNull((String)groupId);
        this.artifactId = NutsUtilStrings.trimToNull((String)artifactId);
        this.version = this.ws.version().parser().parse(version);
        this.properties = QueryStringParser.formatSortedPropertiesQuery(properties);
    }

    public NutsFormat formatter() {
        return this.ws.id().formatter().setValue((NutsId)this);
    }

    public boolean isNull() {
        return false;
    }

    public boolean isBlank() {
        return this.toString().isEmpty();
    }

    public boolean matches(String pattern) {
        if (pattern == null) {
            return true;
        }
        return this.toString().matches(pattern);
    }

    public boolean contains(String substring) {
        return this.toString().contains(substring);
    }

    public NutsTokenFilter groupIdToken() {
        return new DefaultNutsTokenFilter(this.getGroupId());
    }

    public NutsTokenFilter propertiesToken() {
        return new DefaultNutsTokenFilter(this.getPropertiesQuery());
    }

    public NutsTokenFilter versionToken() {
        return new DefaultNutsTokenFilter(this.getVersion().getValue());
    }

    public NutsTokenFilter artifactIdToken() {
        return new DefaultNutsTokenFilter(this.getArtifactId());
    }

    public NutsTokenFilter repositoryToken() {
        return new DefaultNutsTokenFilter(this.getRepository());
    }

    public NutsTokenFilter anyToken() {
        final NutsTokenFilter[] oo = new NutsTokenFilter[]{this.groupIdToken(), this.propertiesToken(), this.versionToken(), this.artifactIdToken(), this.repositoryToken()};
        return new NutsTokenFilter(){

            public boolean isNull() {
                for (NutsTokenFilter t : oo) {
                    if (!t.isNull()) continue;
                    return true;
                }
                return false;
            }

            public boolean isBlank() {
                for (NutsTokenFilter t : oo) {
                    if (!t.isBlank()) continue;
                    return true;
                }
                return false;
            }

            public boolean like(String pattern) {
                for (NutsTokenFilter t : oo) {
                    if (!t.like(pattern)) continue;
                    return true;
                }
                return false;
            }

            public boolean matches(String pattern) {
                for (NutsTokenFilter t : oo) {
                    if (!t.matches(pattern)) continue;
                    return true;
                }
                return false;
            }

            public boolean contains(String pattern) {
                for (NutsTokenFilter t : oo) {
                    if (!t.contains(pattern)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public boolean equalsShortName(NutsId other) {
        if (other == null) {
            return false;
        }
        return NutsUtilStrings.trim((String)this.artifactId).equals(NutsUtilStrings.trim((String)other.getArtifactId())) && NutsUtilStrings.trim((String)this.groupId).equals(NutsUtilStrings.trim((String)other.getGroupId()));
    }

    public boolean like(String pattern) {
        if (pattern == null) {
            return true;
        }
        return GlobUtils.ofExact(pattern).matcher(this.toString()).matches();
    }

    public String getFace() {
        String s = this.getProperties().get("face");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public String getClassifier() {
        String s = this.getProperties().get("classifier");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public String getPackaging() {
        String s = this.getProperties().get("packaging");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public String getOs() {
        String s = this.getProperties().get("os");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public String getOsdist() {
        String s = this.getProperties().get("osdist");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public String getPlatform() {
        String s = this.getProperties().get("platform");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public String getArch() {
        String s = this.getProperties().get("arch");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public String getPropertiesQuery() {
        return this.properties;
    }

    public Map<String, String> getProperties() {
        return QueryStringParser.parseMap(this.properties);
    }

    public String getRepository() {
        String s = this.getProperties().get("repo");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public NutsId getShortNameId() {
        return new DefaultNutsId(this.groupId, this.artifactId, (NutsVersion)null, "", this.session);
    }

    public NutsId getLongNameId() {
        return new DefaultNutsId(this.groupId, this.artifactId, this.version, "", this.session);
    }

    public String getShortName() {
        if (NutsUtilStrings.isBlank((CharSequence)this.groupId)) {
            return NutsUtilStrings.trim((String)this.artifactId);
        }
        return NutsUtilStrings.trim((String)this.groupId) + ":" + NutsUtilStrings.trim((String)this.artifactId);
    }

    public String getLongName() {
        String s = this.getShortName();
        NutsVersion v = this.getVersion();
        if (v.isBlank()) {
            return s;
        }
        return s + "#" + v;
    }

    public String getFullName() {
        return this.toString();
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public NutsVersion getVersion() {
        return this.version;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!NutsUtilStrings.isBlank((CharSequence)this.groupId)) {
            sb.append(this.groupId).append(":");
        }
        sb.append(this.artifactId);
        if (!this.version.isBlank()) {
            sb.append("#").append(this.version);
        }
        if (!NutsUtilStrings.isBlank((CharSequence)this.properties)) {
            sb.append("?");
            sb.append(this.properties);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNutsId nutsId = (DefaultNutsId)o;
        if (this.groupId != null ? !this.groupId.equals(nutsId.groupId) : nutsId.groupId != null) {
            return false;
        }
        if (this.artifactId != null ? !this.artifactId.equals(nutsId.artifactId) : nutsId.artifactId != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(nutsId.version) : nutsId.version != null) {
            return false;
        }
        return this.properties != null ? this.properties.equals(nutsId.properties) : nutsId.properties == null;
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }

    public NutsDependency toDependency() {
        Map<String, String> properties = this.getProperties();
        String exc = properties.get("exclusions");
        if (exc == null) {
            exc = "";
        }
        ArrayList<NutsId> a = new ArrayList<NutsId>();
        for (String s : exc.split("[;,]")) {
            NutsId n = this.ws.id().parser().parse(s);
            if (n == null) continue;
            a.add(n);
        }
        return this.ws.dependency().builder().setRepository(this.getRepository()).setArtifactId(this.getArtifactId()).setGroupId(this.getGroupId()).setClassifier(this.getClassifier()).setVersion(this.getVersion()).setScope(properties.get("scope")).setOptional(properties.get("optional")).setExclusions(a.toArray(new NutsId[0])).setProperties(properties).build();
    }

    public NutsIdBuilder builder() {
        return new DefaultNutsIdBuilder(this, this.session);
    }

    public int compareTo(NutsId o2) {
        int x = this.getShortName().compareTo(o2.getShortName());
        if (x != 0) {
            return x;
        }
        x = this.getVersion().compareTo(o2.getVersion());
        return -x;
    }
}

