/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.NutsArtifactCall;
import net.thevpc.nuts.NutsClassifierMapping;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdLocation;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.core.model.AbstractNutsDescriptor;
import net.thevpc.nuts.runtime.core.util.CoreArrayUtils;

public class DefaultNutsDescriptor
extends AbstractNutsDescriptor {
    private static final long serialVersionUID = 1L;
    private NutsId id;
    private NutsId[] parents;
    private String packaging;
    private boolean executable;
    private boolean application;
    private NutsArtifactCall executor;
    private NutsArtifactCall installer;
    private String name;
    private String description;
    private String[] icons;
    private String[] categories;
    private String genericName;
    private String[] arch;
    private String[] os;
    private String[] osdist;
    private String[] platform;
    private String[] desktopEnvironment;
    private NutsIdLocation[] locations;
    private NutsClassifierMapping[] classifierMappings;
    private NutsDependency[] dependencies;
    private NutsDependency[] standardDependencies;
    private Map<String, String> properties;

    public DefaultNutsDescriptor(NutsDescriptor d, NutsSession session) {
        this(d.getId(), d.getParents(), d.getPackaging(), d.isExecutable(), d.isApplication(), d.getExecutor(), d.getInstaller(), d.getName(), d.getDescription(), d.getArch(), d.getOs(), d.getOsdist(), d.getPlatform(), d.getDesktopEnvironment(), d.getDependencies(), d.getStandardDependencies(), d.getLocations(), d.getProperties(), d.getClassifierMappings(), d.getGenericName(), d.getCategories(), d.getIcons(), session);
    }

    public DefaultNutsDescriptor(NutsId id, NutsId[] parents, String packaging, boolean executable, boolean application, NutsArtifactCall executor, NutsArtifactCall installer, String name, String description, String[] arch, String[] os, String[] osdist, String[] platform, String[] desktopEnvironment, NutsDependency[] dependencies, NutsDependency[] standardDependencies, NutsIdLocation[] locations, Map<String, String> properties, NutsClassifierMapping[] classifierMappings, String genericName, String[] categories, String[] icons, NutsSession session) {
        super(session);
        int i;
        if (id == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing id", (Object[])new Object[0]));
        }
        if (NutsUtilStrings.isBlank((CharSequence)id.getArtifactId())) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing artifactId for %s", (Object[])new Object[]{id}));
        }
        if (!id.getProperties().isEmpty()) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"id should not have query defined in descriptors", (Object[])new Object[0]));
        }
        this.id = id;
        this.packaging = NutsUtilStrings.trimToNull((String)packaging);
        NutsId[] nutsIdArray = this.parents = parents == null ? new NutsId[]{} : new NutsId[parents.length];
        if (parents != null) {
            System.arraycopy(parents, 0, this.parents, 0, this.parents.length);
        }
        this.executable = executable;
        this.application = application;
        this.description = NutsUtilStrings.trimToNull((String)description);
        this.name = NutsUtilStrings.trimToNull((String)name);
        this.genericName = NutsUtilStrings.trimToNull((String)genericName);
        this.icons = icons == null ? new String[]{} : (String[])Arrays.stream(icons).map(x -> x == null ? "" : x.trim()).filter(x -> x.length() > 0).toArray(String[]::new);
        this.categories = categories == null ? new String[]{} : (String[])Arrays.stream(categories).map(x -> x == null ? "" : x.trim()).filter(x -> x.length() > 0).toArray(String[]::new);
        this.executor = executor;
        this.installer = installer;
        this.arch = CoreArrayUtils.toArraySet(arch, new String[0][]);
        this.os = CoreArrayUtils.toArraySet(os, new String[0][]);
        this.osdist = CoreArrayUtils.toArraySet(osdist, new String[0][]);
        this.platform = CoreArrayUtils.toArraySet(platform, new String[0][]);
        this.desktopEnvironment = CoreArrayUtils.toArraySet(desktopEnvironment, new String[0][]);
        this.locations = CoreArrayUtils.toArraySet(locations);
        this.classifierMappings = CoreArrayUtils.toArraySet(classifierMappings);
        this.dependencies = dependencies == null ? new NutsDependency[]{} : new NutsDependency[dependencies.length];
        for (i = 0; i < this.dependencies.length; ++i) {
            if (dependencies[i] == null) {
                throw new NullPointerException();
            }
            this.dependencies[i] = dependencies[i];
        }
        this.standardDependencies = standardDependencies == null ? new NutsDependency[]{} : new NutsDependency[standardDependencies.length];
        for (i = 0; i < this.standardDependencies.length; ++i) {
            if (standardDependencies[i] == null) {
                throw new NullPointerException();
            }
            this.standardDependencies[i] = standardDependencies[i];
        }
        if (properties == null || properties.isEmpty()) {
            this.properties = null;
        } else {
            HashMap<String, String> p = new HashMap<String, String>(properties);
            this.properties = Collections.unmodifiableMap(p);
        }
        if (this.properties != null && "true".equals(this.properties.get("nuts.application")) && !application) {
            System.out.println("why");
        }
    }

    public NutsId getId() {
        return this.id;
    }

    public NutsId[] getParents() {
        return this.parents;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public boolean isApplication() {
        return this.application;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String[] getArch() {
        return this.arch;
    }

    public String[] getOs() {
        return this.os;
    }

    public String[] getOsdist() {
        return this.osdist;
    }

    public String[] getPlatform() {
        return this.platform;
    }

    public String[] getDesktopEnvironment() {
        return this.desktopEnvironment;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public NutsClassifierMapping[] getClassifierMappings() {
        return this.classifierMappings;
    }

    public NutsIdLocation[] getLocations() {
        return this.locations;
    }

    public NutsDependency[] getStandardDependencies() {
        return this.standardDependencies;
    }

    public NutsDependency[] getDependencies() {
        return this.dependencies;
    }

    public NutsArtifactCall getExecutor() {
        return this.executor;
    }

    public NutsArtifactCall getInstaller() {
        return this.installer;
    }

    public Map<String, String> getProperties() {
        return this.properties == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this.properties);
    }

    public String[] getIcons() {
        return this.icons;
    }

    public String[] getCategories() {
        return this.categories;
    }

    public String getGenericName() {
        return this.genericName;
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.packaging, this.executable, this.application, this.executor, this.installer, this.name, this.description, this.properties, this.categories, this.genericName);
        result = 31 * result + Arrays.hashCode(this.icons);
        result = 31 * result + Arrays.hashCode(this.parents);
        result = 31 * result + Arrays.hashCode(this.arch);
        result = 31 * result + Arrays.hashCode(this.os);
        result = 31 * result + Arrays.hashCode(this.osdist);
        result = 31 * result + Arrays.hashCode(this.platform);
        result = 31 * result + Arrays.hashCode(this.desktopEnvironment);
        result = 31 * result + Arrays.hashCode(this.locations);
        result = 31 * result + Arrays.hashCode(this.classifierMappings);
        result = 31 * result + Arrays.hashCode(this.dependencies);
        result = 31 * result + Arrays.hashCode(this.standardDependencies);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNutsDescriptor that = (DefaultNutsDescriptor)o;
        return this.executable == that.executable && this.application == that.application && Objects.equals(this.id, that.id) && Arrays.equals(this.parents, that.parents) && Objects.equals(this.packaging, that.packaging) && Objects.equals(this.executor, that.executor) && Objects.equals(this.installer, that.installer) && Objects.equals(this.name, that.name) && Arrays.equals(this.icons, that.icons) && Arrays.equals(this.categories, that.categories) && Objects.equals(this.genericName, that.genericName) && Objects.equals(this.description, that.description) && Arrays.equals(this.arch, that.arch) && Arrays.equals(this.os, that.os) && Arrays.equals(this.osdist, that.osdist) && Arrays.equals(this.platform, that.platform) && Arrays.equals(this.desktopEnvironment, that.desktopEnvironment) && Arrays.equals(this.locations, that.locations) && Arrays.equals(this.classifierMappings, that.classifierMappings) && Arrays.equals(this.dependencies, that.dependencies) && Arrays.equals(this.standardDependencies, that.standardDependencies) && Objects.equals(this.properties, that.properties);
    }

    public String toString() {
        return "DefaultNutsDescriptor{id=" + this.id + ", parents=" + Arrays.toString(this.parents) + ", packaging='" + this.packaging + '\'' + ", executable=" + this.executable + ", application=" + this.application + ", executor=" + this.executor + ", installer=" + this.installer + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", arch=" + Arrays.toString(this.arch) + ", os=" + Arrays.toString(this.os) + ", osdist=" + Arrays.toString(this.osdist) + ", platform=" + Arrays.toString(this.platform) + ", desktopEnvironment=" + Arrays.toString(this.desktopEnvironment) + ", locations=" + Arrays.toString(this.locations) + ", dependencies=" + Arrays.toString(this.dependencies) + ", standardDependencies=" + Arrays.toString(this.standardDependencies) + ", icon=" + Arrays.toString(this.icons) + ", category=" + this.categories + ", genericName=" + this.genericName + ", properties=" + this.properties + '}';
    }
}

