/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyBuilder;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdParser;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.runtime.bundles.parsers.QueryStringParser;
import net.thevpc.nuts.runtime.core.model.DefaultNutsDependency;
import net.thevpc.nuts.runtime.core.util.CoreNutsDependencyUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsDependencyScopes;

public class DefaultNutsDependencyBuilder
implements NutsDependencyBuilder {
    private String repo;
    private String groupId;
    private String artifactId;
    private NutsVersion version;
    private String scope;
    private String optional;
    private String type;
    private String os;
    private String arch;
    private String classifier;
    private NutsId[] exclusions = new NutsId[0];
    private transient NutsSession session;
    private transient QueryStringParser propertiesQuery = new QueryStringParser(true, (name, value) -> {
        if (name != null) {
            switch (name) {
                case "scope": {
                    this.setScope(value);
                    return true;
                }
                case "version": {
                    this.setVersion(value);
                    return true;
                }
                case "optional": {
                    this.setOptional(value);
                    return true;
                }
                case "classifier": {
                    this.setClassifier(value);
                    return true;
                }
                case "repo": {
                    this.setRepository(value);
                    return true;
                }
                case "exclusions": {
                    this.setExclusions(value);
                    return true;
                }
                case "os": {
                    this.setOs(value);
                    return true;
                }
                case "arch": {
                    this.setArch(value);
                    return true;
                }
                case "type": {
                    this.setType(value);
                    return true;
                }
            }
        }
        return false;
    });

    public DefaultNutsDependencyBuilder() {
    }

    public DefaultNutsDependencyBuilder(NutsSession session) {
        this.session = session;
    }

    public NutsDependencyBuilder setRepository(String repository) {
        this.repo = NutsUtilStrings.trimToNull((String)repository);
        return this;
    }

    public NutsDependencyBuilder setGroupId(String groupId) {
        this.groupId = NutsUtilStrings.trimToNull((String)groupId);
        return this;
    }

    public NutsDependencyBuilder setArtifactId(String artifactId) {
        this.artifactId = NutsUtilStrings.trimToNull((String)artifactId);
        return this;
    }

    public NutsDependencyBuilder setVersion(NutsVersion version) {
        this.version = version == null ? this.session.getWorkspace().version().parser().parse("") : version;
        return this;
    }

    public NutsDependencyBuilder setVersion(String classifier) {
        this.version = this.session.getWorkspace().version().parser().parse(classifier);
        return this;
    }

    public NutsDependencyBuilder setId(NutsId id) {
        if (id == null) {
            this.setRepository(null);
            this.setGroupId(null);
            this.setArtifactId(null);
            this.setVersion((String)null);
        } else {
            this.setRepository(id.getRepository());
            this.setGroupId(id.getGroupId());
            this.setArtifactId(id.getArtifactId());
            this.setVersion(id.getVersion());
            this.addProperties(id.getProperties());
        }
        return this;
    }

    public NutsDependencyBuilder setScope(NutsDependencyScope scope) {
        this.scope = scope == null ? "" : scope.toString();
        return this;
    }

    public NutsDependencyBuilder setScope(String scope) {
        this.scope = NutsDependencyScopes.normalizeScope(scope);
        return this;
    }

    public NutsDependencyBuilder setType(String type) {
        this.type = CoreNutsDependencyUtils.normalizeDependencyType(type);
        return this;
    }

    public String getType() {
        return this.type;
    }

    public NutsDependencyBuilder setOptional(String optional) {
        String o = NutsUtilStrings.trimToNull((String)optional);
        if ("false".equals(o)) {
            o = null;
        } else if ("true".equalsIgnoreCase(o)) {
            o = "true";
        }
        this.optional = o;
        return this;
    }

    public NutsDependencyBuilder setClassifier(String classifier) {
        this.classifier = NutsUtilStrings.trimToNull((String)classifier);
        return this;
    }

    public NutsDependencyBuilder setOs(String os) {
        this.os = NutsUtilStrings.trimToNull((String)os);
        return this;
    }

    public NutsDependencyBuilder setArch(String arch) {
        this.arch = NutsUtilStrings.trimToNull((String)arch);
        return this;
    }

    public NutsDependencyBuilder setExclusions(NutsId[] exclusions) {
        if (exclusions != null) {
            exclusions = Arrays.copyOf(exclusions, exclusions.length);
        }
        this.exclusions = exclusions;
        return this;
    }

    public NutsDependencyBuilder setDependency(NutsDependencyBuilder value) {
        return this.set(value);
    }

    public String getOs() {
        return this.os;
    }

    public String getArch() {
        return this.arch;
    }

    public NutsDependencyBuilder set(NutsDependencyBuilder value) {
        if (value != null) {
            this.setRepository(value.getRepository());
            this.setGroupId(value.getGroupId());
            this.setArtifactId(value.getArtifactId());
            this.setVersion(value.getVersion());
            this.setScope(value.getScope());
            this.setOptional(value.getOptional());
            this.setExclusions(value.getExclusions());
            this.setClassifier(value.getClassifier());
            this.setOs(value.getOs());
            this.setArch(value.getArch());
            this.setType(value.getType());
            this.setProperties(value.getProperties());
        } else {
            this.clear();
        }
        return this;
    }

    public NutsDependencyBuilder set(NutsDependency value) {
        if (value != null) {
            this.setRepository(value.getRepository());
            this.setGroupId(value.getGroupId());
            this.setArtifactId(value.getArtifactId());
            this.setVersion(value.getVersion());
            this.setScope(value.getScope());
            this.setOptional(value.getOptional());
            this.setExclusions(value.getExclusions());
            this.setClassifier(value.getClassifier());
            this.setOs(value.getOs());
            this.setArch(value.getArch());
            this.setType(value.getType());
            this.setProperties(value.getProperties());
        } else {
            this.clear();
        }
        return this;
    }

    public NutsDependencyBuilder setDependency(NutsDependency value) {
        return this.set(value);
    }

    public NutsDependencyBuilder clear() {
        this.setRepository(null);
        this.setGroupId(null);
        this.setArtifactId(null);
        this.setVersion((NutsVersion)null);
        this.setScope((String)null);
        this.setOptional(null);
        this.setExclusions((NutsId[])null);
        this.setClassifier(null);
        this.setOs(null);
        this.setArch(null);
        this.setType(null);
        this.setProperties((Map<String, String>)null);
        return this;
    }

    public boolean isOptional() {
        return this.optional != null && Boolean.parseBoolean(this.optional);
    }

    public String getOptional() {
        return this.optional;
    }

    public String getScope() {
        return this.scope;
    }

    public NutsId toId() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (!NutsDependencyScopes.isDefaultScope(this.scope)) {
            m.put("scope", this.scope);
        }
        if (!NutsUtilStrings.isBlank((CharSequence)this.optional) && !"false".equals(this.optional)) {
            m.put("optional", this.optional);
        }
        if (!NutsUtilStrings.isBlank((CharSequence)this.classifier)) {
            m.put("classifier", this.classifier);
        }
        if (!NutsUtilStrings.isBlank((CharSequence)this.type)) {
            m.put("type", this.type);
        }
        if (this.exclusions.length > 0) {
            TreeSet<String> ex = new TreeSet<String>();
            for (NutsId exclusion : this.exclusions) {
                ex.add(exclusion.getShortName());
            }
            m.put("exclusions", String.join((CharSequence)",", ex));
        }
        return this.session.getWorkspace().id().builder().setRepository(this.getRepository()).setGroupId(this.getGroupId()).setArtifactId(this.getArtifactId()).setVersion(this.getVersion()).setOs(this.getOs()).setArch(this.getArch()).setProperties(m).build();
    }

    public String getRepository() {
        return this.repo;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getFullName() {
        if (NutsUtilStrings.isBlank((CharSequence)this.groupId)) {
            return NutsUtilStrings.trim((String)this.artifactId);
        }
        return NutsUtilStrings.trim((String)this.groupId) + ":" + NutsUtilStrings.trim((String)this.artifactId);
    }

    public NutsVersion getVersion() {
        return this.version;
    }

    public NutsId[] getExclusions() {
        return this.exclusions == null ? new NutsId[]{} : Arrays.copyOf(this.exclusions, this.exclusions.length);
    }

    public NutsDependency build() {
        return new DefaultNutsDependency(this.getRepository(), this.getGroupId(), this.getArtifactId(), this.getClassifier(), this.getVersion(), this.getScope(), this.getOptional(), this.getExclusions(), this.getOs(), this.getArch(), this.getType(), this.getPropertiesQuery(), this.session);
    }

    public NutsDependencyBuilder setProperty(String property, String value) {
        this.propertiesQuery.setProperty(property, value);
        return this;
    }

    public NutsDependencyBuilder setProperties(Map<String, String> queryMap) {
        this.propertiesQuery.setProperties(queryMap);
        return this;
    }

    public NutsDependencyBuilder addProperties(Map<String, String> queryMap) {
        this.propertiesQuery.addProperties(queryMap);
        return this;
    }

    public NutsDependencyBuilder setProperties(String propertiesQuery) {
        this.propertiesQuery.setProperties(propertiesQuery);
        return this;
    }

    public NutsDependencyBuilder addProperties(String propertiesQuery) {
        this.propertiesQuery.addProperties(propertiesQuery);
        return this;
    }

    public String getPropertiesQuery() {
        return this.propertiesQuery.getPropertiesQuery();
    }

    public Map<String, String> getProperties() {
        return this.propertiesQuery.getProperties();
    }

    public NutsDependencyBuilder setExclusions(String exclusions) {
        if (exclusions == null) {
            exclusions = "";
        }
        ArrayList<NutsId> ids = new ArrayList<NutsId>();
        NutsIdParser parser = this.session.getWorkspace().id().parser();
        for (String s : exclusions.split("[;,]")) {
            NutsId ii = parser.parse(s.trim());
            if (ii == null) continue;
            ids.add(ii);
        }
        this.setExclusions(ids.toArray(new NutsId[0]));
        return this;
    }

    public String toString() {
        return this.build().toString();
    }
}

