/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyBuilder;
import net.thevpc.nuts.NutsDependencyFormat;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.runtime.bundles.parsers.QueryStringParser;
import net.thevpc.nuts.runtime.core.model.DefaultNutsDependencyBuilder;
import net.thevpc.nuts.runtime.standalone.util.NutsDependencyScopes;

public class DefaultNutsDependency
implements NutsDependency {
    public static final long serialVersionUID = 1L;
    private final String repository;
    private final String groupId;
    private final String artifactId;
    private final NutsVersion version;
    private final String scope;
    private final String classifier;
    private final String optional;
    private final String type;
    private final String os;
    private final String arch;
    private final NutsId[] exclusions;
    private final String properties;
    private final transient NutsSession session;

    public DefaultNutsDependency(String repository, String groupId, String artifactId, String classifier, NutsVersion version, String scope, String optional, NutsId[] exclusions, String os, String arch, String type, Map<String, String> properties, NutsSession ws) {
        this(repository, groupId, artifactId, classifier, version, scope, optional, exclusions, os, arch, type, QueryStringParser.formatSortedPropertiesQuery(properties), ws);
    }

    public DefaultNutsDependency(String repository, String groupId, String artifactId, String classifier, NutsVersion version, String scope, String optional, NutsId[] exclusions, String os, String arch, String type, String properties, NutsSession session) {
        this.repository = NutsUtilStrings.trimToNull((String)repository);
        this.groupId = NutsUtilStrings.trimToNull((String)groupId);
        this.artifactId = NutsUtilStrings.trimToNull((String)artifactId);
        this.version = version == null ? session.getWorkspace().version().parser().parse("") : version;
        this.classifier = NutsUtilStrings.trimToNull((String)classifier);
        this.scope = NutsDependencyScopes.normalizeScope(scope);
        String o = NutsUtilStrings.trimToNull((String)optional);
        if ("false".equalsIgnoreCase(o)) {
            o = null;
        } else if ("true".equalsIgnoreCase(o)) {
            o = "true";
        }
        this.optional = o;
        this.exclusions = exclusions == null ? new NutsId[]{} : Arrays.copyOf(exclusions, exclusions.length);
        for (NutsId exclusion : exclusions) {
            if (exclusion != null) continue;
            throw new NullPointerException();
        }
        this.os = NutsUtilStrings.trimToNull((String)os);
        this.arch = NutsUtilStrings.trimToNull((String)arch);
        this.type = NutsUtilStrings.trimToNull((String)type);
        this.properties = QueryStringParser.formatSortedPropertiesQuery(properties);
        this.session = session;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean isOptional() {
        String o = this.getOptional();
        return o != null && Boolean.parseBoolean(o);
    }

    public String getOptional() {
        return this.optional;
    }

    public String getScope() {
        return this.scope;
    }

    public String getType() {
        return this.type;
    }

    public NutsId toId() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (!NutsDependencyScopes.isDefaultScope(this.scope)) {
            m.put("scope", this.scope);
        }
        if (!NutsUtilStrings.isBlank((CharSequence)this.optional) && !"false".equals(this.optional)) {
            m.put("optional", this.optional);
        }
        if (!NutsUtilStrings.isBlank((CharSequence)this.classifier)) {
            m.put("classifier", this.classifier);
        }
        if (!NutsUtilStrings.isBlank((CharSequence)this.type)) {
            m.put("type", this.type);
        }
        if (!NutsUtilStrings.isBlank((CharSequence)this.repository)) {
            m.put("repo", this.repository);
        }
        if (this.exclusions.length > 0) {
            TreeSet<String> ex = new TreeSet<String>();
            for (NutsId exclusion : this.exclusions) {
                ex.add(exclusion.getShortName());
            }
            m.put("exclusions", String.join((CharSequence)",", ex));
        }
        return this.session.getWorkspace().id().builder().setGroupId(this.getGroupId()).setArtifactId(this.getArtifactId()).setVersion(this.getVersion()).setOs(this.getOs()).setArch(this.getArch()).setProperties(m).build();
    }

    public String getOs() {
        return this.os;
    }

    public String getArch() {
        return this.arch;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getSimpleName() {
        if (NutsUtilStrings.isBlank((CharSequence)this.groupId)) {
            return NutsUtilStrings.trim((String)this.artifactId);
        }
        return NutsUtilStrings.trim((String)this.groupId) + ":" + NutsUtilStrings.trim((String)this.artifactId);
    }

    public String getLongName() {
        String s = this.getSimpleName();
        NutsVersion v = this.getVersion();
        if (v.isBlank()) {
            return s;
        }
        return s + "#" + v;
    }

    public String getFullName() {
        return this.toString();
    }

    public NutsVersion getVersion() {
        return this.version;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!NutsUtilStrings.isBlank((CharSequence)this.groupId)) {
            sb.append(this.groupId).append(":");
        }
        sb.append(this.artifactId);
        if (!NutsUtilStrings.isBlank((CharSequence)this.version.getValue())) {
            sb.append("#").append(this.version);
        }
        HashMap<String, String> p = new HashMap<String, String>();
        if (!NutsUtilStrings.isBlank((CharSequence)this.repository)) {
            p.put("repo", this.repository);
        }
        if (!NutsUtilStrings.isBlank((CharSequence)this.scope) && !this.scope.equals(NutsDependencyScope.API.id())) {
            p.put("scope", this.scope);
        }
        if (!NutsUtilStrings.isBlank((CharSequence)this.optional) && !this.optional.equals("false")) {
            p.put("optional", this.optional);
        }
        if (!NutsUtilStrings.isBlank((CharSequence)this.type)) {
            p.put("type", this.type);
        }
        if (!NutsUtilStrings.isBlank((CharSequence)this.os)) {
            p.put("os", this.os);
        }
        if (!NutsUtilStrings.isBlank((CharSequence)this.arch)) {
            p.put("arch", this.arch);
        }
        if (this.exclusions.length > 0) {
            p.put("exclusions", Arrays.stream(this.exclusions).map(NutsId::getShortName).collect(Collectors.joining(",")));
        }
        if (!p.isEmpty()) {
            sb.append("?");
            sb.append(QueryStringParser.formatPropertiesQuery(p));
        }
        return sb.toString();
    }

    public NutsId[] getExclusions() {
        return Arrays.copyOf(this.exclusions, this.exclusions.length);
    }

    public NutsDependencyBuilder builder() {
        return new DefaultNutsDependencyBuilder(this.session).set(this);
    }

    public String getPropertiesQuery() {
        return this.properties;
    }

    public Map<String, String> getProperties() {
        return QueryStringParser.parseMap(this.properties);
    }

    public NutsDependencyFormat formatter() {
        return this.session.getWorkspace().dependency().formatter().setValue((NutsDependency)this);
    }
}

