/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.model;

import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependencies;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsElementNotFoundException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdType;
import net.thevpc.nuts.NutsInstallInformation;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;

public class DefaultNutsDefinition
implements NutsDefinition {
    private NutsId id;
    private NutsDescriptor descriptor;
    private String repositoryUuid;
    private String repositoryName;
    private NutsContent content;
    private NutsInstallInformation installInformation;
    private NutsDependencies dependencies;
    private NutsDescriptor effectiveDescriptor;
    private NutsIdType type;
    private NutsId apiId = null;
    private transient NutsSession session;

    public DefaultNutsDefinition() {
    }

    public DefaultNutsDefinition(String repoUuid, String repoName, NutsId id, NutsDescriptor descriptor, NutsContent content, NutsInstallInformation install, NutsIdType type, NutsId apiId, NutsSession session) {
        this.descriptor = descriptor;
        this.content = content;
        this.id = id;
        this.installInformation = install;
        this.repositoryUuid = repoUuid;
        this.repositoryName = repoName;
        this.type = type == null ? NutsIdType.REGULAR : type;
        this.apiId = apiId;
        this.session = session;
    }

    public DefaultNutsDefinition(NutsDefinition other, NutsSession session) {
        if (other != null) {
            this.descriptor = other.getDescriptor();
            this.id = other.getId();
            this.repositoryUuid = other.getRepositoryUuid();
            this.repositoryName = other.getRepositoryName();
            this.content = other.getContent();
            this.installInformation = other.getInstallInformation();
            this.effectiveDescriptor = !other.isSetEffectiveDescriptor() ? null : other.getEffectiveDescriptor();
            this.dependencies = !other.isSetDependencies() ? null : other.getDependencies();
            this.type = other.getType() == null ? NutsIdType.REGULAR : other.getType();
            this.apiId = other.getApiId();
        }
        this.session = session;
    }

    public NutsIdType getType() {
        return this.type;
    }

    public boolean isSetDependencies() {
        return this.dependencies != null;
    }

    public boolean isSetEffectiveDescriptor() {
        return this.effectiveDescriptor != null;
    }

    public String getRepositoryUuid() {
        return this.repositoryUuid;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public DefaultNutsDefinition setId(NutsId id) {
        this.id = id;
        return this;
    }

    public NutsId getId() {
        return this.id;
    }

    public boolean isTemporary() {
        return this.content != null && this.content.isTemporary();
    }

    public NutsDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return "Definition{ id=" + this.id + ", content=" + this.content + '}';
    }

    public DefaultNutsDefinition copy() {
        return new DefaultNutsDefinition(this, this.session);
    }

    public Path getPath() {
        NutsContent c = this.getContent();
        return c == null ? null : c.getFilePath();
    }

    public NutsPath getLocation() {
        NutsContent c = this.getContent();
        return c == null ? null : c.getLocation();
    }

    public URL getURL() {
        Path p = this.getPath();
        if (p != null) {
            try {
                return p.toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException(e);
            }
        }
        return null;
    }

    public NutsContent getContent() {
        return this.content;
    }

    public NutsDescriptor getEffectiveDescriptor() {
        if (!this.isSetEffectiveDescriptor()) {
            throw new NutsElementNotFoundException(this.session, NutsMessage.cstyle((String)"unable to get effectiveDescriptor. You need to call search.setEffective(...) first.", (Object[])new Object[0]));
        }
        return this.effectiveDescriptor;
    }

    public NutsInstallInformation getInstallInformation() {
        return this.installInformation;
    }

    public NutsDependencies getDependencies() {
        if (!this.isSetDependencies()) {
            throw new NutsElementNotFoundException(this.session, NutsMessage.cstyle((String)"unable to get dependencies. You need to call search.setDependencies(...) first.", (Object[])new Object[0]));
        }
        return this.dependencies;
    }

    public DefaultNutsDefinition setContent(NutsContent content) {
        this.content = content;
        return this;
    }

    public DefaultNutsDefinition setDescriptor(NutsDescriptor descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    public int compareTo(NutsDefinition n2) {
        if (n2 == null) {
            return 1;
        }
        if (!(n2 instanceof DefaultNutsDefinition)) {
            return -1;
        }
        NutsId o1 = this.getId();
        NutsId o2 = n2.getId();
        if (o1 == null || o2 == null) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            return 1;
        }
        return o1.compareTo((Object)o2);
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNutsDefinition other = (DefaultNutsDefinition)obj;
        return Objects.equals(this.id, other.id);
    }

    public DefaultNutsDefinition setEffectiveDescriptor(NutsDescriptor effectiveDescriptor) {
        this.effectiveDescriptor = effectiveDescriptor;
        return this;
    }

    public DefaultNutsDefinition setInstallInformation(NutsInstallInformation install) {
        this.installInformation = install;
        return this;
    }

    public DefaultNutsDefinition setDependencies(NutsDependencies dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public NutsId getApiId() {
        return this.apiId;
    }

    public DefaultNutsDefinition setRepositoryUuid(String repositoryUuid) {
        this.repositoryUuid = repositoryUuid;
        return this;
    }

    public DefaultNutsDefinition setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
        return this;
    }
}

