/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.model;

import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import net.thevpc.nuts.NutsCommandlineFamily;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsLogConfig;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.NutsWorkspaceOptionsBuilder;
import net.thevpc.nuts.NutsWorkspaceOptionsFormat;
import net.thevpc.nuts.runtime.core.app.CoreNutsArgumentsParser;
import net.thevpc.nuts.runtime.core.format.CoreNutsWorkspaceOptionsFormat;

public final class CoreNutsWorkspaceOptions
implements Serializable,
Cloneable,
NutsWorkspaceOptionsBuilder,
NutsWorkspaceOptions {
    private static final long serialVersionUID = 1L;
    private final List<String> outputFormatOptions = new ArrayList<String>();
    private String[] properties;
    private String apiVersion = null;
    private String runtimeId;
    private String javaCommand;
    private String javaOptions;
    private String workspace = null;
    private String outLinePrefix = null;
    private String errLinePrefix = null;
    private String name = null;
    private Boolean skipCompanions;
    private Boolean skipWelcome;
    private Boolean skipBoot;
    private Boolean global;
    private Boolean gui;
    private String[] excludedExtensions;
    private String[] repositories;
    private String userName = null;
    private char[] credentials = null;
    private NutsTerminalMode terminalMode = null;
    private Boolean readOnly;
    private Boolean trace;
    private String progressOptions = null;
    private NutsLogConfig logConfig;
    private NutsConfirmationMode confirm = null;
    private NutsContentType outputFormat = null;
    private String[] applicationArguments;
    private NutsOpenMode openMode = NutsOpenMode.OPEN_OR_CREATE;
    private long creationTime;
    private Boolean dry;
    private Supplier<ClassLoader> classLoaderSupplier;
    private String[] executorOptions;
    private Boolean recover;
    private Boolean reset;
    private Boolean debug;
    private Boolean inherited;
    private NutsExecutionType executionType;
    private NutsRunAs runAs = NutsRunAs.CURRENT_USER;
    private String archetype;
    private Boolean switchWorkspace;
    private Map<String, String> storeLocations = new HashMap<String, String>();
    private Map<String, String> homeLocations = new HashMap<String, String>();
    private NutsOsFamily storeLocationLayout = null;
    private NutsStoreLocationStrategy storeLocationStrategy = null;
    private NutsStoreLocationStrategy repositoryStoreLocationStrategy = null;
    private NutsFetchStrategy fetchStrategy = NutsFetchStrategy.ONLINE;
    private Boolean cached;
    private Boolean indexed;
    private Boolean transitive;
    private Boolean bot;
    private InputStream stdin = null;
    private PrintStream stdout = null;
    private PrintStream stderr = null;
    private ExecutorService executorService = null;
    private Instant expireTime = null;
    private NutsMessage[] errors = new NutsMessage[0];
    private Boolean skipErrors;
    private String locale;
    private String theme;
    private NutsSession session;

    public CoreNutsWorkspaceOptions(NutsSession session) {
        this.session = session;
    }

    public static String createHomeLocationKey(NutsOsFamily storeLocationLayout, NutsStoreLocation location) {
        return (storeLocationLayout == null ? "system" : storeLocationLayout.id()) + ":" + (location == null ? "system" : location.id());
    }

    public NutsWorkspaceOptionsBuilder setAll(NutsWorkspaceOptions other) {
        this.setApiVersion(other.getApiVersion());
        this.setRuntimeId(other.getRuntimeId());
        this.setJavaCommand(other.getJavaCommand());
        this.setJavaOptions(other.getJavaOptions());
        this.setWorkspace(other.getWorkspace());
        this.setName(other.getName());
        this.setSkipCompanions(other.getSkipCompanions());
        this.setSkipWelcome(other.getSkipWelcome());
        this.setSkipBoot(other.getSkipBoot());
        this.setGlobal(other.getGlobal());
        this.setGui(other.getGui());
        this.setUsername(other.getUserName());
        this.setCredentials(other.getCredentials());
        this.setTerminalMode(other.getTerminalMode());
        this.setReadOnly(other.getReadOnly());
        this.setTrace(other.getTrace());
        this.setProgressOptions(other.getProgressOptions());
        this.setLogConfig(other.getLogConfig() == null ? null : new NutsLogConfig(other.getLogConfig()));
        this.setConfirm(other.getConfirm());
        this.setConfirm(other.getConfirm());
        this.setOutputFormat(other.getOutputFormat());
        this.setOutputFormatOptions(other.getOutputFormatOptions());
        this.setOpenMode(other.getOpenMode());
        this.setCreationTime(other.getCreationTime());
        this.setDry(other.getDry());
        this.setClassLoaderSupplier(other.getClassLoaderSupplier());
        this.setExecutorOptions(other.getExecutorOptions());
        this.setRecover(other.getRecover());
        this.setReset(other.getReset());
        this.setDebug(other.getDebug());
        this.setInherited(other.getInherited());
        this.setExecutionType(other.getExecutionType());
        this.setRunAs(other.getRunAs());
        this.setArchetype(other.getArchetype());
        this.setStoreLocationStrategy(other.getStoreLocationStrategy());
        this.setHomeLocations(other.getHomeLocations());
        this.setStoreLocations(other.getStoreLocations());
        this.setStoreLocationLayout(other.getStoreLocationLayout());
        this.setStoreLocationStrategy(other.getStoreLocationStrategy());
        this.setRepositoryStoreLocationStrategy(other.getRepositoryStoreLocationStrategy());
        this.setFetchStrategy(other.getFetchStrategy());
        this.setCached(other.getCached());
        this.setIndexed(other.getIndexed());
        this.setTransitive(other.getTransitive());
        this.setBot(other.getBot());
        this.setStdin(other.getStdin());
        this.setStdout(other.getStdout());
        this.setStderr(other.getStderr());
        this.setExecutorService(other.getExecutorService());
        this.setExcludedExtensions(other.getExcludedExtensions() == null ? null : Arrays.copyOf(other.getExcludedExtensions(), other.getExcludedExtensions().length));
        this.setRepositories(other.getRepositories() == null ? null : Arrays.copyOf(other.getRepositories(), other.getRepositories().length));
        this.setApplicationArguments(other.getApplicationArguments() == null ? null : Arrays.copyOf(other.getApplicationArguments(), other.getApplicationArguments().length));
        this.setProperties(other.getProperties() == null ? null : Arrays.copyOf(other.getProperties(), other.getProperties().length));
        this.setExpireTime(other.getExpireTime());
        this.setErrors(other.getErrors());
        this.setSkipErrors(other.getSkipErrors());
        this.setSwitchWorkspace(other.getSwitchWorkspace());
        this.setLocale(other.getLocale());
        this.setTheme(other.getTheme());
        return this;
    }

    public NutsWorkspaceOptionsBuilder parseCommandLine(String commandLine) {
        return this.parseArguments(this.session.getWorkspace().commandLine().setCommandlineFamily(NutsCommandlineFamily.BASH).parse(commandLine).toStringArray());
    }

    public NutsWorkspaceOptionsBuilder parseArguments(String[] args) {
        CoreNutsArgumentsParser.parseNutsArguments(this.session, args, this);
        return this;
    }

    public NutsWorkspaceOptionsBuilder setWorkspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setName(String workspaceName) {
        this.name = workspaceName;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setGlobal(Boolean global) {
        this.global = global;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setGui(Boolean gui) {
        this.gui = gui;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setArchetype(String archetype) {
        this.archetype = archetype;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setExcludedExtensions(String[] excludedExtensions) {
        this.excludedExtensions = excludedExtensions;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setUsername(String username) {
        this.userName = username;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setCredentials(char[] credentials) {
        this.credentials = credentials;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setExecutionType(NutsExecutionType executionType) {
        this.executionType = executionType;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setRunAs(NutsRunAs runAs) {
        this.runAs = runAs == null ? NutsRunAs.CURRENT_USER : runAs;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setInherited(Boolean inherited) {
        this.inherited = inherited;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setTerminalMode(NutsTerminalMode terminalMode) {
        this.terminalMode = terminalMode;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setSkipErrors(Boolean value) {
        this.skipErrors = value;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setSwitchWorkspace(Boolean switchWorkspace) {
        this.switchWorkspace = switchWorkspace;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setErrors(NutsMessage[] errors) {
        this.errors = errors == null ? new NutsMessage[]{} : Arrays.copyOf(errors, errors.length);
        return this;
    }

    public NutsWorkspaceOptionsBuilder setDry(Boolean dry) {
        this.dry = dry;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setCreationTime(long creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setTrace(Boolean trace) {
        this.trace = trace;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setProgressOptions(String progressOptions) {
        this.progressOptions = progressOptions;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setRuntimeId(String runtimeId) {
        this.runtimeId = runtimeId;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setClassLoaderSupplier(Supplier<ClassLoader> provider) {
        this.classLoaderSupplier = provider;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setApplicationArguments(String[] applicationArguments) {
        this.applicationArguments = applicationArguments;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setJavaCommand(String javaCommand) {
        this.javaCommand = javaCommand;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setJavaOptions(String javaOptions) {
        this.javaOptions = javaOptions;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setExecutorOptions(String[] executorOptions) {
        this.executorOptions = executorOptions;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setRecover(Boolean recover) {
        this.recover = recover;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setReset(Boolean reset) {
        this.reset = reset;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setDebug(Boolean debug) {
        this.debug = debug;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setRepositories(String[] repositories) {
        this.repositories = repositories;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setLogConfig(NutsLogConfig logConfig) {
        this.logConfig = logConfig;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setStoreLocationLayout(NutsOsFamily storeLocationLayout) {
        this.storeLocationLayout = storeLocationLayout;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setStoreLocationStrategy(NutsStoreLocationStrategy storeLocationStrategy) {
        this.storeLocationStrategy = storeLocationStrategy;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setRepositoryStoreLocationStrategy(NutsStoreLocationStrategy repositoryStoreLocationStrategy) {
        this.repositoryStoreLocationStrategy = repositoryStoreLocationStrategy;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setStoreLocation(NutsStoreLocation location, String value) {
        if (NutsUtilStrings.isBlank((CharSequence)value)) {
            this.storeLocations.remove(location.id());
        } else {
            this.storeLocations.put(location.id(), value);
        }
        return this;
    }

    public NutsWorkspaceOptionsBuilder setHomeLocation(NutsOsFamily layout, NutsStoreLocation location, String value) {
        String key = CoreNutsWorkspaceOptions.createHomeLocationKey(layout, location);
        if (NutsUtilStrings.isBlank((CharSequence)value)) {
            this.homeLocations.remove(key);
        } else {
            this.homeLocations.put(key, value);
        }
        return this;
    }

    public NutsWorkspaceOptionsBuilder setSkipCompanions(Boolean skipInstallCompanions) {
        this.skipCompanions = skipInstallCompanions;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setSkipBoot(Boolean skipBoot) {
        this.skipBoot = skipBoot;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setSkipWelcome(Boolean skipWelcome) {
        this.skipWelcome = skipWelcome;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setOpenMode(NutsOpenMode openMode) {
        this.openMode = openMode;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setConfirm(NutsConfirmationMode confirm) {
        this.confirm = confirm;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setOutputFormat(NutsContentType outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    public NutsWorkspaceOptionsBuilder addOutputFormatOptions(String ... options) {
        if (options != null) {
            for (String option : options) {
                if (option == null || (option = NutsUtilStrings.trim((String)option)).isEmpty()) continue;
                this.outputFormatOptions.add(option);
            }
        }
        return this;
    }

    public NutsWorkspaceOptionsBuilder setOutputFormatOptions(String ... options) {
        this.outputFormatOptions.clear();
        return this.addOutputFormatOptions(options);
    }

    public NutsWorkspaceOptionsBuilder setFetchStrategy(NutsFetchStrategy fetchStrategy) {
        this.fetchStrategy = fetchStrategy == null ? NutsFetchStrategy.ONLINE : fetchStrategy;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setCached(Boolean cached) {
        this.cached = cached;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setIndexed(Boolean indexed) {
        this.indexed = indexed;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setTransitive(Boolean transitive) {
        this.transitive = transitive;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setBot(Boolean bot) {
        this.bot = bot;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setStdin(InputStream stdin) {
        this.stdin = stdin;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setStdout(PrintStream stdout) {
        this.stdout = stdout;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setStderr(PrintStream stderr) {
        this.stderr = stderr;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public NutsWorkspaceOptionsBuilder setHomeLocations(Map<String, String> homeLocations) {
        this.homeLocations.clear();
        if (homeLocations != null) {
            this.homeLocations.putAll(homeLocations);
        }
        return this;
    }

    public NutsWorkspaceOptionsBuilder setStoreLocations(Map<String, String> storeLocations) {
        this.storeLocations.clear();
        if (storeLocations != null) {
            this.storeLocations.putAll(storeLocations);
        }
        return this;
    }

    public NutsWorkspaceOptionsBuilder setExpireTime(Instant expireTime) {
        this.expireTime = expireTime;
        return this;
    }

    public NutsWorkspaceOptionsBuilder copy() {
        try {
            CoreNutsWorkspaceOptions t = (CoreNutsWorkspaceOptions)this.clone();
            t.logConfig = this.logConfig == null ? null : t.logConfig;
            t.storeLocations = new LinkedHashMap<String, String>(this.storeLocations);
            t.homeLocations = new LinkedHashMap<String, String>(this.homeLocations);
            t.setExcludedExtensions(t.getExcludedExtensions() == null ? null : Arrays.copyOf(t.getExcludedExtensions(), t.getExcludedExtensions().length));
            t.setRepositories(t.getRepositories() == null ? null : Arrays.copyOf(t.getRepositories(), t.getRepositories().length));
            t.setApplicationArguments(t.getApplicationArguments() == null ? null : Arrays.copyOf(t.getApplicationArguments(), t.getApplicationArguments().length));
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("should never Happen", e);
        }
    }

    public NutsWorkspaceOptionsFormat formatter() {
        return new CoreNutsWorkspaceOptionsFormat(this.session, this);
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String[] getApplicationArguments() {
        return this.applicationArguments == null ? new String[]{} : Arrays.copyOf(this.applicationArguments, this.applicationArguments.length);
    }

    public String getArchetype() {
        return this.archetype;
    }

    public Supplier<ClassLoader> getClassLoaderSupplier() {
        return this.classLoaderSupplier;
    }

    public NutsConfirmationMode getConfirm() {
        return this.confirm;
    }

    public boolean isDry() {
        return this.dry != null && this.dry != false;
    }

    public Boolean getDry() {
        return this.dry;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String[] getExcludedExtensions() {
        return this.excludedExtensions;
    }

    public NutsExecutionType getExecutionType() {
        return this.executionType;
    }

    public NutsRunAs getRunAs() {
        return this.runAs;
    }

    public String[] getExecutorOptions() {
        return this.executorOptions == null ? new String[]{} : this.executorOptions;
    }

    public String getHomeLocation(NutsOsFamily layout, NutsStoreLocation location) {
        String key = CoreNutsWorkspaceOptions.createHomeLocationKey(layout, location);
        return this.homeLocations.get(key);
    }

    public Map<String, String> getHomeLocations() {
        return new LinkedHashMap<String, String>(this.homeLocations);
    }

    public String getJavaCommand() {
        return this.javaCommand;
    }

    public String getJavaOptions() {
        return this.javaOptions;
    }

    public NutsLogConfig getLogConfig() {
        return this.logConfig;
    }

    public String getName() {
        return this.name;
    }

    public NutsOpenMode getOpenMode() {
        return this.openMode;
    }

    public NutsContentType getOutputFormat() {
        return this.outputFormat;
    }

    public String[] getOutputFormatOptions() {
        return this.outputFormatOptions.toArray(new String[0]);
    }

    public char[] getCredentials() {
        return this.credentials;
    }

    public NutsStoreLocationStrategy getRepositoryStoreLocationStrategy() {
        return this.repositoryStoreLocationStrategy;
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public String getStoreLocation(NutsStoreLocation folder) {
        return this.storeLocations.get(folder.id());
    }

    public NutsOsFamily getStoreLocationLayout() {
        return this.storeLocationLayout;
    }

    public NutsStoreLocationStrategy getStoreLocationStrategy() {
        return this.storeLocationStrategy;
    }

    public Map<String, String> getStoreLocations() {
        return new LinkedHashMap<String, String>(this.storeLocations);
    }

    public NutsTerminalMode getTerminalMode() {
        return this.terminalMode;
    }

    public String[] getRepositories() {
        return this.repositories == null ? new String[]{} : this.repositories;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public boolean isDebug() {
        return this.debug != null && this.debug != false;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public boolean isGlobal() {
        return this.global != null && this.global != false;
    }

    public Boolean getGlobal() {
        return this.global;
    }

    public boolean isGui() {
        return this.gui != null && this.gui != false;
    }

    public Boolean getGui() {
        return this.gui;
    }

    public boolean isInherited() {
        return this.inherited != null && this.inherited != false;
    }

    public Boolean getInherited() {
        return this.inherited;
    }

    public boolean isReadOnly() {
        return this.readOnly != null && this.readOnly != false;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public boolean isRecover() {
        return this.recover != null && this.recover != false;
    }

    public Boolean getRecover() {
        return this.recover;
    }

    public boolean isReset() {
        return this.reset != null && this.reset != false;
    }

    public Boolean getReset() {
        return this.reset;
    }

    public boolean isSkipCompanions() {
        return this.skipCompanions != null && this.skipCompanions != false;
    }

    public Boolean getSkipCompanions() {
        return this.skipCompanions;
    }

    public boolean isSkipWelcome() {
        return this.skipWelcome != null && this.skipWelcome != false;
    }

    public Boolean getSkipWelcome() {
        return this.skipWelcome;
    }

    public String getOutLinePrefix() {
        return this.outLinePrefix;
    }

    public NutsWorkspaceOptionsBuilder setOutLinePrefix(String outLinePrefix) {
        this.outLinePrefix = outLinePrefix;
        return this;
    }

    public String getErrLinePrefix() {
        return this.errLinePrefix;
    }

    public boolean isSkipBoot() {
        return this.skipBoot != null && this.skipBoot != false;
    }

    public Boolean getSkipBoot() {
        return this.skipBoot;
    }

    public boolean isTrace() {
        return this.trace == null || this.trace != false;
    }

    public Boolean getTrace() {
        return this.trace;
    }

    public String getProgressOptions() {
        return this.progressOptions;
    }

    public boolean isCached() {
        return this.cached == null || this.cached != false;
    }

    public Boolean getCached() {
        return this.cached;
    }

    public boolean isIndexed() {
        return this.indexed == null || this.indexed != false;
    }

    public Boolean getIndexed() {
        return this.indexed;
    }

    public boolean isTransitive() {
        return this.transitive == null || this.transitive != false;
    }

    public Boolean getTransitive() {
        return this.transitive;
    }

    public boolean isBot() {
        return this.bot != null && this.bot != false;
    }

    public Boolean getBot() {
        return this.bot;
    }

    public NutsFetchStrategy getFetchStrategy() {
        return this.fetchStrategy;
    }

    public InputStream getStdin() {
        return this.stdin;
    }

    public PrintStream getStdout() {
        return this.stdout;
    }

    public PrintStream getStderr() {
        return this.stderr;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public Instant getExpireTime() {
        return this.expireTime;
    }

    public boolean isSkipErrors() {
        return this.skipErrors != null && this.skipErrors != false;
    }

    public Boolean getSkipErrors() {
        return this.skipErrors;
    }

    public boolean isSwitchWorkspace() {
        return this.switchWorkspace != null && this.switchWorkspace != false;
    }

    public Boolean getSwitchWorkspace() {
        return this.switchWorkspace;
    }

    public NutsMessage[] getErrors() {
        return Arrays.copyOf(this.errors, this.errors.length);
    }

    public NutsWorkspaceOptionsBuilder setErrLinePrefix(String errLinePrefix) {
        this.errLinePrefix = errLinePrefix;
        return this;
    }

    public String toString() {
        return this.formatter().getBootCommandLine().toString();
    }

    public String[] getProperties() {
        return this.properties == null ? new String[]{} : this.properties;
    }

    public NutsWorkspaceOptionsBuilder setProperties(String[] properties) {
        this.properties = properties;
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public NutsWorkspaceOptionsBuilder setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public String getTheme() {
        return this.theme;
    }

    public NutsWorkspaceOptionsBuilder setTheme(String theme) {
        this.theme = theme;
        return this;
    }

    public void setSession(NutsSession session) {
        this.session = session;
    }

    public NutsWorkspaceOptions build() {
        CoreNutsWorkspaceOptions c = new CoreNutsWorkspaceOptions(this.session);
        c.setAll(this);
        return c;
    }

    public NutsWorkspaceOptionsBuilder builder() {
        return new CoreNutsWorkspaceOptions(this.session).setAll(this);
    }
}

