/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextFormatStyle;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.AbstractNutsWorkspace;
import net.thevpc.nuts.runtime.core.log.NutsLogRecord;

public class NutsLogUtils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Map<Level, String> logLevelCache = new HashMap<Level, String>();
    private static final Map<String, String> logVerbCache = new HashMap<String, String>();
    private static final Map<String, String> classNameCache = new HashMap<String, String>();

    public static NutsLogRecord toNutsLogRecord(LogRecord record, NutsSession session) {
        Level lvl;
        if (record instanceof NutsLogRecord) {
            return (NutsLogRecord)record;
        }
        NutsLogRecord h = new NutsLogRecord(session, lvl, (lvl = record.getLevel()).intValue() <= Level.SEVERE.intValue() ? NutsLogVerb.FAIL : (lvl.intValue() <= Level.WARNING.intValue() ? NutsLogVerb.WARNING : (lvl.intValue() <= Level.INFO.intValue() ? NutsLogVerb.INFO : (lvl.intValue() <= Level.FINE.intValue() ? NutsLogVerb.DEBUG : NutsLogVerb.DEBUG))), record.getMessage(), record.getParameters(), true, record.getMillis(), NutsTextFormatStyle.JSTYLE);
        h.setResourceBundle(record.getResourceBundle());
        h.setResourceBundleName(record.getResourceBundleName());
        h.setSequenceNumber(record.getSequenceNumber());
        h.setMillis(record.getMillis());
        h.setSourceClassName(record.getSourceClassName());
        h.setLoggerName(record.getLoggerName());
        h.setSourceMethodName(record.getSourceMethodName());
        h.setThreadID(record.getThreadID());
        h.setThrown(record.getThrown());
        return h;
    }

    public static String logLevel(Level l) {
        String v = logLevelCache.get(l);
        if (v == null) {
            StringBuilder sb = new StringBuilder(l.getName());
            NutsLogUtils.ensureSize(sb, 6);
            v = sb.toString();
            logLevelCache.put(l, v);
        }
        return v;
    }

    public static String logVerb(String l) {
        String v;
        if (l == null) {
            l = "";
        }
        if ((v = logVerbCache.get(l)) == null) {
            StringBuilder sb = new StringBuilder(7);
            sb.append(l);
            NutsLogUtils.ensureSize(sb, 7);
            v = sb.toString();
            logVerbCache.put(l, v);
        }
        return v;
    }

    public static void ensureSize(StringBuilder sb, int size) {
        sb.ensureCapacity(size);
        int length = size - sb.length();
        while (length > 0) {
            if (length >= 16) {
                sb.append("                ");
                length -= 16;
                continue;
            }
            if (length >= 8) {
                sb.append("        ");
                length -= 8;
                continue;
            }
            if (length >= 4) {
                sb.append("    ");
                length -= 4;
                continue;
            }
            if (length >= 2) {
                sb.append("  ");
                length -= 2;
                continue;
            }
            sb.append(' ');
            --length;
        }
    }

    public static String formatClassName(String className) {
        if (className == null) {
            return "";
        }
        String v = classNameCache.get(className);
        if (v == null) {
            int end;
            int maxSize = 47;
            StringBuilder sb = new StringBuilder(maxSize);
            int pos = 0;
            while ((end = className.indexOf(46, pos)) >= 0) {
                sb.append(className.charAt(pos)).append('.');
                pos = end + 1;
            }
            sb.append(className.substring(pos));
            NutsLogUtils.ensureSize(sb, maxSize);
            v = sb.toString();
            classNameCache.put(className, v);
        }
        return v;
    }

    public static String stacktrace(Throwable th) {
        try {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                th.printStackTrace(pw);
            }
            return sw.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static final NutsSession resolveSession(LogRecord record, NutsWorkspace ws) {
        NutsSession session = null;
        if (record instanceof NutsLogRecord) {
            session = ((NutsLogRecord)record).getSession();
        }
        if (session == null) {
            session = ((AbstractNutsWorkspace)ws).defaultSession();
        }
        return session;
    }

    public static final NutsSession resolveSession(LogRecord record, NutsSession defSession) {
        NutsSession session = null;
        if (record instanceof NutsLogRecord) {
            session = ((NutsLogRecord)record).getSession();
        }
        if (session == null) {
            session = defSession;
        }
        return session;
    }
}

