/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.log;

import java.util.function.Supplier;
import java.util.logging.Level;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextFormatStyle;
import net.thevpc.nuts.runtime.core.log.DefaultNutsLogger;
import net.thevpc.nuts.runtime.core.log.NutsLogRecord;

public class DefaultNutsLoggerOp
implements NutsLoggerOp {
    public static final Object[] OBJECTS0 = new Object[0];
    private NutsSession session;
    private DefaultNutsLogger logger;
    private Level level = Level.FINE;
    private NutsLogVerb verb;
    private String msg;
    private long time;
    private boolean formatted = true;
    private Supplier<String> msgSupplier;
    private Throwable error;
    private NutsTextFormatStyle style = NutsTextFormatStyle.JSTYLE;
    private Object[] params = OBJECTS0;

    public DefaultNutsLoggerOp(DefaultNutsLogger logger) {
        this.logger = logger;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsLoggerOp session(NutsSession session) {
        this.session = session;
        return this;
    }

    public NutsLoggerOp formatted(boolean value) {
        this.formatted = value;
        return this;
    }

    public NutsLoggerOp formatted() {
        this.formatted = true;
        return this;
    }

    public NutsLoggerOp verb(NutsLogVerb verb) {
        this.verb = verb;
        return this;
    }

    public NutsLoggerOp level(Level level) {
        this.level = level == null ? Level.FINE : level;
        return this;
    }

    public NutsLoggerOp error(Throwable error) {
        this.error = error;
        return this;
    }

    public void log(String msg, Object ... params) {
        this.msg = msg;
        this.params = params;
        this.run();
    }

    public void log(Supplier<String> msgSupplier) {
        this.msgSupplier = msgSupplier;
        this.run();
    }

    public NutsLoggerOp time(long time) {
        this.time = time;
        return this;
    }

    public NutsLoggerOp style(NutsTextFormatStyle style) {
        this.style = style == null ? NutsTextFormatStyle.JSTYLE : style;
        return this;
    }

    private void run() {
        if (this.logger.isLoggable(this.level)) {
            NutsSession s;
            String m = this.msg;
            if (this.msgSupplier != null) {
                m = this.msgSupplier.get();
            }
            if ((s = this.session) == null) {
                s = this.logger.getSession();
            }
            NutsLogRecord record = new NutsLogRecord(s, this.level, this.verb, m, this.params, this.formatted, this.time, this.style);
            if (this.error != null) {
                record.setThrown(this.error);
            }
            this.logger.log(record);
        }
    }
}

