/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.log;

import java.util.logging.Handler;
import java.util.logging.Level;
import net.thevpc.nuts.NutsLogManager;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.log.DefaultNutsLogModel;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsLogManager
implements NutsLogManager {
    private DefaultNutsLogModel model;
    private NutsSession session;

    public DefaultNutsLogManager(DefaultNutsLogModel model) {
        this.model = model;
    }

    public Handler[] getHandlers() {
        this.checkSession();
        return this.model.getHandlers();
    }

    public NutsLogManager removeHandler(Handler handler) {
        this.checkSession();
        this.model.removeHandler(handler);
        return this;
    }

    public NutsLogManager addHandler(Handler handler) {
        this.checkSession();
        this.model.addHandler(handler);
        return this;
    }

    public Handler getTermHandler() {
        this.checkSession();
        return this.model.getTermHandler();
    }

    public Handler getFileHandler() {
        this.checkSession();
        return this.model.getFileHandler();
    }

    public NutsLogger of(String name) {
        this.checkSession();
        return this.model.of(name, this.getSession());
    }

    public NutsLogger of(Class clazz) {
        this.checkSession();
        return this.model.of(clazz, this.getSession());
    }

    public Level getTermLevel() {
        this.checkSession();
        return this.model.getTermLevel();
    }

    public NutsLogManager setTermLevel(Level level) {
        this.checkSession();
        this.model.setTermLevel(level, this.session);
        return this;
    }

    public Level getFileLevel() {
        this.checkSession();
        return this.model.getFileLevel();
    }

    public NutsLogManager setFileLevel(Level level) {
        this.checkSession();
        this.model.setFileLevel(level, this.session);
        return this;
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsLogManager setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public DefaultNutsLogModel getModel() {
        return this.model;
    }
}

