/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;

public abstract class NutsPathInput
extends CoreIOUtils.AbstractMultiReadItem {
    public NutsPathInput(NutsPath value) {
        super(value.asString(), value.format(), value, value.isFilePath(), true, "nutsPath", value.getSession());
    }

    public NutsPath getNutsPath() {
        return (NutsPath)this.getSource();
    }

    @Override
    public Path getFilePath() {
        return this.getNutsPath().toFilePath();
    }

    @Override
    public URL getURL() {
        return this.getNutsPath().toURL();
    }

    @Override
    public void copyTo(Path path) {
        if (!Files.isRegularFile(this.getFilePath(), new LinkOption[0])) {
            throw this.createOpenError(new FileNotFoundException(this.getFilePath().toString()));
        }
        try (InputStream in = this.open();
             OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            CoreIOUtils.copy(in, os);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public long length() {
        return this.getNutsPath().getContentLength();
    }

    public String getContentType() {
        return null;
    }

    public String getContentEncoding() {
        return null;
    }

    public Instant getLastModifiedInstant() {
        return this.getNutsPath().getLastModifiedInstant();
    }

    public String toString() {
        return this.getNutsPath().toString();
    }
}

