/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.io;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsFormat;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsOutput;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.runtime.core.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.core.io.NutsPathBase;

public class NutsCompressedPath
extends NutsPathBase {
    private String compressedForm;
    private NutsString formattedCompressedForm;
    private NutsPath base;

    public NutsCompressedPath(NutsPath base) {
        super(base.getSession());
        this.base = base;
        this.compressedForm = NutsCompressedPath.compressUrl(base.toString());
        this.formattedCompressedForm = base.getSession().getWorkspace().text().forStyled(this.compressedForm, NutsTextStyle.path());
    }

    public NutsCompressedPath(NutsPath base, String compressedForm, NutsString formattedCompressedForm) {
        super(base.getSession());
        this.compressedForm = compressedForm;
        this.formattedCompressedForm = formattedCompressedForm;
        this.base = base;
    }

    public static String compressUrl(String path) {
        if (path.startsWith("http://") || path.startsWith("https://")) {
            URL u = null;
            try {
                u = new URL(path);
            }
            catch (MalformedURLException e) {
                return path;
            }
            int len = u.getProtocol().length() + 1;
            if (u.getAuthority() != null && u.getAuthority().length() > 0) {
                len += 2 + u.getAuthority().length();
            }
            if (u.getPath() != null) {
                len += u.getPath().length();
            }
            if (u.getQuery() != null) {
                len += 1 + u.getQuery().length();
            }
            if (u.getRef() != null) {
                len += 1 + u.getRef().length();
            }
            StringBuilder result = new StringBuilder(len);
            result.append(u.getProtocol());
            result.append(":");
            if (u.getAuthority() != null && u.getAuthority().length() > 0) {
                result.append("//");
                result.append(u.getAuthority());
            }
            if (u.getPath() != null) {
                result.append(NutsCompressedPath.compressPath(u.getPath(), 0, 2));
            }
            if (u.getQuery() != null) {
                result.append('?');
                result.append("...");
            }
            if (u.getRef() != null) {
                result.append("#");
                result.append("...");
            }
            return result.toString();
        }
        return NutsCompressedPath.compressPath(path);
    }

    public static String compressPath(String path) {
        return NutsCompressedPath.compressPath(path, 2, 2);
    }

    public static String compressPath(String path, int left, int right) {
        int interr;
        String p = System.getProperty("user.home");
        if ((path.startsWith("http://") || path.startsWith("https://")) && (interr = path.indexOf(63)) > 0) {
            path = path.substring(0, interr) + "?...";
        }
        if (path.startsWith(p + File.separator)) {
            path = "~" + path.substring(p.length());
        } else {
            int x;
            if (path.startsWith("http://")) {
                x = path.indexOf(47, "http://".length() + 1);
                if (x <= 0) {
                    return path;
                }
                return path.substring(0, x) + NutsCompressedPath.compressPath(path.substring(x), 0, right);
            }
            if (path.startsWith("https://")) {
                x = path.indexOf(47, "https://".length() + 1);
                if (x <= 0) {
                    return path;
                }
                return path.substring(0, x) + NutsCompressedPath.compressPath(path.substring(x), 0, right);
            }
        }
        ArrayList<String> a = new ArrayList<String>(Arrays.asList(path.split("[\\\\/]")));
        int min = left + right + 1;
        if (a.size() > 0 && ((String)a.get(0)).equals("")) {
            ++left;
            ++min;
        }
        if (a.size() > min) {
            a.add(left, "...");
            int len = a.size() - right - left - 1;
            for (int i = 0; i < len; ++i) {
                a.remove(left + 1);
            }
        }
        return String.join((CharSequence)"/", a);
    }

    public String getContentEncoding() {
        return this.base.getContentEncoding();
    }

    public String getContentType() {
        return this.base.getContentType();
    }

    public String getName() {
        return this.base.getName();
    }

    public String asString() {
        return this.base.asString();
    }

    public String getLocation() {
        return this.base.getLocation();
    }

    public NutsPath toCompressedForm() {
        return this;
    }

    public URL toURL() {
        return this.base.toURL();
    }

    public Path toFilePath() {
        return this.base.toFilePath();
    }

    public NutsInput input() {
        return this.base.input();
    }

    public NutsOutput output() {
        return this.base.output();
    }

    public void delete(boolean recurse) {
        this.base.delete(recurse);
    }

    public void mkdir(boolean parents) {
        this.base.mkdir(parents);
    }

    public boolean exists() {
        return this.base.exists();
    }

    public long getContentLength() {
        return this.base.getContentLength();
    }

    public Instant getLastModifiedInstant() {
        return this.base.getLastModifiedInstant();
    }

    public String toString() {
        return String.valueOf(this.compressedForm);
    }

    @Override
    public NutsFormat formatter() {
        return (NutsFormat)new MyPathFormat(this).setSession(this.getSession());
    }

    private static class MyPathFormat
    extends DefaultFormatBase<NutsFormat> {
        private NutsCompressedPath p;

        public MyPathFormat(NutsCompressedPath p) {
            super(p.getSession().getWorkspace(), "path");
            this.p = p;
        }

        public NutsString asFormattedString() {
            return this.p.base.getSession().getWorkspace().text().forStyled(this.p.compressedForm, NutsTextStyle.path());
        }

        @Override
        public void print(NutsPrintStream out) {
            out.print(this.asFormattedString());
        }

        public boolean configureFirst(NutsCommandLine commandLine) {
            return false;
        }
    }
}

