/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Objects;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsFormat;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOutput;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.runtime.bundles.io.FixedInputStreamMetadata;
import net.thevpc.nuts.runtime.bundles.io.InputStreamMetadataAwareImpl;
import net.thevpc.nuts.runtime.core.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.core.io.NutsCompressedPath;
import net.thevpc.nuts.runtime.core.io.NutsFormatSPIFromNutsFormat;
import net.thevpc.nuts.runtime.core.io.NutsPathBase;
import net.thevpc.nuts.runtime.core.io.NutsPathInput;
import net.thevpc.nuts.runtime.core.io.NutsPathOutput;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.spi.NutsFormatSPI;
import net.thevpc.nuts.spi.NutsPathSPI;

public class FilePath
extends NutsPathBase
implements NutsPathSPI {
    private Path value;

    public FilePath(Path value, NutsSession session) {
        super(session);
        if (value == null) {
            throw new IllegalArgumentException("invalid value");
        }
        this.value = value;
    }

    public String getContentEncoding() {
        return null;
    }

    public String getContentType() {
        try {
            return Files.probeContentType(this.value);
        }
        catch (IOException e) {
            return null;
        }
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilePath urlPath = (FilePath)o;
        return Objects.equals(this.value, urlPath.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public String getName() {
        return CoreIOUtils.getURLName(this.value.toString());
    }

    public String asString() {
        return this.value.toString();
    }

    public String getLocation() {
        return this.value.toString();
    }

    public NutsPath toCompressedForm() {
        return new NutsCompressedPath(this);
    }

    public URL toURL() {
        try {
            return this.value.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Path toFilePath() {
        return this.value;
    }

    public NutsInput input() {
        return new FilePathInput();
    }

    public NutsOutput output() {
        return new NutsPathOutput(null, this, this.getSession()){

            @Override
            public OutputStream open() {
                return FilePath.this.outputStream();
            }
        };
    }

    public void delete(boolean recurse) {
        if (Files.isRegularFile(this.value, new LinkOption[0])) {
            try {
                Files.delete(this.value);
            }
            catch (IOException e) {
                throw new NutsIOException(this.getSession(), (Throwable)e);
            }
        } else if (Files.isDirectory(this.value, new LinkOption[0])) {
            if (recurse) {
                CoreIOUtils.delete(this.getSession(), this.value);
            } else {
                try {
                    Files.delete(this.value);
                }
                catch (IOException e) {
                    throw new NutsIOException(this.getSession(), (Throwable)e);
                }
            }
        } else {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to delete path %s", (Object[])new Object[]{this.value}));
        }
    }

    public void mkdir(boolean parents) {
        if (Files.isRegularFile(this.value, new LinkOption[0])) {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to create folder out of regular file %s", (Object[])new Object[]{this.value}));
        }
        if (Files.isDirectory(this.value, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(this.value, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to create folders %s", (Object[])new Object[]{this.value}));
        }
    }

    public boolean exists() {
        return Files.exists(this.value, new LinkOption[0]);
    }

    public long getContentLength() {
        try {
            return Files.size(this.value);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Instant getLastModifiedInstant() {
        FileTime r = null;
        try {
            r = Files.getLastModifiedTime(this.value, new LinkOption[0]);
            if (r != null) {
                return r.toInstant();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public NutsFormat formatter() {
        return (NutsFormat)new MyPathFormat(this).setSession(this.getSession());
    }

    public NutsFormatSPI getFormatterSPI() {
        NutsFormat formatter = this.formatter();
        return new NutsFormatSPIFromNutsFormat(formatter);
    }

    public InputStream inputStream() {
        try {
            return Files.newInputStream(this.value, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public OutputStream outputStream() {
        try {
            return Files.newOutputStream(this.value, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private class FilePathInput
    extends NutsPathInput {
        public FilePathInput() {
            super(FilePath.this);
        }

        @Override
        public InputStream open() {
            return new InputStreamMetadataAwareImpl(FilePath.this.inputStream(), new FixedInputStreamMetadata(this.getNutsPath().toString(), this.getNutsPath().getContentLength()));
        }
    }

    private static class MyPathFormat
    extends DefaultFormatBase<NutsFormat> {
        private FilePath p;

        public MyPathFormat(FilePath p) {
            super(p.getSession().getWorkspace(), "path");
            this.p = p;
        }

        public NutsString asFormattedString() {
            if (this.p.value == null) {
                return this.getSession().getWorkspace().text().forPlain("");
            }
            return this.getSession().getWorkspace().text().toText((Object)this.p.value);
        }

        @Override
        public void print(NutsPrintStream out) {
            out.print(this.asFormattedString());
        }

        public boolean configureFirst(NutsCommandLine commandLine) {
            return false;
        }
    }
}

