/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.io;

import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.io.URLPath;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;

public class ClassLoaderPath
extends URLPath {
    private String path;

    public ClassLoaderPath(String path, ClassLoader loader, NutsSession session) {
        super(loader.getResource(path.substring("classpath://".length())), session, true);
        this.path = path;
        if (!path.startsWith("classpath://")) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid classpath url format: %s", (Object[])new Object[]{path}));
        }
    }

    @Override
    public String toString() {
        return this.path;
    }

    @Override
    public String getName() {
        return CoreIOUtils.getURLName(this.path);
    }

    @Override
    public String asString() {
        return this.path;
    }

    @Override
    public String getLocation() {
        if (this.url != null) {
            return super.getLocation();
        }
        return this.path.substring("classpath:/".length());
    }
}

