/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.yaml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import net.thevpc.nuts.NutsArrayElementBuilder;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsElementFactoryContext;
import net.thevpc.nuts.NutsElementFormat;
import net.thevpc.nuts.NutsObjectElementBuilder;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.elem.NutsElementStreamFormat;
import net.thevpc.nuts.runtime.core.format.json.ReaderLocation;

public class SimpleYaml
implements NutsElementStreamFormat {
    private NutsWorkspace ws;

    public SimpleYaml(NutsWorkspace ws) {
        this.ws = ws;
    }

    @Override
    public NutsElement parseElement(Reader reader, NutsElementFactoryContext context) {
        return new ElementParser(context).parseElement(reader);
    }

    @Override
    public void printElement(NutsElement value, NutsPrintStream out, boolean compact, NutsElementFactoryContext context) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static class ElementParser {
        private BufferedReader reader;
        private NutsElementFactoryContext context;
        private NutsElementFormat ebuilder;
        private int fileOffset;
        private int lineNumber;
        private int lineOffset;
        private int current;
        private boolean skipLF;

        public ElementParser(NutsElementFactoryContext context) {
            this.context = context;
        }

        public NutsElement parseElement(Reader reader) {
            this.reader = reader instanceof BufferedReader ? this.reader : new BufferedReader(reader);
            this.readNext();
            return this.readElement(0);
        }

        private void readTerminal(String s) {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                if (this.readChar(ch)) continue;
                throw this.expected("'" + ch + "'");
            }
        }

        private int readNext() {
            try {
                this.current = this.reader.read();
                if (this.current != -1) {
                    ++this.lineOffset;
                    ++this.fileOffset;
                    if (this.skipLF) {
                        if (this.current == 10) {
                            this.current = this.reader.read();
                        }
                        this.skipLF = false;
                    }
                    switch (this.current) {
                        case 13: {
                            this.skipLF = true;
                        }
                        case 10: {
                            ++this.lineNumber;
                            this.lineOffset = 0;
                            this.current = 10;
                        }
                    }
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            return this.current;
        }

        private RuntimeException expected(String expected) {
            if (this.current == -1) {
                return this.error("unexpected end of input");
            }
            return this.error("expected " + expected);
        }

        private RuntimeException error(String message) {
            return new RuntimeException(message + ":" + this.getLocation().toString());
        }

        private boolean isHexDigit() {
            return this.current >= 48 && this.current <= 57 || this.current >= 97 && this.current <= 102 || this.current >= 65 && this.current <= 70;
        }

        ReaderLocation getLocation() {
            return new ReaderLocation(this.fileOffset, this.lineNumber, this.lineOffset);
        }

        private boolean isNumberChar(char c) {
            return c >= '0' && c <= '9' || c == '.' || c == '+' || c == '-' || c == 'e' || c == 'E';
        }

        private void readerMark() {
            try {
                this.reader.mark(1024);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        private void readerReset() {
            try {
                this.reader.reset();
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        public NutsElementFormat builder() {
            if (this.ebuilder == null) {
                this.ebuilder = this.context.getWorkspace().elem().setSession(this.context.getSession());
            }
            return this.ebuilder;
        }

        private boolean readChar(char ch) {
            if (this.current != ch) {
                return false;
            }
            this.readNext();
            return true;
        }

        private int computeIndent() {
            int indent = 0;
            while (this.current == 32 || this.current == 9) {
                ++indent;
                this.readNext();
            }
            return indent;
        }

        private boolean readNewLine() {
            boolean someNL = false;
            while (this.current == 10 || this.current == 59) {
                this.readNext();
                someNL = true;
            }
            return someNL;
        }

        private String readComments() {
            if (this.current == 35) {
                StringBuilder c = new StringBuilder();
                this.readNext();
                while (this.current != -1 && this.current != 10) {
                    c.append((char)this.current);
                    this.readNext();
                }
                while (this.current == 35) {
                    c.append("\n");
                    this.readNext();
                    while (this.current != -1 && this.current != 10) {
                        c.append((char)this.current);
                        this.readNext();
                    }
                }
                return c.toString();
            }
            return null;
        }

        private void skipWhiteSpace() {
            while (this.current == 32 || this.current == 9) {
                this.readNext();
            }
        }

        private int peekIndent() {
            int c = this.current;
            this.readerMark();
            int indent = this.computeIndent();
            this.readerReset();
            this.current = c;
            return indent;
        }

        private NutsElement readLiteral(boolean asValue) {
            if (this.current == 34) {
                this.readNext();
                StringBuilder sb = new StringBuilder();
                while (this.current != 34) {
                    if (this.current == 92) {
                        this.readNext();
                        switch (this.current) {
                            case 34: 
                            case 47: 
                            case 92: {
                                sb.append((char)this.current);
                                break;
                            }
                            case 98: {
                                sb.append('\b');
                                break;
                            }
                            case 102: {
                                sb.append('\f');
                                break;
                            }
                            case 110: {
                                sb.append('\n');
                                break;
                            }
                            case 114: {
                                sb.append('\r');
                                break;
                            }
                            case 116: {
                                sb.append('\t');
                                break;
                            }
                            case 117: {
                                char[] hexChars = new char[4];
                                for (int i = 0; i < 4; ++i) {
                                    this.readNext();
                                    if (!this.isHexDigit()) {
                                        throw this.expected("hexadecimal digit");
                                    }
                                    hexChars[i] = (char)this.current;
                                }
                                sb.append((char)Integer.parseInt(new String(hexChars), 16));
                                break;
                            }
                            default: {
                                throw this.expected("valid escape sequence");
                            }
                        }
                        this.readNext();
                        continue;
                    }
                    if (this.current < 32) {
                        throw this.expected("valid string character");
                    }
                    sb.append((char)this.current);
                    this.readNext();
                }
                this.readNext();
                this.skipWhiteSpace();
                String postComment = this.readComments();
                this.skipWhiteSpace();
                return this.builder().forString(sb.toString());
            }
            StringBuilder sb = new StringBuilder();
            boolean str = false;
            boolean dot = false;
            boolean E = false;
            while (this.current != -1 && this.current != 10 && this.current != 35 && (asValue || this.current != 58)) {
                char c = (char)this.current;
                sb.append(c);
                if (!str) {
                    if (!this.isNumberChar(c)) {
                        str = true;
                    } else if (c == '.') {
                        dot = true;
                    } else if (c == 'e' || c == 'E') {
                        E = true;
                    }
                }
                this.readNext();
            }
            this.skipWhiteSpace();
            String postComment = this.readComments();
            this.skipWhiteSpace();
            String trimmed = sb.toString().trim();
            if (!str && sb.length() > 0) {
                return this.builder().forNumber(trimmed);
            }
            if (sb.length() == 0) {
                return null;
            }
            switch (trimmed) {
                case "true": {
                    return this.builder().forTrue();
                }
                case "false": {
                    return this.builder().forFalse();
                }
            }
            return this.builder().forString(trimmed);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public NutsElement readElement(int indent) {
            Node a = this.readNode(indent, false);
            switch (a.type) {
                case LITERAL: {
                    return a.getElement();
                }
                case OBJECT_ELEMENT: {
                    NutsObjectElementBuilder obj = this.builder().forObject().add(a.getEntry());
                    while (true) {
                        Node o;
                        this.readNewLine();
                        int newIndent = this.peekIndent();
                        if (newIndent < indent || (o = this.readNode(indent, false)) == null) return obj.build();
                        if (o.type != NodeType.OBJECT_ELEMENT) throw this.expected("object entry");
                        obj.add(o.getEntry());
                    }
                }
                case ARRAY_ELEMENT: {
                    NutsArrayElementBuilder arr = this.builder().forArray().add(a.getElement());
                    while (true) {
                        Node o;
                        this.readNewLine();
                        int newIndent = this.peekIndent();
                        if (newIndent < indent || (o = this.readNode(indent, false)) == null) return arr.build();
                        if (o.type != NodeType.ARRAY_ELEMENT) throw this.expected("array entry");
                        arr.add(o.getElement());
                    }
                }
            }
            Node r = this.readNode(indent, true);
            return (NutsElement)r;
        }

        public Node readNode(int indent, boolean asValue) {
            this.skipWhiteSpace();
            String preComment = this.readComments();
            this.skipWhiteSpace();
            if (this.current == -1) {
                return null;
            }
            char c = (char)this.current;
            switch (c) {
                case '-': {
                    if (asValue) {
                        NutsElement li = this.readLiteral(true);
                        return Node.forLiteral(li);
                    }
                    this.readerMark();
                    this.readNext();
                    if (this.current == 32 || this.current == 9) {
                        this.readNext();
                        NutsElement li = this.readNode(indent, true).getElement();
                        return Node.forArrayElement(li);
                    }
                    if (this.current == 10 || this.current == 59) {
                        this.readNewLine();
                        int newIndent = this.peekIndent();
                        if (newIndent > indent) {
                            this.skipWhiteSpace();
                            NutsElement li = this.readElement(newIndent);
                            return Node.forArrayElement(li);
                        }
                        return Node.forArrayElement((NutsElement)this.builder().forString(""));
                    }
                    this.readerReset();
                    this.readNext();
                    NutsElement li = this.readLiteral(true);
                    return Node.forLiteral(li);
                }
                case '{': {
                    throw new IllegalArgumentException("not supported yet");
                }
                case '[': {
                    throw new IllegalArgumentException("not supported yet");
                }
                case '?': {
                    if (asValue) {
                        NutsElement li = this.readLiteral(true);
                        return Node.forLiteral(li);
                    }
                    this.readerMark();
                    this.readNext();
                    if (this.current == 32 || this.current == 9) {
                        this.readNext();
                        NutsElement li = this.readNode(indent, true).getElement();
                        this.skipWhiteSpace();
                        this.readNewLine();
                        this.skipWhiteSpace();
                        this.readChar(':');
                        this.skipWhiteSpace();
                        this.readNewLine();
                        this.skipWhiteSpace();
                        NutsElement v = this.readNode(indent, true).getElement();
                        return Node.forObjectElement(this.builder().forEntry(li, v));
                    }
                    if (this.current == 10 || this.current == 59) {
                        this.readNewLine();
                        int newIndent = this.peekIndent();
                        if (newIndent > indent) {
                            this.skipWhiteSpace();
                            NutsElement li = this.readNode(newIndent, true).getElement();
                            this.skipWhiteSpace();
                            this.readNewLine();
                            this.skipWhiteSpace();
                            this.readChar(':');
                            this.skipWhiteSpace();
                            this.readNewLine();
                            this.skipWhiteSpace();
                            NutsElement v = this.readNode(newIndent, true).getElement();
                            return Node.forObjectElement(this.builder().forEntry(li, v));
                        }
                        NutsElement li = this.readNode(indent, true).getElement();
                        this.skipWhiteSpace();
                        this.readNewLine();
                        this.skipWhiteSpace();
                        this.readChar(':');
                        this.skipWhiteSpace();
                        this.readNewLine();
                        this.skipWhiteSpace();
                        NutsElement v = this.readNode(indent, true).getElement();
                        return Node.forObjectElement(this.builder().forEntry(li, v));
                    }
                    this.readerReset();
                    this.readNext();
                    NutsElement li = this.readLiteral(true);
                    return Node.forLiteral(li);
                }
            }
            NutsElement li = this.readLiteral(false);
            if (asValue) {
                return Node.forLiteral(li);
            }
            this.skipWhiteSpace();
            if (this.current == 58) {
                this.readNext();
                if (this.readNewLine()) {
                    int newIndent = this.peekIndent();
                    if (newIndent > indent) {
                        this.skipWhiteSpace();
                        NutsElement v = this.readElement(newIndent);
                        return Node.forObjectElement(this.builder().forEntry(li, v));
                    }
                    return Node.forObjectElement(this.builder().forEntry(li, (NutsElement)this.builder().forString("")));
                }
                Node n = this.readNode(indent, true);
                NutsElement v = n.getElement();
                return Node.forObjectElement(this.builder().forEntry(li, v));
            }
            return Node.forLiteral(li);
        }
    }

    private static class Node {
        NodeType type;
        Object value;

        private static Node forLiteral(NutsElement value) {
            return new Node(NodeType.LITERAL, value);
        }

        private static Node forArrayElement(NutsElement value) {
            return new Node(NodeType.ARRAY_ELEMENT, value);
        }

        private static Node forObjectElement(NutsElementEntry value) {
            return new Node(NodeType.OBJECT_ELEMENT, value);
        }

        private Node(NodeType type, Object value) {
            this.type = type;
            this.value = value;
        }

        public NodeType getType() {
            return this.type;
        }

        public NutsElement getElement() {
            return (NutsElement)this.value;
        }

        public NutsElementEntry getEntry() {
            return (NutsElementEntry)this.value;
        }

        public Object getValue() {
            return this.value;
        }
    }

    private static enum NodeType {
        LITERAL,
        ARRAY_ELEMENT,
        OBJECT_ELEMENT;

    }
}

