/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.xml;

import java.io.IOException;
import java.io.Reader;
import javax.xml.transform.stream.StreamResult;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementFactoryContext;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsMemoryPrintStream;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.runtime.core.format.elem.NutsElementStreamFormat;
import net.thevpc.nuts.runtime.core.format.xml.NutsXmlUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultXmlNutsElementStreamFormat
implements NutsElementStreamFormat {
    @Override
    public NutsElement parseElement(Reader reader, NutsElementFactoryContext context) {
        NutsSession session = context.getSession();
        Document doc = null;
        try {
            doc = NutsXmlUtils.createDocumentBuilder(false, session).parse(new InputSource(reader));
        }
        catch (SAXException ex) {
            throw new NutsIOException(session, (Throwable)new IOException(ex));
        }
        catch (IOException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
        return context.objectToElement((Object)doc, Document.class);
    }

    @Override
    public void printElement(NutsElement value, NutsPrintStream out, boolean compact, NutsElementFactoryContext context) {
        NutsSession session = context.getSession();
        Document doc = (Document)context.elementToObject(value, Document.class);
        if (out.isNtf()) {
            NutsMemoryPrintStream bos = context.getWorkspace().io().createMemoryPrintStream();
            NutsXmlUtils.writeDocument(doc, new StreamResult(bos.asPrintStream()), compact, true, session);
            out.print((NutsString)context.getWorkspace().text().forCode("xml", bos.toString()));
        } else {
            NutsXmlUtils.writeDocument(doc, new StreamResult(out.asPrintStream()), compact, true, session);
        }
    }
}

