/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.xml;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import javax.xml.transform.stream.StreamResult;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCodeFormat;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.runtime.core.format.DefaultSearchFormatBase;
import net.thevpc.nuts.runtime.core.format.NutsFetchDisplayOptions;
import net.thevpc.nuts.runtime.core.format.xml.NutsXmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultSearchFormatXml
extends DefaultSearchFormatBase {
    private boolean compact;
    private String rootName = "root";
    private NutsCodeFormat codeFormat;

    public DefaultSearchFormatXml(NutsSession session, NutsPrintStream writer, NutsFetchDisplayOptions options) {
        super(session, writer, NutsContentType.XML, options);
        this.codeFormat = session.getWorkspace().text().setSession(session).getCodeFormat("xml");
    }

    public String getRootName() {
        return this.rootName;
    }

    public void start() {
        NutsTextBuilder builder = this.getWorkspace().text().builder();
        NutsSession session = this.getSession();
        builder.append(this.codeFormat.tokenToText("<?", "separator", session));
        builder.append(this.codeFormat.tokenToText("xml", "name", session));
        builder.append((Object)" ");
        builder.append(this.codeFormat.tokenToText("version", "attribute", session));
        builder.append(this.codeFormat.tokenToText("=", "separator", session));
        builder.append(this.codeFormat.tokenToText("\"1.0\"", "string", session));
        builder.append((Object)" ");
        builder.append(this.codeFormat.tokenToText("encoding", "attribute", session));
        builder.append(this.codeFormat.tokenToText("=", "separator", session));
        builder.append(this.codeFormat.tokenToText("?>", "separator", session));
        builder.append((Object)"\n");
        builder.append(this.codeFormat.tokenToText("<", "separator", session));
        builder.append(this.codeFormat.tokenToText(this.rootName, "name", session));
        builder.append(this.codeFormat.tokenToText(">", "separator", session));
        this.getWriter().println(builder.toString());
    }

    public void next(Object object, long index) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        Element xmlElement = (Element)this.getWorkspace().elem().setSession(this.getSession()).convert(object, Element.class);
        Document doc = NutsXmlUtils.createDocument(this.getSession());
        doc.adoptNode(xmlElement);
        doc.appendChild(xmlElement);
        NutsXmlUtils.writeDocument(doc, new StreamResult(pw), this.compact, false, this.getSession());
        pw.flush();
        this.getWriter().print((NutsString)this.codeFormat.stringToText(bos.toString(), this.getSession()));
    }

    public void complete(long count) {
        NutsTextBuilder builder = this.getWorkspace().text().builder();
        NutsSession session = this.getSession();
        builder.append(this.codeFormat.tokenToText("</", "separator", session));
        builder.append(this.codeFormat.tokenToText(this.rootName, "name", session));
        builder.append(this.codeFormat.tokenToText(">", "separator", session));
        this.getWriter().println(builder.toString());
        this.getWriter().flush();
    }

    public boolean configureFirst(NutsCommandLine cmd) {
        NutsArgument a = cmd.peek();
        if (a == null) {
            return false;
        }
        if (this.getDisplayOptions().configureFirst(cmd)) {
            return true;
        }
        boolean enabled = a.isEnabled();
        switch (a.getStringKey()) {
            case "--compact": {
                boolean val = cmd.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.compact = val;
                }
                return true;
            }
            case "--root-name": {
                String val = cmd.nextString(new String[0]).getStringValue();
                if (enabled) {
                    this.rootName = val;
                }
                return true;
            }
        }
        return false;
    }
}

