/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text.stylethemes;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.UUID;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsTextFormatTheme;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyleType;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.bundles.parsers.StringReaderExt;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.core.util.CoreNumberUtils;

public class NutsTextFormatPropertiesTheme
implements NutsTextFormatTheme {
    private Properties props;
    private NutsSession session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NutsTextFormatPropertiesTheme(String name, ClassLoader cls, NutsSession session) {
        block52: {
            URL u;
            this.props = new Properties();
            this.session = session;
            if (name.indexOf(47) >= 0 || name.indexOf(92) >= 0) {
                Object inStream;
                if (name.startsWith("classpath://")) {
                    URL u2;
                    String r;
                    if (cls == null) {
                        cls = this.getClass().getClassLoader();
                    }
                    if (!(r = name.substring("classpath://".length())).startsWith("/")) {
                        r = "/" + r;
                    }
                    if ((u2 = cls.getResource(r)) == null && !r.endsWith(".ntf-theme")) {
                        r = r + ".ntf-theme";
                        u2 = cls.getResource(r);
                    }
                    if (u2 == null) {
                        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid theme: %s", (Object[])new Object[]{name}));
                    }
                    try {
                        this.props.load(u2.openStream());
                    }
                    catch (IOException e) {
                        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid theme: %s", (Object[])new Object[]{name}), (Throwable)e);
                    }
                }
                if (CoreIOUtils.isURL(name)) {
                    try {
                        URL uu = new URL(name);
                        inStream = null;
                        inStream = uu.openStream();
                        if (inStream == null) {
                            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid theme: %s", (Object[])new Object[]{name}));
                        }
                        try {
                            this.props.load((InputStream)inStream);
                            break block52;
                        }
                        finally {
                            ((InputStream)inStream).close();
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                try {
                    FileInputStream inStream2 = new FileInputStream(new File(name));
                    inStream = null;
                    try {
                        this.props.load(inStream2);
                        break block52;
                    }
                    catch (Throwable e) {
                        inStream = e;
                        throw e;
                    }
                    finally {
                        if (inStream2 != null) {
                            if (inStream != null) {
                                try {
                                    ((InputStream)inStream2).close();
                                }
                                catch (Throwable e) {
                                    ((Throwable)inStream).addSuppressed(e);
                                }
                            } else {
                                ((InputStream)inStream2).close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            if (cls == null) {
                cls = this.getClass().getClassLoader();
            }
            if ((u = cls.getResource("META-INF/ntf-themes/" + name + ".ntf-theme")) != null) {
                try {
                    InputStream inStream = null;
                    inStream = u.openStream();
                    if (inStream == null) {
                        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid theme: %s", (Object[])new Object[]{name}));
                    }
                    try {
                        this.props.load(inStream);
                        break block52;
                    }
                    finally {
                        inStream.close();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            Path themeFile = Paths.get(session.getWorkspace().locations().getStoreLocation(session.getWorkspace().id().parser().parse("net.thevpc.nuts:nuts-runtime#SHARED"), NutsStoreLocation.CONFIG), new String[0]).resolve("themes").resolve(name);
            if (Files.isRegularFile(themeFile, new LinkOption[0])) {
                try (InputStream inStream = Files.newInputStream(themeFile, new OpenOption[0]);){
                    this.props.load(inStream);
                    break block52;
                }
                catch (IOException e) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid theme: %s", (Object[])new Object[]{name}), (Throwable)e);
                }
            }
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid theme: %s", (Object[])new Object[]{name}));
        }
    }

    public String getName() {
        String themeName = this.props.getProperty("theme-name");
        if (NutsUtilStrings.isBlank((CharSequence)themeName)) {
            themeName = UUID.randomUUID().toString();
            this.props.put("theme-name", themeName);
        }
        return themeName;
    }

    public NutsTextStyles toBasicStyles(NutsTextStyles styles, NutsSession session) {
        NutsTextStyles ret = NutsTextStyles.NONE;
        if (styles != null) {
            for (NutsTextStyle style : styles) {
                ret = ret.append(this.toBasicStyles(style, session));
            }
        }
        return ret;
    }

    private String getProp(NutsTextStyleType t, int variant) {
        String v = this.getProp(t, "" + variant);
        if (v != null) {
            return v;
        }
        v = this.getProp(t, "*");
        if (v != null) {
            StringReaderExt r = new StringReaderExt(v);
            StringBuilder sb = new StringBuilder();
            while (r.hasNext()) {
                if (r.peekChar() == '*') {
                    if (r.hasNext(1) && r.peekChar(1) == '%') {
                        r.nextChar();
                        r.nextChar();
                        StringBuilder mod = new StringBuilder();
                        while (r.hasNext() && r.peekChar() >= '0' && r.peekChar() <= '9') {
                            mod.append(r.nextChar());
                        }
                        sb.append(variant % Integer.parseInt(mod.toString()));
                        continue;
                    }
                    r.nextChar();
                    sb.append(variant);
                    continue;
                }
                sb.append(r.nextChar());
            }
            return sb.toString();
        }
        return v;
    }

    private int getVarVal(String n) {
        String z = this.props.getProperty(n);
        if (z != null) {
            try {
                return Integer.parseInt(z);
            }
            catch (Exception ex) {
                return 0;
            }
        }
        return 0;
    }

    private String getProp(NutsTextStyleType t, String variant) {
        String name = t.name();
        String s = this.props.getProperty(name + "(" + variant + ")");
        if (s == null) {
            s = this.props.getProperty(name.toLowerCase() + "(" + variant + ")");
        }
        return s;
    }

    public NutsTextStyles toBasicStyles(NutsTextStyle style, NutsSession session) {
        return this.toBasicStyles(style, session, 20);
    }

    public NutsTextStyles toBasicStyles(NutsTextStyle style, NutsSession session, int maxLoop) {
        if (maxLoop <= 0) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid ntf theme for %s(%s). infinite loop", (Object[])new Object[]{style.getType(), style.getVariant()}));
        }
        if (style.getType().basic()) {
            return NutsTextStyles.of((NutsTextStyle)style);
        }
        String s = this.getProp(style.getType(), style.getVariant());
        if (s == null) {
            return NutsTextStyles.NONE;
        }
        NutsTextStyles ret = NutsTextStyles.NONE;
        for (String v : s.split(",")) {
            NutsTextStyles ss = this.toBasicStyles(v, style.getVariant(), session, maxLoop - 1);
            ret = ret.append(ss);
        }
        return ret;
    }

    public NutsTextStyles toBasicStyles(String v, int defaultVariant, NutsSession session, int maxLoop) {
        int b;
        int a = (v = v.trim()).indexOf(40);
        if (a > 0 && (b = v.indexOf(41, a)) > 0) {
            String n = v.substring(a + 1, b);
            String k = v.substring(0, a);
            if (n.equals("*")) {
                n = "" + defaultVariant;
            }
            switch (k.toLowerCase()) {
                case "foreground": 
                case "foregroundcolor": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return NutsTextStyles.of((NutsTextStyle)NutsTextStyle.foregroundColor((int)ii));
                }
                case "plain": {
                    return NutsTextStyles.NONE;
                }
                case "foregroundtruecolor": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return NutsTextStyles.of((NutsTextStyle)NutsTextStyle.foregroundTrueColor((int)ii));
                }
                case "background": 
                case "backgroundcolor": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return NutsTextStyles.of((NutsTextStyle)NutsTextStyle.backgroundColor((int)ii));
                }
                case "backgroundtruecolor": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return NutsTextStyles.of((NutsTextStyle)NutsTextStyle.backgroundTrueColor((int)ii));
                }
                case "primary": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.primary((int)ii), session, maxLoop);
                }
                case "secondary": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.secondary((int)ii), session, maxLoop);
                }
                case "underlined": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.underlined(), session, maxLoop);
                }
                case "bold": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.bold(), session, maxLoop);
                }
                case "bool": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.bool((int)ii), session, maxLoop);
                }
                case "blink": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.blink(), session, maxLoop);
                }
                case "comments": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.comments((int)ii), session, maxLoop);
                }
                case "config": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.config((int)ii), session, maxLoop);
                }
                case "danger": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.danger((int)ii), session, maxLoop);
                }
                case "date": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.date((int)ii), session, maxLoop);
                }
                case "number": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.number((int)ii), session, maxLoop);
                }
                case "error": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.error((int)ii), session, maxLoop);
                }
                case "warn": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.warn((int)ii), session, maxLoop);
                }
                case "version": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.version((int)ii), session, maxLoop);
                }
                case "variable": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.variable((int)ii), session, maxLoop);
                }
                case "input": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.input((int)ii), session, maxLoop);
                }
                case "title": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.title((int)ii), session, maxLoop);
                }
                case "success": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.success((int)ii), session, maxLoop);
                }
                case "string": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.string((int)ii), session, maxLoop);
                }
                case "striked": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.striked((int)ii), session, maxLoop);
                }
                case "separator": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.separator((int)ii), session, maxLoop);
                }
                case "reversed": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.reversed((int)ii), session, maxLoop);
                }
                case "path": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.path((int)ii), session, maxLoop);
                }
                case "option": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.option((int)ii), session, maxLoop);
                }
                case "pale": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.pale((int)ii), session, maxLoop);
                }
                case "operator": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.operator((int)ii), session, maxLoop);
                }
                case "keyword": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.keyword((int)ii), session, maxLoop);
                }
                case "italic": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.italic((int)ii), session, maxLoop);
                }
                case "info": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.info((int)ii), session, maxLoop);
                }
                case "fail": {
                    Integer ii = CoreNumberUtils.convertToInteger(n, null);
                    if (ii == null) {
                        ii = this.getVarVal(n);
                    }
                    return this.toBasicStyles(NutsTextStyle.fail((int)ii), session, maxLoop);
                }
            }
        }
        return NutsTextStyles.NONE;
    }
}

