/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text.stylethemes;

import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextFormatTheme;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.NutsWorkspace;

public class DefaultNutsTextFormatTheme
implements NutsTextFormatTheme {
    public static final int BLACK = 1;
    public static final int DARK_RED = 1;
    public static final int DARK_GREEN = 2;
    public static final int DARK_YELLOW = 3;
    public static final int DARK_BLUE = 4;
    public static final int DARK_VIOLET = 5;
    public static final int DARK_SKY = 6;
    public static final int LIGHT_GRAY = 7;
    public static final int DARK_GRAY = 8;
    public static final int BRIGHT_RED = 9;
    public static final int BRIGHT_GREEN = 10;
    public static final int BRIGHT_YELLOW = 11;
    public static final int BRIGHT_BLUE = 12;
    public static final int BRIGHT_VIOLET = 13;
    public static final int BRIGHT_SKY = 14;
    public static final int WHITE = 15;
    private static final int[] FG = new int[]{1, 4, 12, 6, 14, 2, 10, 5, 13, 3, 11, 1, 9, 8, 7, 15};
    private static final int[] BG = new int[]{1, 4, 12, 6, 14, 2, 10, 5, 13, 3, 11, 1, 9, 8, 7, 15};
    private NutsWorkspace ws;

    private static int mod16(int x) {
        return x >= 0 ? x % 16 : -x % 16;
    }

    private static int mod4(int x) {
        return x >= 0 ? x % 4 : -x % 4;
    }

    private static int mod2(int x) {
        return x >= 0 ? x % 2 : -x % 2;
    }

    public String getName() {
        return "default";
    }

    public DefaultNutsTextFormatTheme(NutsWorkspace ws) {
        this.ws = ws;
    }

    public NutsTextStyles toBasicStyles(NutsTextStyles styles, NutsSession session) {
        NutsTextStyles ret = NutsTextStyles.NONE;
        if (styles != null) {
            for (NutsTextStyle style : styles) {
                ret = ret.append(this.toBasicStyles(style));
            }
        }
        return ret;
    }

    public NutsTextStyles toBasicStyles(NutsTextStyle style) {
        if (style == null) {
            return NutsTextStyles.NONE;
        }
        switch (style.getType()) {
            case FORE_COLOR: 
            case BACK_COLOR: 
            case FORE_TRUE_COLOR: 
            case BACK_TRUE_COLOR: 
            case UNDERLINED: 
            case ITALIC: 
            case STRIKED: 
            case REVERSED: 
            case BOLD: 
            case BLINK: {
                return NutsTextStyles.of((NutsTextStyle)style);
            }
            case PRIMARY: {
                return this.toBasicStyles(NutsTextStyle.foregroundColor((int)this.mapColor(style.getVariant())));
            }
            case SECONDARY: {
                return this.toBasicStyles(NutsTextStyle.backgroundColor((int)this.mapColor(style.getVariant())));
            }
            case TITLE: {
                return this.toBasicStyles(NutsTextStyle.primary((int)style.getVariant())).append(NutsTextStyle.underlined());
            }
            case KEYWORD: {
                int x = DefaultNutsTextFormatTheme.mod4(style.getVariant());
                return this.toBasicStyles(NutsTextStyle.foregroundColor((int)(x == 0 ? 4 : (x == 1 ? 6 : (x == 2 ? 5 : 13)))));
            }
            case OPTION: {
                int x = DefaultNutsTextFormatTheme.mod4(style.getVariant());
                return this.toBasicStyles(NutsTextStyle.foregroundColor((int)(x == 0 ? 6 : (x == 1 ? 66 : (x == 2 ? 102 : 138)))));
            }
            case ERROR: {
                return NutsTextStyles.of((NutsTextStyle)NutsTextStyle.foregroundColor((int)1));
            }
            case SUCCESS: {
                return NutsTextStyles.of((NutsTextStyle)NutsTextStyle.foregroundColor((int)2));
            }
            case WARN: {
                return NutsTextStyles.of((NutsTextStyle)NutsTextStyle.foregroundColor((int)3));
            }
            case INFO: {
                return NutsTextStyles.of((NutsTextStyle)NutsTextStyle.foregroundColor((int)6));
            }
            case CONFIG: {
                return NutsTextStyles.of((NutsTextStyle)NutsTextStyle.foregroundColor((int)5));
            }
            case DATE: 
            case NUMBER: 
            case BOOLEAN: {
                return this.toBasicStyles(NutsTextStyle.foregroundColor((int)5));
            }
            case STRING: {
                return this.toBasicStyles(NutsTextStyle.foregroundColor((int)2));
            }
            case COMMENTS: {
                return this.toBasicStyles(NutsTextStyle.foregroundColor((int)8));
            }
            case SEPARATOR: {
                return this.toBasicStyles(NutsTextStyle.foregroundColor((int)208));
            }
            case OPERATOR: {
                return this.toBasicStyles(NutsTextStyle.foregroundColor((int)208));
            }
            case INPUT: {
                return this.toBasicStyles(NutsTextStyle.foregroundColor((int)11));
            }
            case FAIL: {
                return this.toBasicStyles(NutsTextStyle.foregroundColor((int)124));
            }
            case DANGER: {
                return this.toBasicStyles(NutsTextStyle.foregroundColor((int)124));
            }
            case VAR: {
                return this.toBasicStyles(NutsTextStyle.foregroundColor((int)190));
            }
            case PALE: {
                return this.toBasicStyles(NutsTextStyle.foregroundColor((int)250));
            }
            case VERSION: {
                return this.toBasicStyles(NutsTextStyle.foregroundColor((int)220));
            }
            case PATH: {
                return this.toBasicStyles(NutsTextStyle.foregroundColor((int)114));
            }
        }
        throw new IllegalArgumentException("invalid text node style " + style);
    }

    private int mapColor(int v) {
        if (v == 0) {
            v = 1;
        }
        if (v < 0) {
            v = -v;
        }
        if (v < 16) {
            return FG[v];
        }
        return v;
    }
}

