/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text.renderer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.format.text.AnsiEscapeCommand;
import net.thevpc.nuts.runtime.core.format.text.FormattedPrintStreamRenderer;
import net.thevpc.nuts.runtime.core.format.text.RenderedRawStream;
import net.thevpc.nuts.runtime.core.format.text.renderer.AnsiStyleStyleApplierResolver;
import net.thevpc.nuts.runtime.core.format.text.renderer.ansi.AnsiStyle;
import net.thevpc.nuts.runtime.core.format.text.renderer.ansi.AnsiStyleStyleApplier;
import net.thevpc.nuts.runtime.core.format.text.renderer.ansi.DoNothingAnsiStyleStyleApplier;
import net.thevpc.nuts.runtime.core.util.CachedValue;

public class AnsiUnixTermPrintRenderer
implements FormattedPrintStreamRenderer {
    public static final FormattedPrintStreamRenderer ANSI_RENDERER = new AnsiUnixTermPrintRenderer();
    private static CachedValue<Integer> tput_cols;
    private static AnsiStyleStyleApplierResolver applierResolver;

    @Override
    public AnsiStyle createStyleRenderer(AnsiEscapeCommand format, RenderedRawStream out, NutsSession session) {
        AnsiStyleStyleApplier applier = applierResolver.resolveStyleApplyer(format);
        return applier.apply(AnsiStyle.PLAIN, out, session, applierResolver);
    }

    @Override
    public void startFormat(RenderedRawStream out, AnsiEscapeCommand format, NutsSession session) throws IOException {
        this.createStyleRenderer(format, out, session).startFormat(out);
    }

    @Override
    public void endFormat(RenderedRawStream out, AnsiEscapeCommand format, NutsSession session) throws IOException {
        this.createStyleRenderer(format, out, session).endFormat(out);
    }

    static {
        applierResolver = new AnsiStyleStyleApplierResolver(){
            private final Map<AnsiEscapeCommand, AnsiStyleStyleApplier> stylesAppliers = new HashMap<AnsiEscapeCommand, AnsiStyleStyleApplier>();

            @Override
            public AnsiStyleStyleApplier resolveStyleApplyer(AnsiEscapeCommand format) {
                if (format == null) {
                    return DoNothingAnsiStyleStyleApplier.INSTANCE;
                }
                if (format instanceof AnsiStyleStyleApplier) {
                    return (AnsiStyleStyleApplier)((Object)format);
                }
                AnsiStyleStyleApplier s = this.stylesAppliers.get(format);
                if (s != null) {
                    return s;
                }
                return DoNothingAnsiStyleStyleApplier.INSTANCE;
            }
        };
    }
}

