/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text.parser.steps;

import java.util.ArrayList;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyleType;
import net.thevpc.nuts.NutsTextStyles;
import net.thevpc.nuts.runtime.bundles.parsers.StringReaderExt;

public class StyledParserStepCommandParser {
    public boolean isCommandEnd(char c) {
        return c == ' ' || c == ':';
    }

    public boolean isCommandPart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '/' || c == '_' || c == '+' || c == '!' || c == '-' || c == '%';
    }

    public NutsTextStyles parse(String atStr) {
        StringReaderExt r = new StringReaderExt(atStr.toString());
        ArrayList<NutsTextStyle> parsedStyles = new ArrayList<NutsTextStyle>();
        if (r.hasNext() && r.peekChar() == ':') {
            r.nextChar();
            while (!this.readEnd(r)) {
                NutsTextStyle s = this.readNext(r);
                if (s == null) {
                    return null;
                }
                parsedStyles.add(s);
            }
        } else {
            return null;
        }
        return NutsTextStyles.NONE.append(parsedStyles.toArray(new NutsTextStyle[0]));
    }

    private boolean isHexaChar(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private boolean isDigitChar(char c) {
        return c >= '0' && c <= '9';
    }

    private NutsTextStyle readWordNumber(StringReaderExt r) {
        char c;
        if (r.hasNext() && ((c = r.peekChar()) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            int x = 1;
            StringBuilder sb = new StringBuilder();
            sb.append(c);
            String variantString = "";
            while (r.hasNext(x)) {
                String variant;
                String s;
                char c2 = r.peekChar(x);
                if (sb.toString().equals("foreground")) {
                    if (r.hasNext(x + 7) && r.peekChar(x + 0) == 'x' && this.isHexaChar(r.peekChar(x + 1)) && this.isHexaChar(r.peekChar(x + 2)) && this.isHexaChar(r.peekChar(x + 3)) && this.isHexaChar(r.peekChar(x + 4)) && this.isHexaChar(r.peekChar(x + 5)) && this.isHexaChar(r.peekChar(x + 6))) {
                        r.nextChars(sb.length());
                        s = r.nextChars(7);
                        return NutsTextStyle.foregroundTrueColor((int)Integer.parseInt(s.substring(1), 16));
                    }
                    variant = this.peekInt(r, x, 3);
                    if (variant != null) {
                        r.nextChars(sb.length());
                        r.nextChars(variant.length());
                        return NutsTextStyle.foregroundColor((int)Integer.parseInt(variant));
                    }
                } else if (sb.toString().equals("background")) {
                    if (r.hasNext(x + 7) && r.peekChar(x + 0) == 'x' && this.isHexaChar(r.peekChar(x + 1)) && this.isHexaChar(r.peekChar(x + 2)) && this.isHexaChar(r.peekChar(x + 3)) && this.isHexaChar(r.peekChar(x + 4)) && this.isHexaChar(r.peekChar(x + 5)) && this.isHexaChar(r.peekChar(x + 6))) {
                        r.nextChars(sb.length());
                        s = r.nextChars(7);
                        return NutsTextStyle.backgroundTrueColor((int)Integer.parseInt(s.substring(1), 16));
                    }
                    variant = this.peekInt(r, x, 3);
                    if (variant != null) {
                        r.nextChars(sb.length());
                        r.nextChars(variant.length());
                        return NutsTextStyle.backgroundColor((int)Integer.parseInt(variant));
                    }
                }
                if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == '_' || c2 == '-') {
                    sb.append(c2);
                    ++x;
                    continue;
                }
                if (c2 == ' ' || c2 == ':' || c2 < '0' || c2 > '9' || (s = this.peekInt(r, x, 3)) == null) break;
                variantString = s;
                break;
            }
            int variant = variantString.isEmpty() ? 0 : Integer.parseInt(variantString);
            switch (sb.toString()) {
                case "kw": {
                    r.nextChars(sb.toString().length() + variantString.length());
                    return NutsTextStyle.keyword((int)variant);
                }
                case "p": {
                    r.nextChars(sb.toString().length() + variantString.length());
                    return NutsTextStyle.primary((int)variant);
                }
                case "s": {
                    r.nextChars(sb.toString().length() + variantString.length());
                    return NutsTextStyle.secondary((int)variant);
                }
                case "bool": {
                    r.nextChars(sb.toString().length() + variantString.length());
                    return NutsTextStyle.bool((int)variant);
                }
            }
            String sb2 = sb.toString().toUpperCase();
            sb2 = sb2.replace('-', '_');
            try {
                NutsTextStyleType st = NutsTextStyleType.valueOf((String)sb2);
                r.nextChars(sb.toString().length() + variantString.length());
                return NutsTextStyle.of((NutsTextStyleType)st, (int)variant);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    private String peekInt(StringReaderExt r, int from, int maxChars) {
        char c;
        int x = 0;
        StringBuilder s = new StringBuilder();
        while (r.hasNext(from + x) && this.isDigitChar(c = r.peekChar(from + x))) {
            s.append(c);
            if (++x != maxChars) continue;
            break;
        }
        if (!(x <= 0 || r.hasNext(from + x) && this.isDigitChar(r.peekChar(from + x)))) {
            try {
                Integer.parseInt(s.toString());
                return s.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean readEnd(StringReaderExt r) {
        if (!r.hasNext()) {
            return true;
        }
        if (r.peekChar() == ' ' || r.peekChar() == ':') {
            if (r.hasNext(1)) {
                return false;
            }
            r.nextChars(1);
            return true;
        }
        return false;
    }

    public NutsTextStyle parseSimpleNutsTextStyle(String str) {
        StringReaderExt e = new StringReaderExt(str);
        NutsTextStyle a = this.readNext(e);
        if (a == null) {
            return null;
        }
        if (e.hasNext()) {
            return null;
        }
        return a;
    }

    private NutsTextStyle readNext(StringReaderExt r) {
        if (r.hasNext()) {
            char c = r.peekChar();
            switch (c) {
                case 'F': 
                case 'f': {
                    boolean fx;
                    boolean bl = fx = r.hasNext(8) && r.peekChar(0) == 'f' && r.peekChar(1) == 'x' && this.isHexaChar(r.peekChar(2)) && this.isHexaChar(r.peekChar(3)) && this.isHexaChar(r.peekChar(4)) && this.isHexaChar(r.peekChar(5)) && this.isHexaChar(r.peekChar(6)) && this.isHexaChar(r.peekChar(7));
                    if (fx) {
                        String s = r.nextChars(8);
                        return NutsTextStyle.foregroundTrueColor((int)Integer.parseInt(s.substring(2), 16));
                    }
                    String variant = this.peekInt(r, 1, 3);
                    if (variant == null) break;
                    r.nextChars(1 + variant.length());
                    return NutsTextStyle.foregroundColor((int)Integer.parseInt(variant));
                }
                case 'B': 
                case 'b': {
                    boolean fx;
                    boolean bl = fx = r.hasNext(8) && r.peekChar(0) == 'f' && r.peekChar(1) == 'x' && this.isHexaChar(r.peekChar(2)) && this.isHexaChar(r.peekChar(3)) && this.isHexaChar(r.peekChar(4)) && this.isHexaChar(r.peekChar(5)) && this.isHexaChar(r.peekChar(6)) && this.isHexaChar(r.peekChar(7));
                    if (fx) {
                        String s = r.nextChars(8);
                        return NutsTextStyle.backgroundTrueColor((int)Integer.parseInt(s.substring(2), 16));
                    }
                    String variant = this.peekInt(r, 1, 3);
                    if (variant == null) break;
                    r.nextChars(1 + variant.length());
                    return NutsTextStyle.backgroundColor((int)Integer.parseInt(variant));
                }
                case '/': {
                    r.nextChar();
                    return NutsTextStyle.italic();
                }
                case '+': {
                    r.nextChar();
                    return NutsTextStyle.bold();
                }
                case '%': {
                    r.nextChar();
                    return NutsTextStyle.blink();
                }
                case '_': {
                    r.nextChar();
                    return NutsTextStyle.underlined();
                }
                case '-': {
                    r.nextChar();
                    return NutsTextStyle.striked();
                }
                case '!': {
                    r.nextChar();
                    return NutsTextStyle.reversed();
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    String s = this.peekInt(r, 0, 3);
                    if (s == null) break;
                    r.nextChars(s.length());
                    return NutsTextStyle.primary((int)Integer.parseInt(s));
                }
            }
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                return this.readWordNumber(r);
            }
        }
        return null;
    }
}

