/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text.bloc;

import java.io.StringReader;
import java.util.ArrayList;
import net.thevpc.nuts.NutsCodeFormat;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.collections.EvictingQueue;
import net.thevpc.nuts.runtime.bundles.parsers.StreamTokenizerExt;

public class XmlCodeFormatter
implements NutsCodeFormat {
    private NutsWorkspace ws;
    NutsTextManager factory;

    public XmlCodeFormatter(NutsWorkspace ws) {
        this.ws = ws;
        this.factory = ws.text();
    }

    public int getSupportLevel(NutsSupportLevelContext<String> criteria) {
        String s = (String)criteria.getConstraints();
        return "xml".equals(s) ? 10 : -1;
    }

    public NutsText tokenToText(String text, String nodeType, NutsSession session) {
        this.factory.setSession(session);
        switch (NutsUtilStrings.trim((String)nodeType).toLowerCase()) {
            case "name": {
                return this.formatNodeName(text);
            }
            case "attribute": {
                return this.formatNodeName(text);
            }
            case "string": {
                return this.formatNodeString(text);
            }
            case "<": 
            case "<?": 
            case "</": 
            case ">": 
            case "&": 
            case "=": 
            case "separator": {
                return this.formatNodeSeparator(text);
            }
        }
        return this.factory.forPlain(text);
    }

    public NutsText formatNodeName(String text) {
        return this.factory.forStyled((NutsText)this.factory.forPlain(text), NutsTextStyle.keyword());
    }

    public NutsText formatNodeString(String text) {
        return this.factory.forStyled((NutsText)this.factory.forPlain(text), NutsTextStyle.string());
    }

    public NutsText formatNodeSeparator(String text) {
        return this.factory.forStyled((NutsText)this.factory.forPlain(text), NutsTextStyle.separator());
    }

    public NutsText stringToText(String text, NutsSession session) {
        int s;
        this.factory.setSession(session);
        StreamTokenizerExt st = new StreamTokenizerExt(new StringReader(text));
        st.xmlComments(true);
        st.doNotParseNumbers();
        st.wordChars(48, 57);
        st.wordChars(46, 46);
        st.wordChars(45, 45);
        ArrayList<Object> nodes = new ArrayList<Object>();
        EvictingQueue<String> last = new EvictingQueue<String>(3);
        while ((s = st.nextToken()) != -1) {
            switch (s) {
                case -6: {
                    nodes.add(this.factory.forPlain(st.image));
                    break;
                }
                case -5: {
                    nodes.add(this.factory.forStyled((NutsText)this.factory.forPlain(st.image), NutsTextStyle.comments()));
                    break;
                }
                case -4: 
                case -2: {
                    nodes.add(this.factory.forStyled((NutsText)this.factory.forPlain(st.image), NutsTextStyle.number()));
                    break;
                }
                case -3: {
                    if (last.size() > 0 && ((String)last.get(last.size() - 1)).equals("<")) {
                        nodes.add(this.formatNodeName(st.image));
                        break;
                    }
                    if (last.size() > 1 && ((String)last.get(last.size() - 2)).equals("<") && ((String)last.get(last.size() - 1)).equals("/")) {
                        nodes.add(this.formatNodeName(st.image));
                        break;
                    }
                    if (last.size() > 1 && ((String)last.get(last.size() - 2)).equals("<") && ((String)last.get(last.size() - 1)).equals("?")) {
                        nodes.add(this.formatNodeName(st.image));
                        break;
                    }
                    if (st.image.equals("true") || st.image.equals("false")) {
                        nodes.add(this.formatNodeName(st.image));
                        break;
                    }
                    nodes.add(this.factory.forPlain(st.image));
                    break;
                }
                case 39: {
                    nodes.add(this.formatNodeString(st.image));
                    break;
                }
                case 34: {
                    nodes.add(this.formatNodeString(st.image));
                    break;
                }
                case 38: 
                case 60: 
                case 61: 
                case 62: {
                    nodes.add(this.factory.forStyled((NutsText)this.factory.forPlain(st.image), NutsTextStyle.separator()));
                    break;
                }
                default: {
                    nodes.add(this.factory.forStyled((NutsText)this.factory.forPlain(st.image), NutsTextStyle.separator()));
                }
            }
            last.add(st.image == null ? "" : st.image);
        }
        return this.factory.forList(nodes).simplify();
    }
}

