/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text.bloc;

import java.util.ArrayList;
import java.util.Arrays;
import net.thevpc.nuts.NutsCodeFormat;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextPlain;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextType;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.parsers.StringReaderExt;
import net.thevpc.nuts.runtime.core.format.text.bloc.StringReaderExtUtils;

public class JsonCodeFormatter
implements NutsCodeFormat {
    private NutsWorkspace ws;
    private NutsTextManager factory;

    public JsonCodeFormatter(NutsWorkspace ws) {
        this.ws = ws;
        this.factory = ws.text();
    }

    public NutsText tokenToText(String text, String nodeType, NutsSession session) {
        this.factory.setSession(session);
        return this.factory.forPlain(text);
    }

    public int getSupportLevel(NutsSupportLevelContext<String> criteria) {
        String s = (String)criteria.getConstraints();
        return "json".equals(s) ? 10 : -1;
    }

    public NutsText stringToText(String text, NutsSession session) {
        this.factory.setSession(session);
        ArrayList<Object> all = new ArrayList<Object>();
        StringReaderExt ar = new StringReaderExt(text);
        block15: while (ar.hasNext()) {
            NutsText[] d;
            switch (ar.peekChar()) {
                case ':': 
                case '{': 
                case '}': {
                    all.add(this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                    continue block15;
                }
                case '\'': {
                    all.addAll(Arrays.asList(StringReaderExtUtils.readJSSimpleQuotes(session, ar)));
                    continue block15;
                }
                case '\"': {
                    all.addAll(Arrays.asList(StringReaderExtUtils.readJSDoubleQuotesString(session, ar)));
                    continue block15;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    all.addAll(Arrays.asList(StringReaderExtUtils.readNumber(session, ar)));
                    continue block15;
                }
                case '-': 
                case '.': {
                    d = StringReaderExtUtils.readNumber(session, ar);
                    if (d != null) {
                        all.addAll(Arrays.asList(d));
                        continue block15;
                    }
                    all.add(this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                    continue block15;
                }
                case '/': {
                    if (ar.peekChars("//")) {
                        all.addAll(Arrays.asList(StringReaderExtUtils.readSlashSlashComments(session, ar)));
                        continue block15;
                    }
                    if (ar.peekChars("/*")) {
                        all.addAll(Arrays.asList(StringReaderExtUtils.readSlashStarComments(session, ar)));
                        continue block15;
                    }
                    all.add(this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                    continue block15;
                }
            }
            if (Character.isWhitespace(ar.peekChar())) {
                all.addAll(Arrays.asList(StringReaderExtUtils.readSpaces(session, ar)));
                continue;
            }
            d = StringReaderExtUtils.readJSIdentifier(session, ar);
            if (d != null) {
                if (d.length == 1 && d[0].getType() == NutsTextType.PLAIN) {
                    String txt;
                    switch (txt = ((NutsTextPlain)d[0]).getText()) {
                        case "true": 
                        case "false": {
                            d[0] = this.factory.forStyled(d[0], NutsTextStyle.keyword());
                        }
                    }
                }
                all.addAll(Arrays.asList(d));
                continue;
            }
            all.add(this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
        }
        return this.factory.forList(all.toArray(new NutsText[0]));
    }
}

