/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.core.format.text.bloc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import net.thevpc.nuts.NutsCodeFormat;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextPlain;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextType;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.parsers.StringReaderExt;
import net.thevpc.nuts.runtime.core.format.text.bloc.StringReaderExtUtils;

public class JavaBlocTextFormatter
implements NutsCodeFormat {
    private static Set<String> reservedWords = new LinkedHashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "double", "do", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"));
    private NutsWorkspace ws;
    private NutsTextManager factory;

    public JavaBlocTextFormatter(NutsWorkspace ws) {
        this.ws = ws;
        this.factory = ws.text();
    }

    public NutsText tokenToText(String text, String nodeType, NutsSession session) {
        return this.factory.setSession(session).forPlain(text);
    }

    public int getSupportLevel(NutsSupportLevelContext<String> criteria) {
        String s = (String)criteria.getConstraints();
        return "java".equals(s) ? 10 : -1;
    }

    public NutsText stringToText(String text, NutsSession session) {
        this.factory.setSession(session);
        ArrayList<Object> all = new ArrayList<Object>();
        StringReaderExt ar = new StringReaderExt(text);
        block8: while (ar.hasNext()) {
            NutsText[] d;
            switch (ar.peekChar()) {
                case '!': 
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    all.add(this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                    continue block8;
                }
                case '\'': {
                    all.addAll(Arrays.asList(StringReaderExtUtils.readJSSimpleQuotes(session, ar)));
                    continue block8;
                }
                case '\"': {
                    all.addAll(Arrays.asList(StringReaderExtUtils.readJSDoubleQuotesString(session, ar)));
                    continue block8;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    all.addAll(Arrays.asList(StringReaderExtUtils.readNumber(session, ar)));
                    continue block8;
                }
                case '-': 
                case '.': {
                    d = StringReaderExtUtils.readNumber(session, ar);
                    if (d != null) {
                        all.addAll(Arrays.asList(d));
                        continue block8;
                    }
                    all.add(this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                    continue block8;
                }
                case '/': {
                    if (ar.peekChars("//")) {
                        all.addAll(Arrays.asList(StringReaderExtUtils.readSlashSlashComments(session, ar)));
                        continue block8;
                    }
                    if (ar.peekChars("/*")) {
                        all.addAll(Arrays.asList(StringReaderExtUtils.readSlashStarComments(session, ar)));
                        continue block8;
                    }
                    all.add(this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
                    continue block8;
                }
            }
            if (Character.isWhitespace(ar.peekChar())) {
                all.addAll(Arrays.asList(StringReaderExtUtils.readSpaces(session, ar)));
                continue;
            }
            d = StringReaderExtUtils.readJSIdentifier(session, ar);
            if (d != null) {
                String txt;
                if (d.length == 1 && d[0].getType() == NutsTextType.PLAIN && reservedWords.contains(txt = ((NutsTextPlain)d[0]).getText())) {
                    d[0] = this.factory.forStyled(d[0], NutsTextStyle.keyword());
                }
                all.addAll(Arrays.asList(d));
                continue;
            }
            all.add(this.factory.forStyled(String.valueOf(ar.nextChar()), NutsTextStyle.separator()));
        }
        return this.factory.forList(all.toArray(new NutsText[0]));
    }
}

